/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Order(value=3)
@WebFilter(filterName="performanceFilter", urlPatterns={"/*"})
public class UrlPerformanceFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(UrlPerformanceFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.debug("[performance] performance init.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String params = this.formatParameters(request);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        stopWatch.stop();
        LOG.debug("[performance] {uri:" + request.getRequestURI() + ", time :" + stopWatch.getTotalTimeMillis() + ", params:" + params + "}");
    }

    private String formatParameters(HttpServletRequest request) {
        StringBuilder parameters = new StringBuilder();
        Map paramsMap = request.getParameterMap();
        if (paramsMap != null && !paramsMap.isEmpty()) {
            for (Map.Entry entry : paramsMap.entrySet()) {
                parameters.append((String)entry.getKey()).append(":").append(StringUtils.arrayToDelimitedString((Object[])((Object[])entry.getValue()), (String)",")).append(";");
            }
        }
        return parameters.toString();
    }

    public void destroy() {
        LOG.debug("[performance] performance destroy.");
    }
}

