/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.cryptor;

import com.spring.boxes.dollar.support.cryptor.SkipConstants;
import java.nio.ByteBuffer;
import org.apache.commons.codec.binary.Base64;

public class SkipJack {
    private static final long LONG_BYTES = 8L;
    private final int[] secretKey;

    private SkipJack(int[] secretStr) {
        this.secretKey = secretStr;
    }

    public static SkipJack of(int[] secretStr) {
        return new SkipJack(secretStr);
    }

    public static long encrypt(long message, int[] key) {
        int stepcounter;
        long state = message;
        for (stepcounter = 0; stepcounter < 8; ++stepcounter) {
            state = SkipJack.roundA(stepcounter, key, state);
        }
        while (stepcounter < 16) {
            state = SkipJack.roundB(stepcounter, key, state);
            ++stepcounter;
        }
        while (stepcounter < 24) {
            state = SkipJack.roundA(stepcounter, key, state);
            ++stepcounter;
        }
        while (stepcounter < 32) {
            state = SkipJack.roundB(stepcounter, key, state);
            ++stepcounter;
        }
        return state;
    }

    public static long decrypt(long message, int[] key) {
        int stepcounter;
        long state = message;
        for (stepcounter = 31; stepcounter > 23; --stepcounter) {
            state = SkipJack.roundBPrime(stepcounter, key, state);
        }
        while (stepcounter > 15) {
            state = SkipJack.roundAprime(stepcounter, key, state);
            --stepcounter;
        }
        while (stepcounter > 7) {
            state = SkipJack.roundBPrime(stepcounter, key, state);
            --stepcounter;
        }
        while (stepcounter > -1) {
            state = SkipJack.roundAprime(stepcounter, key, state);
            --stepcounter;
        }
        return state;
    }

    private static long roundA(int step, int[] key, long block) {
        long w_1i = block >>> 48;
        long w_2i = block >> 32 & 0xFFFFL;
        long w_3i = block >> 16 & 0xFFFFL;
        long w_4i = block & 0xFFFFL;
        long w_1o = SkipJack.G(step, key, w_1i) ^ w_4i ^ (long)(step + 1);
        long w_2o = SkipJack.G(step, key, w_1i);
        long w_3o = w_2i;
        long w_4o = w_3i;
        return w_1o << 48 | w_2o << 32 | w_3o << 16 | w_4o;
    }

    private static long roundB(int step, int[] key, long block) {
        long w_4i;
        long w_1i = block >>> 48;
        long w_2i = block >> 32 & 0xFFFFL;
        long w_3i = block >> 16 & 0xFFFFL;
        long w_1o = w_4i = block & 0xFFFFL;
        long w_2o = SkipJack.G(step, key, w_1i);
        long w_3o = w_1i ^ w_2i ^ (long)(step + 1);
        long w_4o = w_3i;
        return w_1o << 48 | w_2o << 32 | w_3o << 16 | w_4o;
    }

    private static long roundAprime(int step, int[] key, long block) {
        long w_1i = block >>> 48;
        long w_2i = block >> 32 & 0xFFFFL;
        long w_3i = block >> 16 & 0xFFFFL;
        long w_4i = block & 0xFFFFL;
        long w_1o = SkipJack.Gprime(step, key, w_2i);
        long w_2o = w_3i;
        long w_3o = w_4i;
        long w_4o = w_1i ^ w_2i ^ (long)(step + 1);
        return w_1o << 48 | w_2o << 32 | w_3o << 16 | w_4o;
    }

    private static long roundBPrime(int step, int[] key, long block) {
        long w_1i = block >>> 48;
        long w_2i = block >> 32 & 0xFFFFL;
        long w_3i = block >> 16 & 0xFFFFL;
        long w_4i = block & 0xFFFFL;
        long w_1o = SkipJack.Gprime(step, key, w_2i);
        long w_2o = SkipJack.Gprime(step, key, w_2i) ^ w_3i ^ (long)(step + 1);
        long w_3o = w_4i;
        long w_4o = w_1i;
        return w_1o << 48 | w_2o << 32 | w_3o << 16 | w_4o;
    }

    private static long G(int step, int[] key, long w) {
        int g_1 = (int)(w >>> 8);
        int g_2 = (int)(w & 0xFFL);
        int cv0 = key[step * 4 % 10];
        int cv1 = key[(step * 4 + 1) % 10];
        int cv2 = key[(step * 4 + 2) % 10];
        int cv3 = key[(step * 4 + 3) % 10];
        int g_3 = SkipConstants.F[g_2 ^ cv0] ^ g_1;
        int g_4 = SkipConstants.F[g_3 ^ cv1] ^ g_2;
        int g_5 = SkipConstants.F[g_4 ^ cv2] ^ g_3;
        int g_6 = SkipConstants.F[g_5 ^ cv3] ^ g_4;
        return (long)g_5 << 8 | (long)g_6;
    }

    private static long Gprime(int step, int[] key, long w) {
        int g_1 = (int)(w & 0xFFL);
        int g_2 = (int)(w >>> 8);
        int cv0 = key[(step * 4 + 3) % 10];
        int cv1 = key[(step * 4 + 2) % 10];
        int cv2 = key[(step * 4 + 1) % 10];
        int cv3 = key[step * 4 % 10];
        int g_3 = SkipConstants.F[g_2 ^ cv0] ^ g_1;
        int g_4 = SkipConstants.F[g_3 ^ cv1] ^ g_2;
        int g_5 = SkipConstants.F[g_4 ^ cv2] ^ g_3;
        int g_6 = SkipConstants.F[g_5 ^ cv3] ^ g_4;
        return (long)g_6 << 8 | (long)g_5;
    }

    public String encodeBase64URLSafeStringLong(long value) {
        long encoded = SkipJack.encrypt(value, this.secretKey);
        byte[] rawData = ByteBuffer.allocate(8).putLong(encoded).array();
        return Base64.encodeBase64URLSafeString((byte[])rawData);
    }

    public long decodeBase64Long(String value) {
        byte[] encrypted = Base64.decodeBase64((String)value);
        if (encrypted == null || (long)encrypted.length != 8L) {
            throw new RuntimeException("fail to decode: " + value);
        }
        long encoded = ByteBuffer.wrap(encrypted).getLong();
        return SkipJack.decrypt(encoded, this.secretKey);
    }
}

