/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.filter;

import com.spring.boxes.dollar.term.ClientInfo;
import com.spring.boxes.dollar.term.ScopeKey;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.util.StopWatch;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=20)
public class UserRequestInfoFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserRequestInfoFilter.class);

    protected void doFilterInternal(HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (request.getRequestURI().equals("/")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String userAgent = request.getHeader("User-Agent");
        UserAgent agent = UserAgent.parseUserAgentString((String)userAgent);
        ClientInfo clientInfo = ClientInfo.builder().appId(ScopeKey.getAppId()).userId(ScopeKey.getUserId()).deviceId(UUID.randomUUID().toString()).locale(Locale.getDefault().toString()).userAgent(agent).build();
        ScopeKey.CLIENT_INFO.set((Object)clientInfo);
        stopWatch.stop();
        log.debug("[UserRequestInfo] [{}.clientInfo] [{}ms]", (Object)request.getRequestURI(), (Object)stopWatch.getLastTaskTimeMillis());
        stopWatch.start();
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        stopWatch.stop();
        log.debug("[UserRequestInfo] [{}.httpHandle] [{}ms]", (Object)request.getRequestURI(), (Object)stopWatch.getLastTaskTimeMillis());
    }
}

