/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.locale;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public enum I18NCurrencyEnum {
    CNY("CNY", "\u00a5", "\u4eba\u6c11\u5e01"),
    USD("USD", "$", "\u7f8e\u5143"),
    HKD("HKD", "HK$", "\u6e2f\u5e01"),
    JPY("JPY", "\u00a5", "\u65e5\u5e01"),
    SGD("SGD", "$", "\u65b0\u5e01"),
    EUR("EUR", "\u20ac", "\u6b27\u5143"),
    KRW("KRW", "KRW", "\u97e9\u5e01");

    private static final Map<String, I18NCurrencyEnum> CURRENCY_ENUM_MAP;
    private static final Set<I18NCurrencyEnum> MIN_UNIT_YUAN;
    private final String currency;
    private final String symbol;
    private final String brief;

    private I18NCurrencyEnum(String currency, String symbol, String brief) {
        this.currency = currency;
        this.symbol = symbol;
        this.brief = brief;
    }

    public static I18NCurrencyEnum getCurrencyEnumBy(String currency) {
        return CURRENCY_ENUM_MAP.get(currency);
    }

    public static Map<String, I18NCurrencyEnum> getCurrencyEnumMap() {
        return CURRENCY_ENUM_MAP;
    }

    public static Set<I18NCurrencyEnum> getMinUnitYuanCurrency() {
        return MIN_UNIT_YUAN;
    }

    public static boolean isMinUnitYuanCurrency(String currency) {
        if (currency == null) {
            return false;
        }
        return MIN_UNIT_YUAN.stream().anyMatch(p -> p.getCurrency().equals(currency.toUpperCase()));
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getSymbol() {
        return this.symbol;
    }

    @Generated
    public String getBrief() {
        return this.brief;
    }

    static {
        HashMap temp = Maps.newHashMapWithExpectedSize((int)128);
        for (I18NCurrencyEnum currencyEnum : EnumSet.allOf(I18NCurrencyEnum.class)) {
            temp.put(currencyEnum.currency, currencyEnum);
        }
        CURRENCY_ENUM_MAP = ImmutableMap.copyOf((Map)temp);
        MIN_UNIT_YUAN = ImmutableSet.of((Object)((Object)KRW), (Object)((Object)JPY));
    }
}

