/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.locale;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum I18NLanguageEnum {
    EN("en", "\u82f1\u6587"),
    JP("ja", "\u65e5\u6587"),
    ZH("zh", "\u4e2d\u6587"),
    ZH_CN("zh-CN", "\u4e2d\u6587\u7b80\u4f53"),
    ZH_SG("zh-SG", "\u7b80\u4f53\u4e2d\u6587(\u65b0\u52a0\u5761)"),
    ZH_MY("zh-MY", "\u7b80\u4f53\u4e2d\u6587(\u9a6c\u6765\u897f\u4e9a)"),
    ZH_TW("zh-TW", "\u7e41\u4f53\u4e2d\u6587"),
    ZH_TW2("zh-TW2", "\u7e41\u4f53\u4e2d\u6587(\u53f0\u6e7e)"),
    ZH_MO("zh-MO", "\u7e41\u4f53\u4e2d\u6587(\u6fb3\u95e8)"),
    EN_SG("en-SG", "\u82f1\u6587(\u65b0\u52a0\u5761)"),
    EN_MY("en-MY", "\u82f1\u6587(\u9a6c\u6765\u897f\u4e9a)"),
    JA("ja", "\u65e5\u6587"),
    ITALIAN("ITALIAN", "\u610f\u5927\u5229\u8bed");

    private static final Map<String, I18NLanguageEnum> LANGUAGE_ENUM_MAP;
    private final String language;
    private final String brief;

    private I18NLanguageEnum(String language, String brief) {
        this.language = language;
        this.brief = brief;
    }

    public static I18NLanguageEnum getByLanguage(String language) {
        return LANGUAGE_ENUM_MAP.get(language);
    }

    public static Map<String, I18NLanguageEnum> getLanguageEnumMap() {
        return LANGUAGE_ENUM_MAP;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getBrief() {
        return this.brief;
    }

    static {
        HashMap temp = Maps.newHashMapWithExpectedSize((int)128);
        for (I18NLanguageEnum languageEnum : EnumSet.allOf(I18NLanguageEnum.class)) {
            temp.put(languageEnum.language, languageEnum);
        }
        LANGUAGE_ENUM_MAP = ImmutableMap.copyOf((Map)temp);
    }
}

