/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.locale;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.spring.boxes.dollar.support.locale.I18NCurrencyEnum;
import com.spring.boxes.dollar.support.locale.I18NLanguageEnum;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public enum I18NRegionEnum {
    US("US", "1", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7f8e\u56fd"),
    CHINA("CN", "86", I18NLanguageEnum.ZH, I18NCurrencyEnum.CNY, "\u4e2d\u56fd"),
    HONG_KONG("HK", "852", I18NLanguageEnum.ZH_TW, I18NCurrencyEnum.HKD, "\u4e2d\u56fd\u9999\u6e2f"),
    TAI_WAN("TW", "886", I18NLanguageEnum.ZH_TW2, I18NCurrencyEnum.USD, "\u4e2d\u56fd\u53f0\u6e7e"),
    MACAO("MO", "853", I18NLanguageEnum.ZH_MO, I18NCurrencyEnum.USD, "\u4e2d\u56fd\u6fb3\u95e8"),
    JAPANESE("JP", "81", I18NLanguageEnum.JA, I18NCurrencyEnum.JPY, "\u65e5\u672c"),
    SINGAPORE("SG", "65", I18NLanguageEnum.EN, I18NCurrencyEnum.SGD, "\u65b0\u52a0\u5761"),
    MALAYSIA("MY", "60", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9a6c\u6765\u897f\u4e9a"),
    IT("IT", "39", I18NLanguageEnum.ITALIAN, I18NCurrencyEnum.EUR, "\u610f\u5927\u5229"),
    AFGHANISTAN("AF", "93", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u963f\u5bcc\u6c57"),
    ALBANIA("AL", "355", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u963f\u5c14\u5df4\u5c3c\u4e9a"),
    ALGERIA("DZ", "213", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u963f\u5c14\u53ca\u5229\u4e9a"),
    AMERICAN_SAMOA("AS", "1684", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7f8e\u5c5e\u8428\u6469\u4e9a"),
    ANDORRA("AD", "376", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5b89\u9053\u5c14"),
    ANGOLA("AO", "244", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5b89\u54e5\u62c9"),
    ANGUILLA("AI", "1264", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5b89\u572d\u62c9"),
    ANTIGUA_AND_BARBUDA("AG", "1268", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe"),
    ARGENTINA("AR", "54", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u963f\u6839\u5ef7"),
    ARMENIA("AM", "374", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e9a\u7f8e\u5c3c\u4e9a"),
    ARUBA("AW", "297", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u963f\u9c81\u5df4"),
    AUSTRALIA("AU", "61", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6fb3\u5927\u5229\u4e9a"),
    AUSTRIA("AT", "43", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5965\u5730\u5229"),
    AZERBAIJAN("AZ", "994", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u963f\u585e\u62dc\u7586"),
    BAHAMAS("BS", "1242", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5df4\u54c8\u9a6c"),
    BAHRAIN("BH", "973", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5df4\u6797"),
    BANGLADESH("BD", "880", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5b5f\u52a0\u62c9\u56fd"),
    BARBADOS("BB", "1246", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5df4\u5df4\u591a\u65af"),
    BELARUS("BY", "375", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u767d\u4fc4\u7f57\u65af"),
    BELGIUM("BE", "32", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6bd4\u5229\u65f6"),
    BELIZE("BZ", "501", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4f2f\u5229\u5179"),
    BENIN("BJ", "229", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8d1d\u5b81"),
    BERMUDA("BM", "1441", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u767e\u6155\u5927\u7fa4\u5c9b"),
    BHUTAN("BT", "975", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e0d\u4e39"),
    BOLIVIA("BO", "591", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u73bb\u5229\u7ef4\u4e9a"),
    BOSNIA_AND_HERZEGOVINA("BA", "387", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3"),
    BOTSWANA("BW", "267", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u535a\u8328\u74e6\u7eb3"),
    BRAZIL("BR", "55", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5df4\u897f"),
    BRUNEI("BN", "673", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6587\u83b1"),
    BULGARIA("BG", "359", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4fdd\u52a0\u5229\u4e9a"),
    BURKINA_FASO("BF", "226", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5e03\u57fa\u7eb3\u6cd5\u7d22"),
    BURUNDI("BI", "257", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5e03\u9686\u8fea"),
    CAMBODIA("KH", "855", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u67ec\u57d4\u5be8"),
    CAMEROON("CM", "237", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5580\u9ea6\u9686"),
    CANADA("CA", "1", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u52a0\u62ff\u5927"),
    CAPE_VERDE("CV", "238", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5f00\u666e"),
    CAYMAN_ISLANDS("KY", "1345", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5f00\u66fc\u7fa4\u5c9b"),
    CENTRAL_AFRICAN_REPUBLIC("CF", "236", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e2d\u975e\u5171\u548c\u56fd"),
    CHAD("TD", "235", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e4d\u5f97"),
    CHILE("CL", "56", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u667a\u5229"),
    COLOMBIA("CO", "57", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u54e5\u4f26\u6bd4\u4e9a"),
    COMOROS("KM", "269", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u79d1\u6469\u7f57"),
    COOK_ISLANDS("CK", "682", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5e93\u514b\u7fa4\u5c9b"),
    COSTA_RICA("CR", "506", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u54e5\u65af\u8fbe\u9ece\u52a0"),
    CROATIA("HR", "385", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u514b\u7f57\u5730\u4e9a"),
    CUBA("CU", "53", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u53e4\u5df4"),
    CURACAO("CW", "599", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5e93\u62c9\u7d22"),
    CYPRUS("CY", "357", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u585e\u6d66\u8def\u65af"),
    CZECH("CZ", "420", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6377\u514b"),
    DEMOCRATIC_REPUBLIC_OF_THE_CONGO("CD", "243", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u521a\u679c\u6c11\u4e3b\u5171\u548c\u56fd"),
    DENMARK("DK", "45", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e39\u9ea6"),
    DJIBOUTI("DJ", "253", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5409\u5e03\u63d0"),
    DOMINICA("DM", "1767", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u591a\u7c73\u5c3c\u52a0"),
    DOMINICAN_REPUBLIC("DO", "1809", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd"),
    ECUADOR("EC", "593", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5384\u74dc\u591a\u5c14"),
    EGYPT("EG", "20", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u57c3\u53ca"),
    EL_SALVADOR("SV", "503", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8428\u5c14\u74e6\u591a"),
    EQUATORIAL_GUINEA("GQ", "240", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8d64\u9053\u51e0\u5185\u4e9a"),
    ERITREA("ER", "291", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5384\u7acb\u7279\u91cc\u4e9a"),
    ESTONIA("EE", "372", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7231\u6c99\u5c3c\u4e9a"),
    ETHIOPIA("ET", "251", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u57c3\u585e\u4fc4\u6bd4\u4e9a"),
    FAROE_ISLANDS("FO", "298", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6cd5\u7f57\u7fa4\u5c9b"),
    FIJI("FJ", "679", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6590\u6d4e"),
    FINLAND("FI", "358", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u82ac\u5170"),
    FRANCE("FR", "33", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6cd5\u56fd"),
    FRENCH_GUIANA("GF", "594", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6cd5\u5c5e\u572d\u4e9a\u90a3"),
    FRENCH_POLYNESIA("PF", "689", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a"),
    GABON("GA", "241", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u52a0\u84ec"),
    GAMBIA("GM", "220", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5188\u6bd4\u4e9a"),
    GEORGIA("GE", "995", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u683c\u9c81\u5409\u4e9a"),
    GERMANY("DE", "49", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5fb7\u56fd"),
    GHANA("GH", "233", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u52a0\u7eb3"),
    GIBRALTAR("GI", "350", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u76f4\u5e03\u7f57\u9640"),
    GREECE("GR", "30", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5e0c\u814a"),
    GREENLAND("GL", "299", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u683c\u9675\u5170\u5c9b"),
    GRENADA("GD", "1473", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u683c\u6797\u7eb3\u8fbe"),
    GUADELOUPE("GP", "590", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u74dc\u5fb7\u7f57\u666e\u5c9b"),
    GUAM("GU", "1671", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5173\u5c9b"),
    GUATEMALA("GT", "502", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u74dc\u5730\u9a6c\u62c9"),
    GUINEA("GN", "224", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u51e0\u5185\u4e9a"),
    GUINEA_BISSAU("GW", "245", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u51e0\u5185\u4e9a\u6bd4\u7ecd\u5171\u548c\u56fd"),
    GUYANA("GY", "592", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u572d\u4e9a\u90a3"),
    HAITI("HT", "509", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6d77\u5730"),
    HONDURAS("HN", "504", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6d2a\u90fd\u62c9\u65af"),
    HUNGARY("HU", "36", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5308\u7259\u5229"),
    ICELAND("IS", "354", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u51b0\u5c9b"),
    INDIA("IN", "91", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5370\u5ea6"),
    INDONESIA("ID", "62", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5370\u5ea6\u5c3c\u897f\u4e9a"),
    IRAN("IR", "98", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4f0a\u6717"),
    IRAQ("IQ", "964", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4f0a\u62c9\u514b"),
    IRELAND("IE", "353", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7231\u5c14\u5170"),
    ISRAEL("IL", "972", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4ee5\u8272\u5217"),
    IVORY_COAST("CI", "225", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8c61\u7259\u6d77\u5cb8"),
    JAMAICA("JM", "1876", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7259\u4e70\u52a0"),
    JORDAN("JO", "962", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7ea6\u65e6"),
    KAZAKHSTAN("KZ", "7", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u54c8\u8428\u514b\u65af\u5766"),
    KENYA("KE", "254", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u80af\u5c3c\u4e9a"),
    KIRIBATI("KI", "686", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u57fa\u91cc\u5df4\u65af"),
    KUWAIT("KW", "965", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u79d1\u5a01\u7279"),
    KYRGYZSTAN("KG", "996", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5409\u5c14\u5409\u65af\u65af\u5766"),
    LAOS("LA", "856", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8001\u631d"),
    LATVIA("LV", "371", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u62c9\u8131\u7ef4\u4e9a"),
    LEBANON("LB", "961", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9ece\u5df4\u5ae9"),
    LESOTHO("LS", "266", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u83b1\u7d22\u6258"),
    LIBERIA("LR", "231", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5229\u6bd4\u91cc\u4e9a"),
    LIBYA("LY", "218", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5229\u6bd4\u4e9a"),
    LIECHTENSTEIN("LI", "423", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5217\u652f\u6566\u58eb\u767b"),
    LITHUANIA("LT", "370", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7acb\u9676\u5b9b"),
    LUXEMBOURG("LU", "352", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5362\u68ee\u5821"),
    MACEDONIA("MK", "389", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9a6c\u5176\u987f"),
    MADAGASCAR("MG", "261", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9a6c\u8fbe\u52a0\u65af\u52a0"),
    MALAWI("MW", "265", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9a6c\u62c9\u7ef4"),
    MALDIVES("MV", "960", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9a6c\u5c14\u4ee3\u592b"),
    MALI("ML", "223", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9a6c\u91cc"),
    MALTA("MT", "356", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9a6c\u8033\u4ed6"),
    MARTINIQUE("MQ", "596", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9a6c\u63d0\u5c3c\u514b"),
    MAURITANIA("MR", "222", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6bdb\u91cc\u5854\u5c3c\u4e9a"),
    MAURITIUS("MU", "230", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6bdb\u91cc\u6c42\u65af"),
    MAYOTTE("YT", "269", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9a6c\u7ea6\u7279"),
    MEXICO("MX", "52", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u58a8\u897f\u54e5"),
    MOLDOVA("MD", "373", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6469\u5c14\u591a\u74e6"),
    MONACO("MC", "377", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6469\u7eb3\u54e5"),
    MONGOLIA("MN", "976", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8499\u53e4"),
    MONTENEGRO("ME", "382", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u9ed1\u5c71"),
    MONTSERRAT("MS", "1664", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8499\u7279\u585e\u62c9\u7279\u5c9b"),
    MOROCCO("MA", "212", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6469\u6d1b\u54e5"),
    MOZAMBIQUE("MZ", "258", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u83ab\u6851\u6bd4\u514b"),
    MYANMAR("MM", "95", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7f05\u7538"),
    NAMIBIA("NA", "264", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7eb3\u7c73\u6bd4\u4e9a"),
    NEPAL("NP", "977", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5c3c\u6cca\u5c14"),
    NETHERLANDS("NL", "31", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8377\u5170"),
    NEW_CALEDONIA("NC", "687", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a"),
    NEW_ZEALAND("NZ", "64", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u65b0\u897f\u5170"),
    NICARAGUA("NI", "505", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5c3c\u52a0\u62c9\u74dc"),
    NIGER("NE", "227", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5c3c\u65e5\u5c14"),
    NIGERIA("NG", "234", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5c3c\u65e5\u5229\u4e9a"),
    NORWAY("NO", "47", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u632a\u5a01"),
    OMAN("OM", "968", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u963f\u66fc"),
    PAKISTAN("PK", "92", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5df4\u57fa\u65af\u5766"),
    PALAU("PW", "680", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5e15\u52b3"),
    PALESTINE("BL", "970", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5df4\u52d2\u65af\u5766"),
    PANAMA("PA", "507", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5df4\u62ff\u9a6c"),
    PAPUA_NEW_GUINEA("PG", "675", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a"),
    PARAGUAY("PY", "595", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5df4\u62c9\u572d"),
    PERU("PE", "51", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u79d8\u9c81"),
    PHILIPPINES("PH", "63", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u83f2\u5f8b\u5bbe"),
    POLAND("PL", "48", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6ce2\u5170"),
    PORTUGAL("PT", "351", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8461\u8404\u7259"),
    PUERTO_RICO("PR", "1787", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6ce2\u591a\u9ece\u5404"),
    QATAR("QA", "974", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5361\u5854\u5c14"),
    REPUBLIC_OF_THE_CONGO("CG", "242", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u521a\u679c\u5171\u548c\u56fd"),
    R\u00c9UNION_ISLAND("RE", "262", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7559\u5c3c\u6c6a"),
    ROMANIA("RO", "40", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7f57\u9a6c\u5c3c\u4e9a"),
    RUSSIA("RU", "7", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4fc4\u7f57\u65af"),
    RWANDA("RW", "250", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5362\u65fa\u8fbe"),
    SAINT_KITTS_AND_NEVIS("KN", "1869", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af"),
    SAINT_LUCIA("LC", "1758", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5723\u9732\u897f\u4e9a"),
    SAINT_PIERRE_AND_MIQUELON("PM", "508", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5723\u5f7c\u57c3\u5c14\u548c\u5bc6\u514b\u9686\u5c9b"),
    SAINT_VINCENT_AND_THE_GRENADINES("VC", "1784", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af"),
    SAMOA("WS", "685", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8428\u6469\u4e9a"),
    SAN_MARINO("SM", "378", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5723\u9a6c\u529b\u8bfa"),
    SAO_TOME_AND_PRINCIPE("ST", "239", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4"),
    SAUDI_ARABIA("SA", "966", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6c99\u7279\u963f\u62c9\u4f2f"),
    SENEGAL("SN", "221", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u585e\u5185\u52a0\u5c14"),
    SERBIA("RS", "381", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u585e\u5c14\u7ef4\u4e9a"),
    SEYCHELLES("SC", "248", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u585e\u820c\u5c14"),
    SIERRA_LEONE("SL", "232", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u585e\u62c9\u5229\u6602"),
    SAINT_MAARTEN_DUTCH_PART("SX", "1721", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5723\u9a6c\u4e01\u5c9b\uff08\u8377\u5170\u90e8\u5206\uff09"),
    SLOVAKIA("SK", "421", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u65af\u6d1b\u4f10\u514b"),
    SLOVENIA("SI", "386", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u65af\u6d1b\u6587\u5c3c\u4e9a"),
    SOLOMON_ISLANDS("SB", "677", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6240\u7f57\u95e8\u7fa4\u5c9b"),
    SOMALIA("SO", "252", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7d22\u9a6c\u91cc"),
    SOUTH_AFRICA("ZA", "27", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5357\u975e"),
    SOUTH_KOREA("KR", "82", I18NLanguageEnum.ZH_TW, I18NCurrencyEnum.KRW, "\u97e9\u56fd"),
    SPAIN("ES", "34", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u897f\u73ed\u7259"),
    SRI_LANKA("LK", "94", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u65af\u91cc\u5170\u5361"),
    SUDAN("SD", "249", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u82cf\u4e39"),
    SURINAME("SR", "597", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u82cf\u91cc\u5357"),
    SWAZILAND("SZ", "268", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u65af\u5a01\u58eb\u5170"),
    SWEDEN("SE", "46", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u745e\u5178"),
    SWITZERLAND("CH", "41", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u745e\u58eb"),
    SYRIA("SY", "963", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u53d9\u5229\u4e9a"),
    TAJIKISTAN("TJ", "992", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5854\u5409\u514b\u65af\u5766"),
    TANZANIA("TZ", "255", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u5766\u6851\u5c3c\u4e9a"),
    THAILAND("TH", "66", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6cf0\u56fd"),
    TIMOR_LESTE("TL", "670", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e1c\u5e1d\u6c76"),
    TOGO("TG", "228", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u591a\u54e5"),
    TONGA("TO", "676", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6c64\u52a0"),
    TRINIDAD_AND_TOBAGO("TT", "1868", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5"),
    TUNISIA("TN", "216", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7a81\u5c3c\u65af"),
    TURKEY("TR", "90", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u571f\u8033\u5176"),
    TURKMENISTAN("TM", "993", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u571f\u5e93\u66fc\u65af\u5766"),
    TURKS_AND_CAICOS_ISLANDS("TC", "1649", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b"),
    UGANDA("UG", "256", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e4c\u5e72\u8fbe"),
    UKRAINE("UA", "380", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e4c\u514b\u5170"),
    UNITED_ARAB_EMIRATES("AE", "971", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd"),
    UNITED_KINGDOM("GB", "44", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u82f1\u56fd"),
    URUGUAY("UY", "598", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e4c\u62c9\u572d"),
    UZBEKISTAN("UZ", "998", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e4c\u5179\u522b\u514b\u65af\u5766"),
    VANUATU("VU", "678", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u74e6\u52aa\u963f\u56fe"),
    VENEZUELA("VE", "58", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u59d4\u5185\u745e\u62c9"),
    VIETNAM("VN", "84", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8d8a\u5357"),
    VIRGIN_ISLANDS_BRITISH("VG", "1340", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u82f1\u5c5e\u5904\u5973\u7fa4\u5c9b"),
    VIRGIN_ISLANDS_US("VI", "1284", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u7f8e\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b"),
    YEMEN("YE", "967", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u4e5f\u95e8"),
    ZAMBIA("ZM", "260", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u8d5e\u6bd4\u4e9a"),
    ZIMBABWE("ZW", "263", I18NLanguageEnum.EN, I18NCurrencyEnum.USD, "\u6d25\u5df4\u5e03\u97e6");

    private static final Map<String, I18NRegionEnum> REGION_ENUM_MAP;
    private static final Set<String> GLOBAL_REGION_ENUM_SET;
    private static final Set<I18NRegionEnum> MIN_UNIT_YUAN;
    public final String countryCode;
    public final String regionCode;
    public final I18NLanguageEnum defaultLanguage;
    public final I18NCurrencyEnum defaultCurrency;
    public final String brief;

    public static Map<String, I18NRegionEnum> getRegionEnumMap() {
        return REGION_ENUM_MAP;
    }

    public static Set<String> getRegionEnumSet() {
        return GLOBAL_REGION_ENUM_SET;
    }

    public static I18NRegionEnum getRegionEnumBy(String countryCode) {
        return REGION_ENUM_MAP.get(countryCode);
    }

    public static String getFormatRegionCode(String countryCode) {
        I18NRegionEnum regionEnum = I18NRegionEnum.getRegionEnumBy(countryCode);
        Preconditions.checkArgument((regionEnum != null ? 1 : 0) != 0, (Object)("not found region by " + countryCode));
        return String.format("+%s", regionEnum.regionCode);
    }

    public static boolean isSpecialRegion(String countryCode) {
        return !GLOBAL_REGION_ENUM_SET.contains(countryCode);
    }

    public static Set<I18NRegionEnum> getMinUnitYuanRegions() {
        return MIN_UNIT_YUAN;
    }

    public static boolean isMinUnitYuanRegion(String countryCode) {
        if (countryCode == null) {
            return false;
        }
        return MIN_UNIT_YUAN.stream().anyMatch(p -> p.getCountryCode().equals(countryCode.toUpperCase()));
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public String getRegionCode() {
        return this.regionCode;
    }

    @Generated
    public I18NLanguageEnum getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Generated
    public I18NCurrencyEnum getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Generated
    public String getBrief() {
        return this.brief;
    }

    @Generated
    private I18NRegionEnum(String countryCode, String regionCode, I18NLanguageEnum defaultLanguage, I18NCurrencyEnum defaultCurrency, String brief) {
        this.countryCode = countryCode;
        this.regionCode = regionCode;
        this.defaultLanguage = defaultLanguage;
        this.defaultCurrency = defaultCurrency;
        this.brief = brief;
    }

    static {
        HashMap<String, I18NRegionEnum> temp = new HashMap<String, I18NRegionEnum>();
        HashSet<I18NRegionEnum> minUnitYuanRegions = new HashSet<I18NRegionEnum>();
        for (I18NRegionEnum regionEnum : EnumSet.allOf(I18NRegionEnum.class)) {
            temp.put(regionEnum.countryCode, regionEnum);
            Set<I18NCurrencyEnum> minUnitYuanCurrency = I18NCurrencyEnum.getMinUnitYuanCurrency();
            if (!minUnitYuanCurrency.contains((Object)regionEnum.getDefaultCurrency())) continue;
            minUnitYuanRegions.add(regionEnum);
        }
        REGION_ENUM_MAP = ImmutableMap.copyOf(temp);
        HashSet tempSet = new HashSet();
        String[] specialRegion = new String[]{"HK", "TW", "MO", "JP", "US", "KR"};
        Collections.addAll(tempSet, specialRegion);
        GLOBAL_REGION_ENUM_SET = ImmutableSet.copyOf(tempSet);
        MIN_UNIT_YUAN = ImmutableSet.copyOf(minUnitYuanRegions);
    }
}

