/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.logger;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.JoiningUtils;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggerTruck
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggerTruck.class);
    private static final Integer TAGS_SIZE = 1024;
    private static String LOG_TRUCK = "#LOG#";
    private final Map<String, String> tagsMap = new HashMap<String, String>();

    private LoggerTruck() {
    }

    public static LoggerTruck builder() {
        return new LoggerTruck();
    }

    public LoggerTruck seed(String seed) {
        if (StringUtils.isBlank((CharSequence)seed)) {
            seed = LOG_TRUCK;
        }
        LOG_TRUCK = seed;
        return this;
    }

    public LoggerTruck tag(String k, Object v) {
        v = null == v ? (String)null : String.valueOf(v);
        return this.tag(k, String.valueOf(v));
    }

    public LoggerTruck tag(String k, boolean v) {
        return this.tag(k, v ? "true" : "false");
    }

    public LoggerTruck tag(String k, char c) {
        return this.tag(k, String.valueOf(c));
    }

    public LoggerTruck tag(String k, int v) {
        return this.tag(k, String.valueOf(v));
    }

    public LoggerTruck tag(String k, long v) {
        return this.tag(k, String.valueOf(v));
    }

    public LoggerTruck tag(String k, float v) {
        return this.tag(k, String.valueOf(v));
    }

    public LoggerTruck tag(String k, double v) {
        return this.tag(k, String.valueOf(v));
    }

    public LoggerTruck tag(String k, char[] v) {
        return this.tag(k, new String(v));
    }

    public LoggerTruck tag(String k, byte[] v) {
        return this.tag(k, new String(v, StandardCharsets.UTF_8));
    }

    public LoggerTruck tag(String k, String v) {
        k = this.colation(k);
        v = this.colation(v);
        if (StringUtils.isBlank((CharSequence)k)) {
            return this;
        }
        if (this.isTagsFull()) {
            log.error("no space left in LogTruck tags(max={}) map for {}={}", new Object[]{TAGS_SIZE, k, v});
            return this;
        }
        this.tagsMap.put(k, v);
        return this;
    }

    public LoggerTruck tag(Map<String, String> tags) {
        if (null == tags || tags.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.tag(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public LoggerTruck action(String action) {
        return this.tag("Action", action);
    }

    public Map<String, String> getTags() {
        return this.tagsMap;
    }

    public String getTag(String k) {
        return this.tagsMap.get(this.colation(k));
    }

    private String colation(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return "";
        }
        return s.replaceAll("=", "").replaceAll(" ", "");
    }

    private boolean isTagsFull() {
        if (this.getTags().isEmpty()) {
            return false;
        }
        return this.getTags().size() > TAGS_SIZE;
    }

    public String toString() {
        ArrayList list = Lists.newArrayList();
        this.getTags().forEach((k, v) -> list.add(k + "=" + v));
        return LOG_TRUCK + " = {" + StringUtils.join((Iterable)list, (String)" ") + "}";
    }

    public String build() {
        return this.toString();
    }

    public static String join(Collection<?> coll, String split) {
        return JoiningUtils.joinList(Arrays.asList(coll.toArray()), split);
    }
}

