/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.logger;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.spring.boxes.dollar.support.ratelimit.SimpleRateLimiter;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public final class RateLogger
implements Logger {
    public static final double DEFAULT_PERMITS_PER_SECOND = 1.0;
    private final Logger logger;
    private final LocationAwareLogger locationAwareLogger;
    private final SimpleRateLimiter rateLimiter;
    private final LoadingCache<String, SimpleRateLimiter> perFormatStringRateLimiter;
    private static final String FQCN = RateLogger.class.getName();
    private static final ConcurrentMap<Triple<String, Double, Boolean>, RateLogger> CACHE = new ConcurrentHashMap<Triple<String, Double, Boolean>, RateLogger>();

    private RateLogger(Logger logger, double permitsPerSecond, boolean perFormatString) {
        this.logger = logger;
        this.locationAwareLogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
        this.rateLimiter = SimpleRateLimiter.create(permitsPerSecond);
        this.perFormatStringRateLimiter = perFormatString ? Caffeine.newBuilder().maximumSize(100L).build(s -> SimpleRateLimiter.create(permitsPerSecond)) : null;
    }

    public static RateLogger rateLogger(Logger logger) {
        return RateLogger.rateLogger(logger, 1.0);
    }

    public static RateLogger rateLogger(Logger logger, double permitsPer) {
        return RateLogger.rateLogger(logger, permitsPer, false);
    }

    public static RateLogger rateLogger(Logger logger, double permitsPer, boolean perFormatString) {
        String name = logger.getName();
        Triple key = Triple.of((Object)name, (Object)permitsPer, (Object)perFormatString);
        RateLogger rateLogger = (RateLogger)CACHE.get(key);
        if (Objects.nonNull(rateLogger)) {
            return rateLogger;
        }
        return CACHE.computeIfAbsent((Triple<String, Double, Boolean>)key, it -> new RateLogger(logger, (Double)it.getMiddle(), (Boolean)it.getRight()));
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String s) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 0, this.msg(s), this.args(limiter, new Object[0]), null);
            } else {
                this.logger.trace(this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public void trace(String s, Object o) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 0, this.msg(s), this.args(limiter, o), null);
            } else {
                this.logger.trace(this.msg(s), this.args(limiter, o));
            }
        }
    }

    public void trace(String s, Object o, Object o1) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 0, this.msg(s), this.args(limiter, o, o1), null);
            } else {
                this.logger.trace(this.msg(s), this.args(limiter, o, o1));
            }
        }
    }

    public void trace(String s, Object ... objects) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 0, this.msg(s), this.args(limiter, objects), null);
            } else {
                this.logger.trace(this.msg(s), this.args(limiter, objects));
            }
        }
    }

    public void trace(String s, Throwable throwable) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 0, this.msg(s), this.args(limiter, new Object[0]), throwable);
            } else {
                this.logger.trace(this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String s) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 0, this.msg(s), this.args(limiter, new Object[0]), null);
            } else {
                this.logger.trace(marker, this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public void trace(Marker marker, String s, Object o) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 0, this.msg(s), this.args(limiter, o), null);
            } else {
                this.logger.trace(marker, this.msg(s), this.args(limiter, o));
            }
        }
    }

    public void trace(Marker marker, String s, Object o, Object o1) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 0, this.msg(s), this.args(limiter, o, o1), null);
            } else {
                this.logger.trace(marker, this.msg(s), this.args(limiter, o, o1));
            }
        }
    }

    public void trace(Marker marker, String s, Object ... objects) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 0, this.msg(s), this.args(limiter, objects), null);
            } else {
                this.logger.trace(marker, this.msg(s), this.args(limiter, objects));
            }
        }
    }

    public void trace(Marker marker, String s, Throwable throwable) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 0, this.msg(s), this.args(limiter, new Object[0]), throwable);
            } else {
                this.logger.trace(marker, this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String s) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 10, this.msg(s), this.args(limiter, new Object[0]), null);
            } else {
                this.logger.debug(this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public void debug(String s, Object o) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 10, this.msg(s), this.args(limiter, o), null);
            } else {
                this.logger.debug(this.msg(s), this.args(limiter, o));
            }
        }
    }

    public void debug(String s, Object o, Object o1) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 10, this.msg(s), this.args(limiter, o, o1), null);
            } else {
                this.logger.debug(this.msg(s), this.args(limiter, o, o1));
            }
        }
    }

    public void debug(String s, Object ... objects) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 10, this.msg(s), this.args(limiter, objects), null);
            } else {
                this.logger.debug(this.msg(s), this.args(limiter, objects));
            }
        }
    }

    public void debug(String s, Throwable throwable) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 10, this.msg(s), this.args(limiter, new Object[0]), throwable);
            } else {
                this.logger.debug(this.msg(s), this.args(limiter, throwable));
            }
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String s) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 10, this.msg(s), this.args(limiter, new Object[0]), null);
            } else {
                this.logger.debug(marker, this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public void debug(Marker marker, String s, Object o) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 10, this.msg(s), this.args(limiter, o), null);
            } else {
                this.logger.debug(marker, this.msg(s), this.args(limiter, o));
            }
        }
    }

    public void debug(Marker marker, String s, Object o, Object o1) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 10, this.msg(s), this.args(limiter, o, o1), null);
            } else {
                this.logger.debug(marker, this.msg(s), this.args(limiter, o, o1));
            }
        }
    }

    public void debug(Marker marker, String s, Object ... objects) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 10, this.msg(s), this.args(limiter, objects), null);
            } else {
                this.logger.debug(marker, this.msg(s), this.args(limiter, objects));
            }
        }
    }

    public void debug(Marker marker, String s, Throwable throwable) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 10, this.msg(s), this.args(limiter, new Object[0]), throwable);
            } else {
                this.logger.debug(marker, this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String s) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 20, this.msg(s), this.args(limiter, new Object[0]), null);
            } else {
                this.logger.info(this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public void info(String s, Object o) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 20, this.msg(s), this.args(limiter, o), null);
            } else {
                this.logger.info(this.msg(s), this.args(limiter, o));
            }
        }
    }

    public void info(String s, Object o, Object o1) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 20, this.msg(s), this.args(limiter, o, o1), null);
            } else {
                this.logger.info(this.msg(s), this.args(limiter, o, o1));
            }
        }
    }

    public void info(String s, Object ... objects) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 20, this.msg(s), this.args(limiter, objects), null);
            } else {
                this.logger.info(this.msg(s), this.args(limiter, objects));
            }
        }
    }

    public void info(String s, Throwable throwable) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 20, this.msg(s), this.args(limiter, new Object[0]), throwable);
            } else {
                this.logger.info(this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String s) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 20, this.msg(s), this.args(limiter, new Object[0]), null);
            } else {
                this.logger.info(marker, this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public void info(Marker marker, String s, Object o) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 20, this.msg(s), this.args(limiter, o), null);
            } else {
                this.logger.info(marker, this.msg(s), this.args(limiter, o));
            }
        }
    }

    public void info(Marker marker, String s, Object o, Object o1) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 20, this.msg(s), this.args(limiter, o, o1), null);
            } else {
                this.logger.info(marker, this.msg(s), this.args(limiter, o, o1));
            }
        }
    }

    public void info(Marker marker, String s, Object ... objects) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 20, this.msg(s), this.args(limiter, objects), null);
            } else {
                this.logger.info(marker, this.msg(s), this.args(limiter, objects));
            }
        }
    }

    public void info(Marker marker, String s, Throwable throwable) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 20, this.msg(s), this.args(limiter, new Object[0]), throwable);
            } else {
                this.logger.info(marker, this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String s) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 30, this.msg(s), this.args(limiter, new Object[0]), null);
            } else {
                this.logger.warn(this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public void warn(String s, Object o) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 30, this.msg(s), this.args(limiter, o), null);
            } else {
                this.logger.warn(this.msg(s), this.args(limiter, o));
            }
        }
    }

    public void warn(String s, Object ... objects) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 30, this.msg(s), this.args(limiter, objects), null);
            } else {
                this.logger.warn(this.msg(s), this.args(limiter, objects));
            }
        }
    }

    public void warn(String s, Object o, Object o1) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 30, this.msg(s), this.args(limiter, o, o1), null);
            } else {
                this.logger.warn(this.msg(s), this.args(limiter, o, o1));
            }
        }
    }

    public void warn(String s, Throwable throwable) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 30, this.msg(s), this.args(limiter, new Object[0]), throwable);
            } else {
                this.logger.warn(this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String s) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 30, this.msg(s), this.args(limiter, new Object[0]), null);
            } else {
                this.logger.warn(marker, this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public void warn(Marker marker, String s, Object o) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 30, this.msg(s), this.args(limiter, o), null);
            } else {
                this.logger.warn(marker, this.msg(s), this.args(limiter, o));
            }
        }
    }

    public void warn(Marker marker, String s, Object o, Object o1) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 30, this.msg(s), this.args(limiter, o, o1), null);
            } else {
                this.logger.warn(marker, this.msg(s), this.args(limiter, o, o1));
            }
        }
    }

    public void warn(Marker marker, String s, Object ... objects) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 30, this.msg(s), this.args(limiter, objects), null);
            } else {
                this.logger.warn(marker, this.msg(s), this.args(limiter, objects));
            }
        }
    }

    public void warn(Marker marker, String s, Throwable throwable) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 30, this.msg(s), this.args(limiter, new Object[0]), throwable);
            } else {
                this.logger.warn(marker, this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String s) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 40, this.msg(s), this.args(limiter, new Object[0]), null);
            } else {
                this.logger.error(this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public void error(String s, Object o) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 40, this.msg(s), this.args(limiter, o), null);
            } else {
                this.logger.error(this.msg(s), this.args(limiter, o));
            }
        }
    }

    public void error(String s, Object o, Object o1) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 40, this.msg(s), this.args(limiter, o, o1), null);
            } else {
                this.logger.error(this.msg(s), this.args(limiter, o, o1));
            }
        }
    }

    public void error(String s, Object ... objects) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 40, this.msg(s), this.args(limiter, objects), null);
            } else {
                this.logger.error(this.msg(s), this.args(limiter, objects));
            }
        }
    }

    public void error(String s, Throwable throwable) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled() && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 40, this.msg(s), this.args(limiter, new Object[0]), throwable);
            } else {
                this.logger.error(this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String s) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 40, this.msg(s), this.args(limiter, new Object[0]), null);
            } else {
                this.logger.error(marker, this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    public void error(Marker marker, String s, Object o) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 40, this.msg(s), this.args(limiter, o), null);
            } else {
                this.logger.error(marker, this.msg(s), this.args(limiter, o));
            }
        }
    }

    public void error(Marker marker, String s, Object o, Object o1) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 40, this.msg(s), this.args(limiter, o, o1), null);
            } else {
                this.logger.error(marker, this.msg(s), this.args(limiter, o, o1));
            }
        }
    }

    public void error(Marker marker, String s, Object ... objects) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 40, this.msg(s), this.args(limiter, objects), null);
            } else {
                this.logger.error(marker, this.msg(s), this.args(limiter, objects));
            }
        }
    }

    public void error(Marker marker, String s, Throwable throwable) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled(marker) && (limiter = this.getLimiter(s)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 40, this.msg(s), this.args(limiter, new Object[0]), throwable);
            } else {
                this.logger.error(marker, this.msg(s), this.args(limiter, new Object[0]));
            }
        }
    }

    private String msg(String message) {
        return "[IGNORED={}]" + message;
    }

    private Object[] args(SimpleRateLimiter limiter, Object ... args) {
        long skip = limiter.getSkipCountAndClear();
        Object[] result = ArrayUtils.getLength((Object)args) == 0 ? new Object[]{skip} : ArrayUtils.addAll((Object[])new Object[]{skip}, (Object[])args);
        return result;
    }

    private SimpleRateLimiter getLimiter(@Nullable String message) {
        if (Objects.isNull(this.perFormatStringRateLimiter)) {
            return this.rateLimiter;
        }
        if (StringUtils.isBlank((CharSequence)message)) {
            return this.rateLimiter;
        }
        return (SimpleRateLimiter)this.perFormatStringRateLimiter.get((Object)message);
    }
}

