/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.privacy.jackson;

import cn.hutool.core.util.DesensitizedUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.spring.boxes.dollar.StringUtils;
import com.spring.boxes.dollar.support.privacy.jackson.PrivacyField;
import com.spring.boxes.dollar.support.privacy.jackson.PrivacySupplier;
import com.spring.boxes.dollar.support.privacy.jackson.PrivacyType;
import java.io.IOException;
import java.util.Objects;
import lombok.Generated;

public class PrivacyFieldSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private PrivacyType privacyType;

    public void serialize(String origin, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (StringUtils.isNotBlank(origin) && Objects.nonNull((Object)this.privacyType)) {
            switch (this.privacyType) {
                case DEFAULT: {
                    jsonGenerator.writeString(new PrivacySupplier.DefaultPrivacySupplier().accept(origin));
                    break;
                }
                case ID_CARD: {
                    jsonGenerator.writeString(DesensitizedUtil.idCardNum((String)origin, (int)1, (int)1));
                    break;
                }
                case EMAIL: {
                    jsonGenerator.writeString(DesensitizedUtil.email((String)origin));
                    break;
                }
                case PHONE: {
                    jsonGenerator.writeString(DesensitizedUtil.mobilePhone((String)origin));
                    break;
                }
                case FIXED_PHONE: {
                    jsonGenerator.writeString(DesensitizedUtil.fixedPhone((String)origin));
                    break;
                }
                case NAME: {
                    jsonGenerator.writeString(DesensitizedUtil.chineseName((String)origin));
                    break;
                }
                case ADDRESS: {
                    jsonGenerator.writeString(DesensitizedUtil.address((String)origin, (int)5));
                    break;
                }
                case BANK_CARD: {
                    jsonGenerator.writeString(DesensitizedUtil.bankCard((String)origin));
                    break;
                }
                case PASSPORT: {
                    jsonGenerator.writeString(new PrivacySupplier.DefaultPrivacySupplier().accept(origin));
                    break;
                }
                case CAR_LICENSE: {
                    jsonGenerator.writeString(DesensitizedUtil.carLicense((String)origin));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown privacy type enum " + (Object)((Object)this.privacyType));
                }
            }
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (Objects.nonNull(beanProperty)) {
            if (Objects.equals(beanProperty.getType().getRawClass(), String.class)) {
                PrivacyField privacyEncrypt = (PrivacyField)beanProperty.getAnnotation(PrivacyField.class);
                if (Objects.isNull(privacyEncrypt)) {
                    privacyEncrypt = (PrivacyField)beanProperty.getContextAnnotation(PrivacyField.class);
                }
                if (Objects.nonNull(privacyEncrypt)) {
                    return new PrivacyFieldSerializer(privacyEncrypt.type());
                }
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(null);
    }

    @Generated
    public PrivacyType getPrivacyType() {
        return this.privacyType;
    }

    @Generated
    public void setPrivacyType(PrivacyType privacyType) {
        this.privacyType = privacyType;
    }

    @Generated
    public String toString() {
        return "PrivacyFieldSerializer(privacyType=" + (Object)((Object)this.getPrivacyType()) + ")";
    }

    @Generated
    public PrivacyFieldSerializer() {
    }

    @Generated
    public PrivacyFieldSerializer(PrivacyType privacyType) {
        this.privacyType = privacyType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrivacyFieldSerializer)) {
            return false;
        }
        PrivacyFieldSerializer other = (PrivacyFieldSerializer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrivacyType this$privacyType = this.getPrivacyType();
        PrivacyType other$privacyType = other.getPrivacyType();
        return !(this$privacyType == null ? other$privacyType != null : !((Object)((Object)this$privacyType)).equals((Object)other$privacyType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PrivacyFieldSerializer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PrivacyType $privacyType = this.getPrivacyType();
        result = result * 59 + ($privacyType == null ? 43 : ((Object)((Object)$privacyType)).hashCode());
        return result;
    }
}

