/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.privacy.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.spring.boxes.dollar.StringUtils;
import com.spring.boxes.dollar.support.Encryptor;
import com.spring.boxes.dollar.support.privacy.jackson.PrivacyVirtual;
import java.io.IOException;
import java.util.Objects;
import lombok.Generated;

public class PrivacyVirtualSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private String secret;

    public void serialize(String origin, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (StringUtils.isNotBlank(origin)) {
            jsonGenerator.writeString(Encryptor.encrypt(this.secret, origin));
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (Objects.nonNull(beanProperty)) {
            if (Objects.equals(beanProperty.getType().getRawClass(), String.class)) {
                PrivacyVirtual privacyEncrypt = (PrivacyVirtual)beanProperty.getAnnotation(PrivacyVirtual.class);
                if (Objects.isNull(privacyEncrypt)) {
                    privacyEncrypt = (PrivacyVirtual)beanProperty.getContextAnnotation(PrivacyVirtual.class);
                }
                if (Objects.nonNull(privacyEncrypt)) {
                    return new PrivacyVirtualSerializer(privacyEncrypt.secret());
                }
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(null);
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Generated
    public String toString() {
        return "PrivacyVirtualSerializer(secret=" + this.getSecret() + ")";
    }

    @Generated
    public PrivacyVirtualSerializer() {
    }

    @Generated
    public PrivacyVirtualSerializer(String secret) {
        this.secret = secret;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrivacyVirtualSerializer)) {
            return false;
        }
        PrivacyVirtualSerializer other = (PrivacyVirtualSerializer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PrivacyVirtualSerializer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        return result;
    }
}

