/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.privacy.mybatis;

import com.spring.boxes.dollar.support.privacy.mybatis.EncryptField;
import com.spring.boxes.dollar.support.privacy.mybatis.EncryptProperties;
import com.spring.boxes.dollar.support.privacy.mybatis.IEncryptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class EncryptInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptInterceptor.class);
    private final IEncryptor encryptor;
    private final EncryptProperties mybatisEncryptProperties;

    public EncryptInterceptor(EncryptProperties mybatisEncryptProperties) {
        this(mybatisEncryptProperties, new IEncryptor.DefaultEncryptor(mybatisEncryptProperties.getPassword()));
    }

    public EncryptInterceptor(EncryptProperties mybatisEncryptProperties, IEncryptor encryptor) {
        this.mybatisEncryptProperties = mybatisEncryptProperties;
        this.encryptor = encryptor;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement ms;
        if (Boolean.FALSE.equals(this.mybatisEncryptProperties.isEnable())) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArgs();
        Object target = invocation.getTarget();
        Executor executor = target instanceof Executor ? (Executor)target : null;
        StatementHandler statementHandler = target instanceof StatementHandler ? (StatementHandler)target : null;
        MappedStatement mappedStatement = ms = args[0] instanceof MappedStatement ? (MappedStatement)args[0] : null;
        if (Objects.nonNull(ms)) {
            switch (ms.getSqlCommandType()) {
                case INSERT: 
                case UPDATE: {
                    this.processInsertOrUpdateCommandType(invocation);
                    break;
                }
                case SELECT: {
                    return this.processSelectCommandType(invocation);
                }
            }
        }
        return invocation.proceed();
    }

    public void processInsertOrUpdateCommandType(Invocation invocation) throws IllegalAccessException {
        Object parameter = invocation.getArgs()[1];
        Class<?> clazz = parameter.getClass();
        if (clazz != Object.class) {
            List encryptFields = FieldUtils.getFieldsListWithAnnotation(clazz, EncryptField.class);
            if (CollectionUtils.isEmpty((Collection)encryptFields)) {
                return;
            }
            for (Field field : encryptFields) {
                Object plaintextFieldValue = FieldUtils.readField((Field)field, (Object)parameter, (boolean)true);
                if (Objects.isNull(plaintextFieldValue)) continue;
                String encrypt = this.encryptor.encrypt(String.valueOf(plaintextFieldValue));
                FieldUtils.writeField((Field)field, (Object)parameter, (Object)encrypt, (boolean)true);
                if (!log.isDebugEnabled()) continue;
                log.debug("Encrypt field for '{}', Plaintext: {}, Ciphertext: {}", new Object[]{field.getName(), plaintextFieldValue, encrypt});
            }
        }
    }

    public Object processSelectCommandType(Invocation invocation) throws IllegalAccessException, InvocationTargetException {
        Object proceed = invocation.proceed();
        if (proceed instanceof Collection) {
            Collection proceedResults = (Collection)proceed;
            if (CollectionUtils.isEmpty((Collection)proceedResults)) {
                return proceed;
            }
            for (Object obj : proceedResults) {
                List decryptFields;
                if (null == obj || CollectionUtils.isEmpty((Collection)(decryptFields = FieldUtils.getFieldsListWithAnnotation(obj.getClass(), EncryptField.class)))) continue;
                for (Field field : decryptFields) {
                    Object ciphertextFieldValue = FieldUtils.readField((Field)field, obj, (boolean)true);
                    if (null == ciphertextFieldValue) continue;
                    String decrypt = this.encryptor.decrypt(String.valueOf(ciphertextFieldValue));
                    FieldUtils.writeField((Field)field, obj, (Object)decrypt, (boolean)true);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Decrypt field for '{}', Ciphertext: {}, Plaintext: {}", new Object[]{field.getName(), ciphertextFieldValue, decrypt});
                }
            }
        }
        if (proceed instanceof Map) {
            Map map = (Map)proceed;
        }
        return proceed;
    }
}

