/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.push;

import com.google.common.base.Preconditions;
import com.spring.boxes.dollar.support.push.PushArgument;
import com.spring.boxes.dollar.support.push.PushPayload;
import com.spring.boxes.dollar.support.push.PushType;
import com.spring.boxes.dollar.support.template.Template;
import com.spring.boxes.dollar.support.template.TemplateLoader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushTemplate
implements PushPayload {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PushTemplate.class);
    private TemplateLoader templateLoader;
    private Map<String, PushPayload> pushFunctionMap;

    @Override
    public void push(PushArgument argument) {
        Preconditions.checkArgument((boolean)Objects.nonNull(argument), (Object)"\u63a8\u9001\u4e0a\u4e0b\u6587\u5165\u53c2\u4e3a\u7a7a");
        Template localeTemplate = this.templateLoader.queryTemplate(argument.getAppId(), argument.getTemplateKey(), argument.getLanguage());
        Preconditions.checkArgument((boolean)Objects.nonNull(localeTemplate), (Object)String.format("\u89e6\u8fbe\u6a21\u7248\u65e0\u6548:%s:%s", argument.getTemplateKey(), argument.getLanguage()));
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(argument.getPushTypes()), (Object)String.format("\u89e6\u8fbe\u6a21\u7248\u63a8\u9001\u65b9\u5f0f\u4e3a\u7a7a:%s:%s", argument.getTemplateKey(), argument.getLanguage()));
        List<String> argList = localeTemplate.getArgList();
        for (String arg : argList) {
            if (!Objects.isNull(MapUtils.getObject(argument.getTemplateArgs(), (Object)arg))) continue;
            throw new IllegalArgumentException(String.format("\u89e6\u8fbe\u53c2\u6570\u7f3a\u5931:%s", arg));
        }
        for (PushType pushType : argument.getPushTypes()) {
            PushPayload pushFunction = this.pushFunctionMap.get(pushType.getClazz());
            if (Objects.isNull(pushFunction)) {
                log.error("[\u63a8\u9001]\u63a8\u9001\u65b9\u5f0f{}\u7f3a\u5c11\u5b9e\u73b0{}", (Object)pushType.getLabel(), (Object)pushType.getClazz());
            }
            String content = this.templateLoader.substitutor(localeTemplate.getContent(), argument.getTemplateArgs());
            localeTemplate.setContent(content);
            pushFunction.push(argument);
        }
    }
}

