/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.queue;

import com.spring.boxes.dollar.JSONUtils;
import com.spring.boxes.dollar.StringUtils;
import com.spring.boxes.dollar.support.queue.MessageConsumer;
import com.spring.boxes.dollar.support.queue.MessageData;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class MessageReceiver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageReceiver.class);
    private ApplicationContext applicationContext;

    public void onMessage(String message) {
        Map consumerMap = this.applicationContext.getBeansOfType(MessageConsumer.class);
        if (StringUtils.isBlank(message) || MapUtils.isEmpty((Map)consumerMap)) {
            return;
        }
        log.info("[queue][onMessage] message:{}", (Object)message);
        MessageData messageData = JSONUtils.fromJSON(message, MessageData.class);
        if (Objects.isNull(messageData)) {
            return;
        }
        String type = messageData.getType();
        String data = messageData.getData();
        if (StringUtils.isBlank(type) || StringUtils.isBlank(data)) {
            return;
        }
        log.info("[queue][onMessage] type:{}, data:{}", (Object)type, (Object)data);
        consumerMap.forEach((k, v) -> {
            log.info("[queue][onMessage] consumer:{} v.type:{}", k, (Object)v.type());
            if (type.equals(v.type())) {
                v.onMessage(data);
            }
        });
    }

    @Generated
    public MessageReceiver(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

