/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.reflect;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeReflect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TypeReflect.class);
    private static final Map<String, Class<?>> TYPES = new HashMap();
    private static final String ARRAY_PREFIX = "[";
    private static final String REFERENCE_TYPE_PREFIX = "L";
    private static final String REFERENCE_TYPE_SUFFIX = ";";

    public static List<Class<?>> forNames(List<String> names) {
        return TypeReflect.forNames(Thread.currentThread().getContextClassLoader(), names);
    }

    public static List<Class<?>> forNames(ClassLoader loader, List<String> names) {
        if (CollectionUtils.isEmpty(names)) {
            return Lists.newArrayList();
        }
        return names.stream().map(e -> {
            try {
                return TypeReflect.forName(loader, e);
            }
            catch (Exception ex) {
                log.error(ex.getLocalizedMessage(), (Throwable)ex);
                return null;
            }
        }).collect(Collectors.toList());
    }

    public static Class<?> forName(String name) {
        return TypeReflect.forName(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Class<?> forName(ClassLoader loader, String name) {
        if (TYPES.containsKey(name)) {
            return TYPES.get(name);
        }
        if (TypeReflect.isArray(name)) {
            int dimension = 0;
            while (TypeReflect.isArray(name)) {
                ++dimension;
                name = name.substring(1);
            }
            Class<?> type = TypeReflect.forName(loader, name);
            int[] dimensions = new int[dimension];
            for (int i = 0; i < dimension; ++i) {
                dimensions[i] = 0;
            }
            return Array.newInstance(type, dimensions).getClass();
        }
        if (TypeReflect.isReferenceType(name)) {
            name = name.substring(1, name.length() - 1);
        }
        try {
            return Class.forName(name, false, loader);
        }
        catch (Exception ex) {
            log.error(ex.getLocalizedMessage(), (Throwable)ex);
            return null;
        }
    }

    private static boolean isArray(String type) {
        return type != null && type.startsWith(ARRAY_PREFIX);
    }

    private static boolean isReferenceType(String type) {
        return type != null && type.startsWith(REFERENCE_TYPE_PREFIX) && type.endsWith(REFERENCE_TYPE_SUFFIX);
    }

    static {
        TYPES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        TYPES.put(Byte.TYPE.getName(), Byte.TYPE);
        TYPES.put(Short.TYPE.getName(), Short.TYPE);
        TYPES.put(Integer.TYPE.getName(), Integer.TYPE);
        TYPES.put(Long.TYPE.getName(), Long.TYPE);
        TYPES.put(Float.TYPE.getName(), Float.TYPE);
        TYPES.put(Double.TYPE.getName(), Double.TYPE);
        TYPES.put(Void.TYPE.getName(), Void.TYPE);
        TYPES.put("Z", Boolean.TYPE);
        TYPES.put("B", Byte.TYPE);
        TYPES.put("C", Character.TYPE);
        TYPES.put("D", Double.TYPE);
        TYPES.put("F", Float.TYPE);
        TYPES.put("I", Integer.TYPE);
        TYPES.put("J", Long.TYPE);
        TYPES.put("S", Short.TYPE);
    }
}

