/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.strategy.type;

import com.spring.boxes.dollar.CollectionUtils;
import com.spring.boxes.dollar.support.ApiException;
import com.spring.boxes.dollar.support.ApiStatus;
import com.spring.boxes.dollar.support.strategy.StrategyPayload;
import com.spring.boxes.dollar.support.strategy.type.FrequencyArg;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class FrequencyTemplate
implements StrategyPayload<List<FrequencyArg>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FrequencyTemplate.class);
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public void filter(List<FrequencyArg> limitType) {
        if (!CollectionUtils.isEmpty(limitType)) {
            for (FrequencyArg frequencyArg : limitType) {
                String cacheKey = frequencyArg.getFrequencyKey();
                Long count = this.stringRedisTemplate.opsForValue().increment((Object)cacheKey, 1L);
                if (Objects.isNull(count)) {
                    return;
                }
                if (1L == count) {
                    this.stringRedisTemplate.expire((Object)cacheKey, frequencyArg.getSurvivalTime(), TimeUnit.MILLISECONDS);
                }
                if (count <= (long)frequencyArg.getMaxCount()) continue;
                log.error("key:{} maxCount:{} frequency limited", (Object)cacheKey, (Object)frequencyArg.getMaxCount());
                throw new ApiException(ApiStatus.Status.FREQUENCY, "\u89e6\u53d1\u9891\u63a7");
            }
        }
    }

    @Generated
    public FrequencyTemplate() {
    }

    @Generated
    public FrequencyTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

