/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.support.throttle;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.spring.boxes.dollar.support.ThrowableSupplier;
import com.spring.boxes.dollar.support.throttle.ThrottlingKey;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Throttling {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Throttling.class);
    private static final Logger logger = LoggerFactory.getLogger(Throttling.class);
    private volatile long lastAccessTimestamp;
    private final ThrottlingKey throttlingKey;
    private final AtomicInteger concurrency = new AtomicInteger();
    private static final ConcurrentMap<String, Throttling> MAP = new ConcurrentHashMap<String, Throttling>();

    private Throttling(ThrottlingKey throttlingKey) {
        this.throttlingKey = throttlingKey;
    }

    public static <T, X extends Throwable> T supplyWithThrottling(ThrottlingKey throttlingKey, ThrowableSupplier<? extends T, X> result) throws X {
        return (T)Throttling.supplyWithThrottling(throttlingKey, result, () -> {
            logger.error("{} invocation throttled", (Object)throttlingKey.getName());
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, X extends Throwable> T supplyWithThrottling(ThrottlingKey throttlingKey, ThrowableSupplier<? extends T, X> result, Supplier<? extends T> onThrottledResult) throws X {
        Throttling throttling = Throttling.of(throttlingKey);
        try {
            if (throttling.tryEnter()) {
                T t = result.get();
                return t;
            }
            T t = Throttling.supplyNullable(onThrottledResult);
            return t;
        }
        finally {
            throttling.leave();
        }
    }

    public static <T> ListenableFuture<T> asyncSupplyWithThrottling(ThrottlingKey throttlingKey, Supplier<ListenableFuture<T>> result) {
        return Throttling.asyncSupplyWithThrottling(throttlingKey, result, () -> {
            logger.error("{} invocation throttled", (Object)throttlingKey.getName());
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ListenableFuture<T> asyncSupplyWithThrottling(ThrottlingKey throttlingKey, Supplier<ListenableFuture<T>> result, Supplier<T> onThrottledResult) {
        final Throttling throttling = Throttling.of(throttlingKey);
        boolean needLeaveOnFinally = true;
        try {
            if (throttling.tryEnter()) {
                ListenableFuture<T> future = result.get();
                Objects.requireNonNull(future);
                Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

                    public void onSuccess(@Nullable T result) {
                        throttling.leave();
                    }

                    public void onFailure(@Nonnull Throwable t) {
                        throttling.leave();
                    }
                }, (Executor)MoreExecutors.directExecutor());
                needLeaveOnFinally = false;
                ListenableFuture<T> listenableFuture = future;
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFuture(Throttling.supplyNullable(onThrottledResult));
            return listenableFuture;
        }
        finally {
            if (needLeaveOnFinally) {
                throttling.leave();
            }
        }
    }

    private static <T> T supplyNullable(@Nullable Supplier<? extends T> onThrottledResult) {
        if (onThrottledResult != null) {
            return onThrottledResult.get();
        }
        return null;
    }

    public ThrottlingKey getThrottlingKey() {
        return this.throttlingKey;
    }

    public int getCurrentConcurrency() {
        return this.concurrency.get();
    }

    private static int totalThrottlingCount() {
        return MAP.size();
    }

    public static Throttling of(ThrottlingKey throttlingKey) {
        String name = throttlingKey.getName();
        Throttling throttling = (Throttling)MAP.get(name);
        if (throttling != null) {
            return throttling;
        }
        return MAP.computeIfAbsent(name, k -> new Throttling(throttlingKey));
    }

    public boolean tryEnter() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        return this.concurrency.incrementAndGet() <= this.throttlingKey.getThreshold();
    }

    public int leave() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        return this.concurrency.decrementAndGet();
    }
}

