/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.term;

import com.spring.boxes.dollar.RateUtils;
import com.spring.boxes.dollar.term.RatePair;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;

public class Endpoint {
    public static final String[] PROTOCOL_ARRAY = new String[]{"http", "https"};
    public static final UrlValidator HTTP_HTTPS = new UrlValidator(PROTOCOL_ARRAY);
    public static final UrlValidator HTTP = new UrlValidator(Arrays.copyOfRange(PROTOCOL_ARRAY, 0, 1));
    public static final UrlValidator HTTPS = new UrlValidator(Arrays.copyOfRange(PROTOCOL_ARRAY, 1, 2));

    public static boolean isHttp(String url) {
        return HTTP.isValid(url);
    }

    public static String toHttp(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && url.startsWith(PROTOCOL_ARRAY[1])) {
            return StringUtils.replaceOnce((String)url, (String)PROTOCOL_ARRAY[1], (String)PROTOCOL_ARRAY[0]);
        }
        return url;
    }

    public static boolean isHttps(String url) {
        return HTTPS.isValid(url);
    }

    public static String toHttps(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && url.startsWith(PROTOCOL_ARRAY[0])) {
            return StringUtils.replaceOnce((String)url, (String)PROTOCOL_ARRAY[0], (String)PROTOCOL_ARRAY[1]);
        }
        return url;
    }

    public static boolean isHttpOrHttps(String url) {
        return HTTP_HTTPS.isValid(url);
    }

    public static <V> V getEndpoint(List<RatePair<V>> weights) {
        List<Integer> rates = weights.stream().map(RatePair::getRate).collect(Collectors.toList());
        int rateIndex = RateUtils.getRateIndex(rates);
        return weights.get(rateIndex).getValue();
    }
}

