/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.term;

import cn.dev33.satoken.stp.StpUtil;
import com.spring.boxes.dollar.StringUtils;
import com.spring.boxes.dollar.support.cryptor.IdEncryptor;
import com.spring.boxes.dollar.term.ClientInfo;
import io.netty.util.concurrent.FastThreadLocal;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeKey {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScopeKey.class);
    public static final FastThreadLocal<ClientInfo> CLIENT_INFO = new FastThreadLocal();

    public static long getUserId() {
        try {
            if (StpUtil.isLogin()) {
                return StpUtil.getLoginIdAsLong();
            }
        }
        catch (Exception e) {
            log.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        return 0L;
    }

    public static long getAppId() {
        String appId = System.getProperty("appId");
        if (StringUtils.isBlank(appId)) {
            return 0L;
        }
        return Long.parseLong(appId);
    }

    public static String getAppKey() {
        return System.getProperty("appKey");
    }

    public static long getAppIdByKey(String appKey) {
        if (StringUtils.isBlank(appKey)) {
            appKey = ScopeKey.getAppKey();
        }
        if (StringUtils.isBlank(appKey)) {
            return 0L;
        }
        return IdEncryptor.skipDecryptId(appKey, IdEncryptor.A);
    }

    public static String getAppKeyById(long appId) {
        if (appId <= 0L) {
            appId = ScopeKey.getAppId();
        }
        if (appId <= 0L) {
            return "";
        }
        return IdEncryptor.skipEncryptId(appId, IdEncryptor.A);
    }
}

