/*
 * Decompiled with CFR 0.152.
 */
package com.spring.boxes.dollar.term;

import com.google.common.base.Preconditions;
import com.spring.boxes.dollar.JSONUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;

public class StringValue
implements Serializable {
    private String type;
    private Class<?> type1;
    private Class<?> type2;
    private Class<?> type3;
    public static final String _OBJ = "_obj";
    public static final String _MAP = "_map";
    public static final String _SET = "_set";
    public static final String _LIST = "_list";

    public static StringValue newMap(Class<?> keyType, Class<?> valueType) {
        return new StringValue(_MAP, Map.class, keyType, valueType);
    }

    public static StringValue newObj(Class<?> valueType) {
        if (valueType == String.class || valueType == Number.class) {
            throw new UnsupportedOperationException("only for object json serialize");
        }
        if (valueType == List.class) {
            throw new UnsupportedOperationException("should be use _list type");
        }
        if (valueType == Set.class) {
            throw new UnsupportedOperationException("should be use _set type");
        }
        if (valueType == Map.class) {
            throw new UnsupportedOperationException("should be use _map type");
        }
        return new StringValue(_OBJ, Map.class, valueType, Void.class);
    }

    public static StringValue newSet(Class<?> valueType) {
        return new StringValue(_SET, Set.class, valueType, Void.class);
    }

    public static StringValue newList(Class<?> valueType) {
        return new StringValue(_LIST, List.class, valueType, Void.class);
    }

    public static <T> T ofValue(String source, Function<String, T> function) {
        return function.apply(source);
    }

    public static <T> T ofValue(String source, StringValue settingValue, BiFunction<String, StringValue, T> function) {
        return function.apply(source, settingValue);
    }

    public static Object ofValue(String source, StringValue stringValue) {
        if (Objects.isNull(source)) {
            return null;
        }
        if (_OBJ.equals(stringValue.getType())) {
            return JSONUtils.fromJSON(source, stringValue.getType1());
        }
        if (_LIST.equals(stringValue.getType())) {
            return JSONUtils.fromJSON(source, List.class, stringValue.getType2());
        }
        if (_SET.equals(stringValue.getType())) {
            return JSONUtils.fromJSON(source, Set.class, stringValue.getType2());
        }
        if (_MAP.equals(stringValue.getType())) {
            return JSONUtils.fromJSON(source, Map.class, stringValue.getType2(), stringValue.getType3());
        }
        return null;
    }

    public static <T> List<T> ofList(String source, StringValue stringValue) {
        Preconditions.checkArgument((boolean)Objects.nonNull(stringValue), (Object)"empty stringValue");
        Preconditions.checkArgument((boolean)_LIST.equals(stringValue.getType()), (Object)String.format("stringValue mismatch _list (%s)", stringValue.getType()));
        return (List)JSONUtils.fromJSON(source, List.class, stringValue.getType2());
    }

    public static <T> Set<T> ofSet(String source, StringValue stringValue) {
        Preconditions.checkArgument((boolean)Objects.nonNull(stringValue), (Object)"empty stringValue");
        Preconditions.checkArgument((boolean)_SET.equals(stringValue.getType()), (Object)String.format("stringValue mismatch _set (%s)", stringValue.getType()));
        return (Set)JSONUtils.fromJSON(source, Set.class, stringValue.getType2());
    }

    public static <T> T ofObj(String source, StringValue stringValue) {
        Preconditions.checkArgument((boolean)Objects.nonNull(stringValue), (Object)"empty stringValue");
        Preconditions.checkArgument((boolean)_OBJ.equals(stringValue.getType()), (Object)String.format("stringValue mismatch _obj (%s)", stringValue.getType()));
        return (T)JSONUtils.fromJSON(source, stringValue.getType1());
    }

    public static <K, V> Map<K, V> ofMap(String source, StringValue stringValue) {
        Preconditions.checkArgument((boolean)Objects.nonNull(stringValue), (Object)"empty stringValue");
        Preconditions.checkArgument((boolean)_MAP.equals(stringValue.getType()), (Object)String.format("stringValue mismatch _map (%s)", stringValue.getType()));
        return JSONUtils.fromJSON(source, Map.class, stringValue.getType2(), stringValue.getType3());
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Class<?> getType1() {
        return this.type1;
    }

    @Generated
    public Class<?> getType2() {
        return this.type2;
    }

    @Generated
    public Class<?> getType3() {
        return this.type3;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setType1(Class<?> type1) {
        this.type1 = type1;
    }

    @Generated
    public void setType2(Class<?> type2) {
        this.type2 = type2;
    }

    @Generated
    public void setType3(Class<?> type3) {
        this.type3 = type3;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringValue)) {
            return false;
        }
        StringValue other = (StringValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Class<?> this$type1 = this.getType1();
        Class<?> other$type1 = other.getType1();
        if (this$type1 == null ? other$type1 != null : !this$type1.equals(other$type1)) {
            return false;
        }
        Class<?> this$type2 = this.getType2();
        Class<?> other$type2 = other.getType2();
        if (this$type2 == null ? other$type2 != null : !this$type2.equals(other$type2)) {
            return false;
        }
        Class<?> this$type3 = this.getType3();
        Class<?> other$type3 = other.getType3();
        return !(this$type3 == null ? other$type3 != null : !this$type3.equals(other$type3));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Class<?> $type1 = this.getType1();
        result = result * 59 + ($type1 == null ? 43 : $type1.hashCode());
        Class<?> $type2 = this.getType2();
        result = result * 59 + ($type2 == null ? 43 : $type2.hashCode());
        Class<?> $type3 = this.getType3();
        result = result * 59 + ($type3 == null ? 43 : $type3.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StringValue(type=" + this.getType() + ", type1=" + this.getType1() + ", type2=" + this.getType2() + ", type3=" + this.getType3() + ")";
    }

    @Generated
    public StringValue() {
    }

    @Generated
    public StringValue(String type, Class<?> type1, Class<?> type2, Class<?> type3) {
        this.type = type;
        this.type1 = type1;
        this.type2 = type2;
        this.type3 = type3;
    }
}

