/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Chunk;
import com.x5.template.ChunkFactory;
import com.x5.template.ContentSource;
import com.x5.template.EndOfSnippetException;
import com.x5.template.Snippet;
import com.x5.template.TemplateSetSlice;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.RegexFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateSet
implements ContentSource,
ChunkFactory {
    public static String DEFAULT_TAG_START = "{$";
    public static String DEFAULT_TAG_END = "}";
    public static final String MACRO_START = "{*";
    public static final String MACRO_NAME_END = "}";
    public static final String MACRO_END = "{*}";
    public static final String MACRO_LET = "{=";
    public static final String MACRO_LET_END = "}";
    public static final String INCLUDE_SHORTHAND = "{+";
    public static final String PROTOCOL_SHORTHAND = "{.";
    public static final String BLOCKEND_SHORTHAND = "{/";
    public static final String BLOCKEND_LONGHAND = "{~./";
    private static final long oneMinuteInMillis = 60000L;
    private static final long MIN_CACHE = 5000L;
    private static final String SUB_START = "{#";
    private static final String SUB_NAME_END = "}";
    private static final String SUB_END = "{#}";
    private static final String COMMENT_START = "{!--";
    private static final String COMMENT_END = "--}";
    private static final String SKIP_BLANK_LINE = "";
    public static final String LITERAL_START = "{^literal}";
    public static final String LITERAL_START2 = "{.literal}";
    public static final String LITERAL_SHORTHAND = "{^^}";
    public static final String LITERAL_END = "{^}";
    public static final String LITERAL_END_EXPANDED = "{~.}";
    public static final String LITERAL_END_LONGHAND = "{/literal}";
    private static final int DEFAULT_REFRESH = 15;
    private static final String DEFAULT_EXTENSION = "chtml";
    private Hashtable<String, Snippet> cache = new Hashtable();
    private Hashtable<String, Long> cacheFetch = new Hashtable();
    private int dirtyInterval = 15;
    private String defaultExtension = "chtml";
    private String tagStart = DEFAULT_TAG_START;
    private String tagEnd = DEFAULT_TAG_END;
    private String templatePath = System.getProperty("templateset.folder", "");
    private String layerName = null;
    private Class<?> classInJar = null;
    private Object resourceContext = null;
    private boolean prettyFail = true;
    private String expectedEncoding = this.getDefaultEncoding();
    private HashSet<ContentSource> altSources = null;

    public TemplateSet() {
    }

    public TemplateSet(String templatePath) {
        this(templatePath, DEFAULT_EXTENSION, 15);
    }

    public TemplateSet(String templatePath, String extension, int refreshMins) {
        if (templatePath != null) {
            char lastChar = templatePath.charAt(templatePath.length() - 1);
            char fs = System.getProperty("file.separator").charAt(0);
            if (lastChar != '\\' && lastChar != '/' && lastChar != fs) {
                templatePath = templatePath + fs;
            }
            this.templatePath = templatePath;
        }
        this.dirtyInterval = refreshMins;
        this.defaultExtension = extension == null ? DEFAULT_EXTENSION : extension;
    }

    @Override
    public Snippet getSnippet(String name) {
        return this.getSnippet(name, this.defaultExtension);
    }

    @Override
    public String fetch(String name) {
        Snippet s = this.getCleanTemplate(name);
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    @Override
    public String getProtocol() {
        return "include";
    }

    private Snippet getCleanTemplate(String name) {
        return this.getSnippet(name, "_CLEAN_:" + this.defaultExtension);
    }

    public Snippet getSnippet(String name, String extension) {
        return this._get(name, extension, this.prettyFail);
    }

    private Snippet _get(String name, String extension, boolean prettyFail) {
        Snippet template = this.getFromCache(name, extension);
        String filename = null;
        if (template == null) {
            String stub = this.truncateNameToStub(name);
            filename = this.getTemplatePath(name, extension);
            char fs = System.getProperty("file.separator").charAt(0);
            filename = filename.replace('\\', fs);
            filename = filename.replace('/', fs);
            try {
                File templateFile = new File(filename);
                if (templateFile.exists()) {
                    FileInputStream in = new FileInputStream(templateFile);
                    InputStreamReader reader = new InputStreamReader((InputStream)in, this.expectedEncoding);
                    BufferedReader brTemp = new BufferedReader(reader);
                    this.readAndCacheTemplate(stub, extension, brTemp);
                    in.close();
                    template = this.getFromCache(name, extension);
                } else {
                    String resourcePath = this.getResourcePath(name, extension);
                    InputStream inJar = null;
                    if (this.classInJar == null) {
                        this.classInJar = TemplateSet.grokCallerClass();
                    }
                    if (this.classInJar != null) {
                        inJar = this.classInJar.getResourceAsStream(resourcePath);
                    }
                    if (inJar == null) {
                        inJar = this.fishForTemplate(resourcePath);
                    }
                    if (inJar != null) {
                        BufferedReader brTemp = new BufferedReader(new InputStreamReader(inJar, this.expectedEncoding));
                        this.readAndCacheTemplate(stub, extension, brTemp);
                        inJar.close();
                        template = this.getFromCache(name, extension);
                    }
                }
            }
            catch (IOException e) {
                if (!prettyFail) {
                    return null;
                }
                StringBuilder errmsg = new StringBuilder("[error fetching ");
                errmsg.append(extension);
                errmsg.append(" template '");
                errmsg.append(name);
                errmsg.append("']<!-- ");
                StringWriter w = new StringWriter();
                e.printStackTrace(new PrintWriter(w));
                errmsg.append(w.toString());
                errmsg.append(" -->");
                template = Snippet.getSnippet(errmsg.toString());
            }
        }
        if (template == null) {
            if (prettyFail) {
                StringBuilder errmsg = new StringBuilder();
                errmsg.append("[");
                errmsg.append(extension);
                errmsg.append(" template '");
                errmsg.append(name);
                errmsg.append("' not found]<!-- looked in [");
                errmsg.append(filename);
                errmsg.append("] -->");
                template = Snippet.getSnippet(errmsg.toString());
            } else {
                return null;
            }
        }
        return template;
    }

    static Class<?> grokCallerClass() {
        Throwable t = new Throwable();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace == null) {
            return null;
        }
        for (int i = 4; i < stackTrace.length; ++i) {
            StackTraceElement e = stackTrace[i];
            if (e.getClassName().matches("^com\\.x5\\.template\\.[^\\.]*$")) continue;
            try {
                return Class.forName(e.getClassName());
            }
            catch (ClassNotFoundException e2) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream fishForTemplate(String resourcePath) {
        InputStream in;
        if (this.resourceContext != null && (in = this.fishForTemplateInContext(resourcePath)) != null) {
            return in;
        }
        String cp = System.getProperty("java.class.path");
        if (cp == null) {
            return null;
        }
        String[] jars = cp.split(":");
        if (jars == null) {
            return null;
        }
        for (String jar : jars) {
            InputStream in2;
            if (!jar.endsWith(".jar") || (in2 = this.peekInsideJar("jar:file:" + jar, resourcePath)) == null) continue;
            return in2;
        }
        return null;
    }

    private InputStream peekInsideJar(String jar, String resourcePath) {
        String resourceURL = jar + "!" + resourcePath;
        try {
            URL url = new URL(resourceURL);
            InputStream in = url.openStream();
            if (in != null) {
                return in;
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            String zipPath = jar.replaceFirst("^jar:file:", SKIP_BLANK_LINE);
            String zipResourcePath = resourcePath.replaceFirst("^/", SKIP_BLANK_LINE);
            ZipFile zipFile = new ZipFile(zipPath);
            ZipEntry entry = zipFile.getEntry(zipResourcePath);
            if (entry != null) {
                return zipFile.getInputStream(entry);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    private InputStream fishForTemplateInContext(String resourcePath) {
        Class<?> ctxClass = this.resourceContext.getClass();
        Method m = null;
        try {
            Set paths;
            InputStream in;
            Class[] oneString = new Class[]{String.class};
            m = ctxClass.getMethod("getResourceAsStream", oneString);
            if (m != null && (in = (InputStream)m.invoke(this.resourceContext, resourcePath)) != null) {
                return in;
            }
            m = ctxClass.getMethod("getResourcePaths", oneString);
            if (m != null && (paths = (Set)m.invoke(this.resourceContext, "/WEB-INF/lib")) != null) {
                for (Object urlString : paths) {
                    String jar = (String)urlString;
                    if (!jar.endsWith(".jar")) continue;
                    m = ctxClass.getMethod("getResource", oneString);
                    URL jarURL = (URL)m.invoke(this.resourceContext, jar);
                    InputStream in2 = this.peekInsideJar("jar:" + jarURL.toString(), resourcePath);
                    if (in2 == null) continue;
                    return in2;
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Chunk makeChunk() {
        Chunk c = new Chunk();
        c.setMacroLibrary(this, this);
        this.shareContentSources(c);
        return c;
    }

    @Override
    public Chunk makeChunk(String templateName) {
        Chunk c = new Chunk();
        c.setMacroLibrary(this, this);
        c.append(this.getSnippet(templateName));
        this.shareContentSources(c);
        return c;
    }

    @Override
    public Chunk makeChunk(String templateName, String extension) {
        Chunk c = new Chunk();
        c.setMacroLibrary(this, this);
        c.append(this.getSnippet(templateName, extension));
        this.shareContentSources(c);
        return c;
    }

    protected StringBuilder readAndCacheTemplate(String name, String extension, BufferedReader brTemp) throws IOException {
        StringBuilder sbTemp = new StringBuilder();
        String line = null;
        while (brTemp.ready() && (line = brTemp.readLine()) != null) {
            int subNameEnd;
            int subEndPos;
            int comPos = line.indexOf(COMMENT_START);
            int subPos = line.indexOf(SUB_START);
            while (comPos > -1 && (subPos < 0 || subPos > comPos)) {
                StringBuilder commentBuf = new StringBuilder();
                line = this.skipComment(comPos, line, brTemp, commentBuf);
                String beforeComment = line.substring(0, comPos);
                String afterComment = line.substring(comPos);
                sbTemp.append(beforeComment);
                sbTemp.append((CharSequence)commentBuf);
                line = afterComment;
                comPos = line.indexOf(COMMENT_START);
                subPos = line.indexOf(SUB_START);
            }
            if (subPos > -1 && (subEndPos = line.indexOf(SUB_END)) != subPos && (subNameEnd = line.indexOf("}", subPos + SUB_START.length())) > -1) {
                sbTemp.append(line.substring(0, subPos));
                String subName = line.substring(subPos + SUB_START.length(), subNameEnd);
                String restOfLine = line.substring(subNameEnd + "}".length());
                line = this.readAndCacheSubTemplate(name + "." + subName, extension, brTemp, restOfLine);
                if (line.length() < 1) continue;
            }
            sbTemp.append(line);
            if (!brTemp.ready()) continue;
            sbTemp.append("\n");
        }
        this.addToCache(name, extension, sbTemp);
        return sbTemp;
    }

    private String getCommentLines(int comBegin, String firstLine, BufferedReader brTemp, StringBuilder sbTemp) throws IOException {
        int comEnd = firstLine.indexOf(COMMENT_END, comBegin + 2);
        int endMarkerLen = COMMENT_END.length();
        if (comEnd > -1) {
            sbTemp.append(firstLine.substring(0, comEnd += endMarkerLen));
            return firstLine.substring(comEnd);
        }
        sbTemp.append(firstLine);
        sbTemp.append("\n");
        String line = null;
        while (brTemp.ready() && (line = brTemp.readLine()) != null) {
            comEnd = line.indexOf(COMMENT_END);
            if (comEnd > -1) {
                sbTemp.append(line.substring(0, comEnd += endMarkerLen));
                return line.substring(comEnd);
            }
            sbTemp.append(line);
            sbTemp.append("\n");
        }
        return SKIP_BLANK_LINE;
    }

    private String getLiteralLines(int litBegin, String firstLine, BufferedReader brTemp, StringBuilder sbTemp) throws IOException {
        int litEnd = firstLine.indexOf(LITERAL_END, litBegin + 2);
        int endMarkerLen = LITERAL_END.length();
        int litEndLong = firstLine.indexOf(LITERAL_END_LONGHAND, litBegin + 2);
        if (litEndLong > -1 && (litEnd < 0 || litEndLong < litEnd)) {
            litEnd = litEndLong;
            endMarkerLen = LITERAL_END_LONGHAND.length();
        }
        if (litEnd > -1) {
            sbTemp.append(firstLine.substring(0, litEnd += endMarkerLen));
            return firstLine.substring(litEnd);
        }
        sbTemp.append(firstLine);
        sbTemp.append("\n");
        String line = null;
        while (brTemp.ready() && (line = brTemp.readLine()) != null) {
            litEnd = line.indexOf(LITERAL_END);
            litEndLong = line.indexOf(LITERAL_END_LONGHAND);
            if (litEndLong > -1 && (litEnd < 0 || litEndLong < litEnd)) {
                litEnd = litEndLong;
                endMarkerLen = LITERAL_END_LONGHAND.length();
            }
            if (litEnd > -1) {
                sbTemp.append(line.substring(0, litEnd += endMarkerLen));
                return line.substring(litEnd);
            }
            sbTemp.append(line);
            sbTemp.append("\n");
        }
        return SKIP_BLANK_LINE;
    }

    private String skipComment(int comPos, String firstLine, BufferedReader brTemp, StringBuilder commentBuf) throws IOException {
        String beforeComment = firstLine.substring(0, comPos);
        int comEndPos = firstLine.indexOf(COMMENT_END);
        if (comEndPos > -1) {
            commentBuf.append(firstLine.substring(comPos, comEndPos += COMMENT_END.length()));
            return beforeComment + firstLine.substring(comEndPos);
        }
        commentBuf.append(firstLine.substring(comPos));
        commentBuf.append("\n");
        String line = null;
        while (brTemp.ready() && (line = brTemp.readLine()) != null) {
            comEndPos = line.indexOf(COMMENT_END);
            if (comEndPos > -1) {
                commentBuf.append(line.substring(0, comEndPos += COMMENT_END.length()));
                return beforeComment + line.substring(comEndPos);
            }
            commentBuf.append(line);
            commentBuf.append("\n");
        }
        return beforeComment;
    }

    private String stripComment(int comPos, String firstLine, BufferedReader brTemp) throws IOException {
        String beforeComment = firstLine.substring(0, comPos);
        int comEndPos = firstLine.indexOf(COMMENT_END);
        if (comEndPos > -1) {
            return beforeComment + firstLine.substring(comEndPos += COMMENT_END.length());
        }
        String line = null;
        while (brTemp.ready() && (line = brTemp.readLine()) != null) {
            comEndPos = line.indexOf(COMMENT_END);
            if (comEndPos <= -1) continue;
            return beforeComment + line.substring(comEndPos += COMMENT_END.length());
        }
        return beforeComment;
    }

    public static int findLiteralMarker(String text) {
        return TemplateSet.findLiteralMarker(text, 0);
    }

    public static int findLiteralMarker(String text, int startAt) {
        int literalPos = text.indexOf(LITERAL_START, startAt);
        int litPos = text.indexOf(LITERAL_SHORTHAND, startAt);
        if (litPos > -1 && literalPos > -1) {
            literalPos = Math.min(literalPos, litPos);
        } else if (litPos > -1 || literalPos > -1) {
            literalPos = Math.max(literalPos, litPos);
        }
        return literalPos;
    }

    private String readAndCacheSubTemplate(String name, String extension, BufferedReader brTemp, String firstLine) throws IOException {
        StringBuilder sbTemp = new StringBuilder();
        int subEndPos = firstLine.indexOf(SUB_END);
        int comPos = firstLine.indexOf(COMMENT_START);
        int literalPos = TemplateSet.findLiteralMarker(firstLine);
        boolean skipFirstLine = false;
        while ((literalPos > -1 || comPos > -1) && (subEndPos <= -1 || literalPos >= 0 && subEndPos >= literalPos || comPos >= 0 && subEndPos >= comPos)) {
            while (!(literalPos <= -1 || comPos >= 0 && comPos <= literalPos || subEndPos >= 0 && subEndPos <= literalPos)) {
                firstLine = this.getLiteralLines(literalPos, firstLine, brTemp, sbTemp);
                comPos = firstLine.indexOf(COMMENT_START);
                subEndPos = firstLine.indexOf(SUB_END);
                literalPos = TemplateSet.findLiteralMarker(firstLine);
            }
            while (!(comPos <= -1 || subEndPos >= 0 && subEndPos <= comPos || literalPos >= 0 && literalPos <= comPos)) {
                int lenAfter;
                int lenBefore = firstLine.length();
                if (lenBefore != (lenAfter = (firstLine = this.stripComment(comPos, firstLine, brTemp)).length()) && firstLine.trim().length() == 0) {
                    skipFirstLine = true;
                }
                comPos = firstLine.indexOf(COMMENT_START);
                subEndPos = firstLine.indexOf(SUB_END);
                literalPos = TemplateSet.findLiteralMarker(firstLine);
            }
        }
        if (subEndPos > -1) {
            sbTemp.append(firstLine.substring(0, subEndPos));
            this.addToCache(name, extension, sbTemp);
            return firstLine.substring(subEndPos + SUB_END.length());
        }
        if (!skipFirstLine) {
            sbTemp.append(firstLine);
            if (brTemp.ready() && firstLine.length() > 0) {
                sbTemp.append("\n");
            }
        }
        while (brTemp.ready()) {
            try {
                String line = this.getNextTemplateLine(name, extension, brTemp, sbTemp);
                if (line == null) break;
                if (line == SKIP_BLANK_LINE) continue;
                sbTemp.append(line);
                if (!brTemp.ready()) continue;
                sbTemp.append("\n");
            }
            catch (EndOfSnippetException e) {
                this.addToCache(name, extension, sbTemp);
                return e.getRestOfLine();
            }
        }
        this.addToCache(name, extension, sbTemp);
        return SKIP_BLANK_LINE;
    }

    private String getNextTemplateLine(String name, String extension, BufferedReader brTemp, StringBuilder sbTemp) throws IOException, EndOfSnippetException {
        String line = brTemp.readLine();
        if (line == null) {
            return null;
        }
        int comPos = line.indexOf(COMMENT_START);
        int subPos = line.indexOf(SUB_START);
        int subEndPos = line.indexOf(SUB_END);
        int litPos = TemplateSet.findLiteralMarker(line);
        while ((litPos > -1 || comPos > -1) && (subEndPos <= -1 || litPos >= 0 && subEndPos >= litPos || comPos >= 0 && comPos >= subEndPos) && (subPos <= -1 || litPos >= 0 && subPos >= litPos || comPos >= 0 && comPos >= subPos)) {
            while (!(litPos <= -1 || comPos >= 0 && comPos <= litPos || subEndPos >= 0 && subEndPos <= litPos)) {
                line = this.getLiteralLines(litPos, line, brTemp, sbTemp);
                comPos = line.indexOf(COMMENT_START);
                subPos = line.indexOf(SUB_START);
                subEndPos = line.indexOf(SUB_END);
                litPos = TemplateSet.findLiteralMarker(line);
            }
            while (!(comPos <= -1 || subPos >= 0 && subPos <= comPos || subEndPos >= 0 && subEndPos <= comPos || litPos >= 0 && litPos <= comPos)) {
                line = this.getCommentLines(comPos, line, brTemp, sbTemp);
                comPos = line.indexOf(COMMENT_START);
                subPos = line.indexOf(SUB_START);
                subEndPos = line.indexOf(SUB_END);
                litPos = TemplateSet.findLiteralMarker(line);
            }
        }
        if (subPos > -1 || subEndPos > -1) {
            int subNameEnd;
            if (subEndPos > -1 && (subPos == -1 || subEndPos <= subPos)) {
                sbTemp.append(line.substring(0, subEndPos));
                throw new EndOfSnippetException(line.substring(subEndPos + SUB_END.length()));
            }
            if (subPos > -1 && (subNameEnd = line.indexOf("}", subPos + SUB_START.length())) > -1) {
                sbTemp.append(line.substring(0, subPos));
                String subName = line.substring(subPos + SUB_START.length(), subNameEnd);
                String restOfLine = line.substring(subNameEnd + "}".length());
                line = this.readAndCacheSubTemplate(name + "." + subName, extension, brTemp, restOfLine);
                if (line.length() < 1) {
                    return SKIP_BLANK_LINE;
                }
            }
        }
        return line;
    }

    private void addToCache(String name, String extension, StringBuilder template) {
        String ref = extension + "." + name;
        String cleanRef = "_CLEAN_:" + ref;
        this.cache.put(cleanRef, Snippet.makeLiteralSnippet(template.toString()));
        this.cacheFetch.put(cleanRef, new Long(System.currentTimeMillis()));
        template = TemplateSet.expandShorthand(name, template);
        if (template == null) {
            return;
        }
        String tpl = TemplateSet.removeBlockTagIndents(template.toString());
        this.cache.put(ref, Snippet.getSnippet(tpl));
        this.cacheFetch.put(ref, new Long(System.currentTimeMillis()));
    }

    public static String removeBlockTagIndents(String template) {
        return RegexFilter.applyRegex(template, "s/^[ \\t]*(\\{(\\^|\\~\\.)\\/?(loop|if|else|elseIf|divider|onEmpty|body)([^\\}]*|[^\\}]*\\/[^\\/]*\\/[^\\}]*)\\})[ \\t]*$/$1/gm");
    }

    public static StringBuilder expandShorthand(String name, StringBuilder template) {
        int dotPos;
        if (template.indexOf("{^super}") > -1 || template.indexOf("{.super}") > -1) {
            return null;
        }
        String fullRef = name;
        if (fullRef != null && (dotPos = fullRef.indexOf(46)) > 0) {
            fullRef = name.substring(0, dotPos);
        }
        int cursor = template.indexOf("{");
        while (cursor > -1) {
            if (template.length() == cursor + 1) {
                return template;
            }
            char afterBrace = template.charAt(cursor + 1);
            if (afterBrace == '+') {
                cursor = TemplateSet.expandShorthandInclude(template, fullRef, cursor);
            } else if (afterBrace == '~' || afterBrace == '$') {
                cursor = TemplateSet.expandShorthandTag(template, fullRef, cursor);
            } else if (afterBrace == '^' || afterBrace == '.') {
                int afterLiteralBlock = TemplateSet.skipLiterals(template, cursor);
                if (afterLiteralBlock == cursor) {
                    template.replace(cursor + 1, cursor + 2, "~.");
                } else {
                    cursor = afterLiteralBlock;
                }
            } else if (afterBrace == '/') {
                template.replace(cursor + 1, cursor + 2, "~./");
            } else {
                cursor = afterBrace == '*' ? TemplateSet.expandShorthandMacro(template, fullRef, cursor) : (cursor += 2);
            }
            if (cursor <= -1) continue;
            cursor = template.indexOf("{", cursor);
        }
        return template;
    }

    private static int skipLiterals(StringBuilder template, int cursor) {
        int wall = template.length();
        int shortLen = LITERAL_SHORTHAND.length();
        int scanStart = cursor;
        if (cursor + shortLen <= wall && template.substring(cursor, cursor + shortLen).equals(LITERAL_SHORTHAND)) {
            scanStart = cursor + shortLen;
        } else {
            int longLen = LITERAL_START2.length();
            if (cursor + longLen <= wall && template.substring(cursor, cursor + longLen).equals(LITERAL_START2)) {
                scanStart = cursor + longLen;
            } else {
                longLen = LITERAL_START.length();
                if (cursor + longLen <= wall && template.substring(cursor, cursor + longLen).equals(LITERAL_START)) {
                    scanStart = cursor + longLen;
                }
            }
        }
        if (scanStart > cursor) {
            int tail = template.indexOf(LITERAL_END, scanStart);
            int longTail = template.indexOf(LITERAL_END_LONGHAND, scanStart);
            int n = tail < 0 ? longTail : (tail = longTail < 0 ? tail : Math.min(tail, longTail));
            if (tail < 0) {
                return wall;
            }
            return tail + (tail == longTail ? LITERAL_END_LONGHAND.length() : LITERAL_END.length());
        }
        return cursor;
    }

    private static int expandFnArgs(StringBuilder template, String fullRef, int cursor, String fnCall, int tagEnd) {
        int tagCursor = 0;
        StringBuilder expanded = null;
        int hashPos = fnCall.indexOf("#");
        while (hashPos > 1) {
            char preH = fnCall.charAt(hashPos - 1);
            if (preH == '\"' || preH == ',' || preH == ' ' || preH == '(') {
                if (expanded == null) {
                    expanded = new StringBuilder();
                }
                expanded.append(fnCall.substring(tagCursor, hashPos));
                expanded.append(fullRef);
                tagCursor = hashPos;
            }
            hashPos = fnCall.indexOf("#", hashPos + 1);
        }
        if (expanded != null) {
            expanded.append(fnCall.substring(tagCursor));
            String expandedTag = expanded.toString();
            template.replace(cursor + 2, tagEnd, expandedTag);
            tagEnd += expandedTag.length() - fnCall.length();
        }
        cursor = tagEnd + 1;
        return cursor;
    }

    private static int expandShorthandMacro(StringBuilder template, String fullRef, int cursor) {
        int offset = 2;
        while (template.charAt(cursor + offset) == ' ') {
            ++offset;
        }
        if (template.charAt(cursor + offset) == '#') {
            template.insert(cursor + offset, fullRef);
            int macroMarkerEnd = template.indexOf("}", cursor + offset + fullRef.length() + 1);
            if (macroMarkerEnd < 0) {
                return cursor + 1;
            }
            return macroMarkerEnd + "}".length();
        }
        int macroMarkerEnd = template.indexOf("}", cursor + offset);
        if (macroMarkerEnd < 0) {
            return cursor + 1;
        }
        return macroMarkerEnd + "}".length();
    }

    private static int expandShorthandTag(StringBuilder template, String fullRef, int cursor) {
        int tagEnd = TemplateSet.nextUnescapedDelim("}", template, cursor + 2);
        if (tagEnd < 0) {
            return -1;
        }
        String tagDirective = template.substring(cursor + 2, tagEnd);
        if (tagDirective.startsWith(".loop") || tagDirective.startsWith(".grid")) {
            return TemplateSet.expandFnArgs(template, fullRef, cursor, tagDirective, tagEnd);
        }
        int tagCursor = 0;
        StringBuilder expanded = null;
        int hashPos = tagDirective.indexOf("#");
        while (hashPos > 1) {
            char a = tagDirective.charAt(hashPos - 2);
            char b = tagDirective.charAt(hashPos - 1);
            if (b == '+') {
                if (a == ',' || a == ':' || a == '(') {
                    if (expanded == null) {
                        expanded = new StringBuilder();
                    }
                    expanded.append(tagDirective.substring(tagCursor, hashPos - 1));
                    expanded.append("~.include.");
                    expanded.append(fullRef);
                    tagCursor = hashPos;
                }
            } else if (!(a != ')' && a != 'e' && a != 'c' || b != '.' && b != ' ')) {
                if (expanded == null) {
                    expanded = new StringBuilder();
                }
                expanded.append(tagDirective.substring(tagCursor, hashPos));
                expanded.append(fullRef);
                tagCursor = hashPos;
            } else if (b == '(' && a == 'r') {
                if (expanded == null) {
                    expanded = new StringBuilder();
                }
                expanded.append(tagDirective.substring(tagCursor, hashPos));
                expanded.append(fullRef);
                tagCursor = hashPos;
            }
            hashPos = tagDirective.indexOf("#", hashPos + 1);
        }
        if (expanded != null) {
            expanded.append(tagDirective.substring(tagCursor));
            String expandedTag = expanded.toString();
            template.replace(cursor + 2, tagEnd, expandedTag);
            tagEnd += expandedTag.length() - tagDirective.length();
        }
        cursor = tagEnd + 1;
        return cursor;
    }

    private static int expandShorthandInclude(StringBuilder template, String fullRef, int cursor) {
        if (template.length() == cursor + 2) {
            return -1;
        }
        char afterPlus = template.charAt(cursor + 2);
        if (afterPlus == '#') {
            template.replace(cursor + 1, cursor + 2, "~.include." + fullRef);
            cursor += 11;
            cursor += fullRef.length();
            cursor = template.indexOf("}", cursor);
        } else if (afterPlus == '(') {
            int endCond = TemplateSet.nextUnescapedDelim(")", template, cursor + 3);
            if (endCond < 0) {
                return -1;
            }
            String cond = template.substring(cursor + 2, endCond + 1);
            if (template.length() == endCond + 1) {
                return -1;
            }
            if (template.charAt(endCond) == '#') {
                String expanded = "~.includeIf" + cond + "." + fullRef;
                template.replace(cursor + 1, endCond + 1, expanded);
                ++cursor;
                cursor += expanded.length();
                cursor = template.indexOf("}", cursor);
            }
        } else {
            cursor += 2;
        }
        return cursor;
    }

    public static int nextUnescapedDelim(String delim, StringBuilder sb, int searchFrom) {
        int delimPos = sb.indexOf(delim, searchFrom);
        boolean isProvenDelimeter = false;
        while (!isProvenDelimeter) {
            int bsCount = 0;
            while (delimPos - (1 + bsCount) >= searchFrom && sb.charAt(delimPos - (1 + bsCount)) == '\\') {
                ++bsCount;
            }
            if (bsCount % 2 == 0) {
                isProvenDelimeter = true;
                continue;
            }
            if ((delimPos = sb.indexOf(delim, delimPos + 1)) >= 0) continue;
            return -1;
        }
        return delimPos;
    }

    protected Snippet getFromCache(String name, String extension) {
        String ref = extension + "." + name.replace('#', '.');
        Snippet template = null;
        long cacheHowLong = (long)this.dirtyInterval * 60000L;
        if (cacheHowLong < 5000L) {
            cacheHowLong = 5000L;
        }
        if (this.cache.containsKey(ref)) {
            long lastFetch = this.cacheFetch.get(ref);
            long expireTime = lastFetch + cacheHowLong;
            if (System.currentTimeMillis() < expireTime) {
                template = this.cache.get(ref);
            }
        }
        return template;
    }

    public void clearCache() {
        this.cache.clear();
        this.cacheFetch.clear();
    }

    public void setDirtyInterval(int minutes) {
        this.dirtyInterval = minutes;
    }

    public String convertToMyTags(String withOldTags, String oldTagStart, String oldTagEnd) {
        return TemplateSet.convertTags(withOldTags, oldTagStart, oldTagEnd, this.tagStart, this.tagEnd);
    }

    public static String convertTags(String withOldTags, String oldTagStart, String oldTagEnd) {
        return TemplateSet.convertTags(withOldTags, oldTagStart, oldTagEnd, DEFAULT_TAG_START, DEFAULT_TAG_END);
    }

    public static String convertTags(String withOldTags, String oldTagStart, String oldTagEnd, String newTagStart, String newTagEnd) {
        int j;
        StringBuilder converted = new StringBuilder();
        int marker = 0;
        while ((j = withOldTags.indexOf(oldTagStart, marker)) > -1) {
            converted.append(withOldTags.substring(marker, j));
            marker = j + oldTagStart.length();
            int k = withOldTags.indexOf(oldTagEnd);
            if (k > -1) {
                converted.append(newTagStart);
                converted.append(withOldTags.substring(marker, k));
                converted.append(newTagEnd);
                marker = k + oldTagEnd.length();
                continue;
            }
            converted.append(oldTagStart);
        }
        if (marker == 0) {
            return withOldTags;
        }
        converted.append(withOldTags.substring(marker));
        return converted.toString();
    }

    public TemplateSet getSubset(String context) {
        return new TemplateSetSlice(this, context);
    }

    public void addProtocol(ContentSource src) {
        if (this.altSources == null) {
            this.altSources = new HashSet();
        }
        this.altSources.add(src);
    }

    private void shareContentSources(Chunk c) {
        if (this.altSources == null) {
            return;
        }
        for (ContentSource src : this.altSources) {
            c.addProtocol(src);
        }
    }

    public void signalFailureWithNull() {
        this.prettyFail = false;
    }

    private String truncateNameToStub(String name) {
        String stub;
        int slashPos = name.lastIndexOf(47);
        if (slashPos < -1) {
            slashPos = name.lastIndexOf(92);
        }
        String folder = null;
        if (slashPos > -1) {
            folder = name.substring(0, slashPos + 1);
            stub = name.substring(slashPos + 1).replace('#', '.');
        } else {
            stub = name.replace('#', '.');
        }
        int dotPos = stub.indexOf(".");
        if (dotPos > -1) {
            stub = stub.substring(0, dotPos);
        }
        if (slashPos > -1) {
            char fs = System.getProperty("file.separator").charAt(0);
            folder.replace('\\', fs);
            folder.replace('/', fs);
            return folder + stub;
        }
        return stub;
    }

    public String getTemplatePath(String templateName, String ext) {
        String stub = this.truncateNameToStub(templateName);
        return this.templatePath + stub + '.' + ext;
    }

    public String getResourcePath(String templateName, String ext) {
        String stub = this.truncateNameToStub(templateName);
        if (this.layerName == null) {
            return "/themes/" + stub + '.' + ext;
        }
        return "/themes/" + this.layerName + stub + '.' + ext;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Override
    public boolean provides(String itemName) {
        Snippet found = this._get(itemName, this.defaultExtension, false);
        return found != null;
    }

    public void setJarContext(Class<?> classInSameJar) {
        this.classInJar = classInSameJar;
    }

    public void setJarContext(Object ctx) {
        this.resourceContext = ctx;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
        if (layerName != null && !layerName.endsWith("/")) {
            this.layerName = this.layerName + "/";
        }
    }

    public void setEncoding(String encoding) {
        this.expectedEncoding = encoding;
    }

    private String getDefaultEncoding() {
        String override = System.getProperty("chunk.template.charset");
        if (override != null) {
            if (override.equalsIgnoreCase("SYSTEM")) {
                return Charset.defaultCharset().toString();
            }
            return override;
        }
        return "UTF-8";
    }

    @Override
    public Map<String, ChunkFilter> getFilters() {
        return null;
    }
}

