/*
 * Decompiled with CFR 0.152.
 */
package com.x5.util;

import com.x5.util.DataCapsule;
import com.x5.util.DataCapsuleReader;
import com.x5.util.TableData;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCapsuleTable
implements TableData {
    private DataCapsule[] records;
    private int cursor = -1;
    private Map<String, Object> currentRecord;
    private String[] columnLabels;

    public static DataCapsuleTable extractData(Object[] objArray) {
        if (objArray == null) {
            return null;
        }
        int capsuleCount = 0;
        DataCapsule[] dataCapsules = new DataCapsule[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            Object o = objArray[i];
            if (o == null || !(o instanceof DataCapsule)) continue;
            dataCapsules[i] = (DataCapsule)o;
            ++capsuleCount;
        }
        if (capsuleCount == 0) {
            return null;
        }
        return new DataCapsuleTable(dataCapsules);
    }

    public DataCapsuleTable(DataCapsule[] dataCapsules) {
        this.records = dataCapsules;
    }

    @Override
    public String[] getColumnLabels() {
        if (this.columnLabels == null) {
            DataCapsuleReader fish = this.getReader();
            return fish.getColumnLabels();
        }
        return this.columnLabels;
    }

    public Object[] getRowRaw() {
        if (this.cursor < 0) {
            this.cursor = 0;
        }
        if (this.records != null && this.records.length > this.cursor) {
            DataCapsuleReader fish = this.getReader();
            return fish.extractData(this.records[this.cursor]);
        }
        return null;
    }

    private DataCapsuleReader getReader() {
        int readerIndex = this.cursor;
        if (readerIndex < 0) {
            readerIndex = 0;
        }
        if (this.records != null && this.records.length > readerIndex) {
            DataCapsule atCursor = this.records[readerIndex];
            return DataCapsuleReader.getReader(atCursor);
        }
        return null;
    }

    @Override
    public String[] getRow() {
        Object[] rawRow = this.getRowRaw();
        String[] row = new String[rawRow.length];
        for (int i = 0; i < rawRow.length; ++i) {
            Object x = rawRow[i];
            row[i] = x == null ? null : (x instanceof String ? (String)x : x.toString());
        }
        return row;
    }

    @Override
    public boolean hasNext() {
        return this.records != null && this.records.length > this.cursor + 1;
    }

    @Override
    public Map<String, Object> nextRecord() {
        ++this.cursor;
        String[] values = this.getRow();
        if (values == null) {
            return null;
        }
        if (this.currentRecord == null) {
            this.currentRecord = new HashMap<String, Object>();
        } else {
            this.currentRecord.clear();
        }
        String[] labels = this.getColumnLabels();
        for (int i = 0; i < labels.length; ++i) {
            String label = labels[i];
            this.currentRecord.put(label, values[i]);
        }
        return this.currentRecord;
    }

    @Override
    public void setColumnLabels(String[] labels) {
        this.columnLabels = labels;
    }

    @Override
    public void reset() {
        this.cursor = -1;
    }
}

