/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.BlockTag;
import com.x5.template.Chunk;
import com.x5.template.Snippet;
import com.x5.template.SnippetComment;
import com.x5.template.SnippetPart;
import com.x5.template.SnippetTag;
import com.x5.template.filters.FilterArgs;
import com.x5.template.filters.RegexFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfTag
extends BlockTag {
    private String primaryCond;
    private Map<String, IfTest> condTests = new HashMap<String, IfTest>();
    private Snippet body;
    private boolean doTrim = true;
    private Map<String, String> options;
    private static final Pattern paramPattern = Pattern.compile(" ([a-zA-Z0-9_-]+)=(\"([^\"]*)\"|'([^']*)')");
    private static final Pattern UNIVERSAL_LF = Pattern.compile("\n|\r\n|\r\r");

    public IfTag(String params, Snippet body) {
        this.parseParams(params);
        this.body = body;
    }

    public IfTag() {
    }

    @Override
    public String getBlockStartMarker() {
        return "if";
    }

    @Override
    public String getBlockEndMarker() {
        return "/if";
    }

    private void parseParams(String params) {
        this.primaryCond = this.parseCond(params);
        this.condTests.put(this.primaryCond, new IfTest(this.primaryCond));
        this.options = this.parseAttributes(params);
        if (this.options == null) {
            return;
        }
        String trimOpt = this.options.get("trim");
        if (trimOpt != null && (trimOpt.equalsIgnoreCase("false") || trimOpt.equalsIgnoreCase("none"))) {
            this.doTrim = false;
        }
    }

    private String parseCond(String params) {
        if (params == null) {
            return null;
        }
        int exprPos = params.indexOf("f") + 1;
        int openParenPos = params.indexOf("(", exprPos);
        if (openParenPos > -1 && params.substring(exprPos, openParenPos).trim().length() == 0) {
            int closeParenPos = params.lastIndexOf(")");
            if (closeParenPos > openParenPos) {
                String test = params.substring(openParenPos + 1, closeParenPos);
                return test;
            }
            String test = params.substring(openParenPos + 1);
            return test;
        }
        return params.substring(exprPos);
    }

    private Map<String, String> parseAttributes(String params) {
        Matcher m = paramPattern.matcher(params);
        HashMap<String, String> opts = null;
        while (m.find()) {
            m.group(0);
            String paramName = m.group(1);
            String paramValue = m.group(3);
            if (opts == null) {
                opts = new HashMap<String, String>();
            }
            opts.put(paramName, paramValue);
        }
        return opts;
    }

    @Override
    public boolean doSmartTrimAroundBlock() {
        return true;
    }

    private String trimLeft(String x) {
        if (x == null) {
            return null;
        }
        int i = 0;
        char c = x.charAt(i);
        while (c == '\n' || c == ' ' || c == '\r' || c == '\t') {
            if (++i == x.length()) break;
            c = x.charAt(i);
        }
        if (i == 0) {
            return x;
        }
        return x.substring(i);
    }

    private String trimRight(String x) {
        if (x == null) {
            return null;
        }
        int i = x.length() - 1;
        char c = x.charAt(i);
        while (c == '\n' || c == ' ' || c == '\r' || c == '\t') {
            if (--i == -1) break;
            c = x.charAt(i);
        }
        if (++i >= x.length()) {
            return x;
        }
        return x.substring(0, i);
    }

    private boolean isTrimAll() {
        String trimOpt;
        String string = trimOpt = this.options != null ? this.options.get("trim") : null;
        return trimOpt != null && (trimOpt.equals("all") || trimOpt.equals("true"));
    }

    private String smartTrim(String x) {
        return this.smartTrim(x, false);
    }

    private String smartTrim(String x, boolean ignoreAll) {
        int firstLF;
        if (!ignoreAll && this.isTrimAll()) {
            return x.trim();
        }
        Matcher m = UNIVERSAL_LF.matcher(x);
        if (m.find() && x.substring(0, firstLF = m.start()).trim().length() == 0) {
            return x.substring(m.end());
        }
        return x;
    }

    private int nextElseTag(List<SnippetPart> bodyParts, int startAt) {
        int i = startAt;
        while (i < bodyParts.size()) {
            SnippetTag tag;
            SnippetPart part = bodyParts.get(i);
            if (part instanceof SnippetTag && (tag = (SnippetTag)part).getTag().startsWith(".else")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isTrueExpr(String test, Chunk context) {
        IfTest compiledTest = this.condTests.get(test);
        if (compiledTest == null) {
            compiledTest = new IfTest(test);
            this.condTests.put(test, compiledTest);
        }
        return compiledTest.isTrue(context);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void renderBlock(Writer out, Chunk context, String origin, int depth) throws IOException {
        block5: {
            bodyParts = this.body.getParts();
            nextElseTag = this.nextElseTag(bodyParts, 0);
            if (!this.isTrueExpr(this.primaryCond, context)) ** GOTO lbl20
            if (nextElseTag < 0) {
                nextElseTag = bodyParts.size();
            }
            this.renderChosenParts(out, context, origin, depth, bodyParts, 0, nextElseTag);
            break block5;
lbl-1000:
            // 1 sources

            {
                elseTag = ((SnippetTag)bodyParts.get(nextElseTag)).getTag();
                if (elseTag.equals(".else")) {
                    this.renderChosenParts(out, context, origin, depth, bodyParts, nextElseTag + 1, bodyParts.size());
                    break;
                }
                elseIfCond = this.parseCond(elseTag);
                if (this.isTrueExpr(elseIfCond, context)) {
                    nextBoundary = this.nextElseTag(bodyParts, nextElseTag + 1);
                    if (nextBoundary == -1) {
                        nextBoundary = bodyParts.size();
                    }
                    this.renderChosenParts(out, context, origin, depth, bodyParts, nextElseTag + 1, nextBoundary);
                    break;
                }
                nextElseTag = this.nextElseTag(bodyParts, nextElseTag + 1);
lbl20:
                // 2 sources

                ** while (nextElseTag > -1)
            }
        }
    }

    public void renderChosenParts(Writer out, Chunk context, String origin, int depth, List<SnippetPart> parts, int a, int b) throws IOException {
        block10: {
            block11: {
                block12: {
                    block9: {
                        if (this.doTrim) break block9;
                        int i = a;
                        while (i < b) {
                            SnippetPart part = parts.get(i);
                            part.render(out, context, origin, depth);
                            ++i;
                        }
                        break block10;
                    }
                    if (b <= a) break block10;
                    if (!this.isTrimAll()) break block11;
                    while (parts.get(a) instanceof SnippetComment && a < b - 1) {
                        ++a;
                    }
                    if (a + 1 != b) break block12;
                    SnippetPart onlyPart = parts.get(a);
                    if (onlyPart.isLiteral()) {
                        String trimmed = onlyPart.getText().trim();
                        out.append(trimmed);
                    } else {
                        onlyPart.render(out, context, origin, depth);
                    }
                    break block10;
                }
                SnippetPart partA = parts.get(a);
                if (partA.isLiteral()) {
                    String trimmed = this.trimLeft(partA.getText());
                    out.append(trimmed);
                }
                int i = a + 1;
                while (i < b - 1) {
                    SnippetPart part = parts.get(i);
                    part.render(out, context, origin, depth);
                    ++i;
                }
                SnippetPart partB = parts.get(b - 1);
                if (!partB.isLiteral()) break block10;
                String trimmed = this.trimRight(partB.getText());
                out.append(trimmed);
                break block10;
            }
            SnippetPart partA = parts.get(a);
            if (partA.isLiteral()) {
                String smartTrimmed = this.smartTrim(partA.getText());
                out.append(smartTrimmed);
            } else {
                partA.render(out, context, origin, depth);
            }
            int i = a + 1;
            while (i < b) {
                SnippetPart part = parts.get(i);
                part.render(out, context, origin, depth);
                ++i;
            }
        }
    }

    private static class IfTest {
        private static final int EXISTENCE = 0;
        private static final int COMPARE_CONSTANT = 1;
        private static final int COMPARE_REGEX = 2;
        private static final int COMPARE_TAGEXPR = 3;
        private int testType = 0;
        private boolean isNeg = false;
        private String compareTo = null;
        private SnippetTag leftSide = null;
        private SnippetTag rightSide = null;
        private static Map<String, Pattern> compiledRegex = new HashMap<String, Pattern>();

        public IfTest(String test) {
            this.init(test);
        }

        private void init(String test) {
            int scanStart;
            if (test == null || test.trim().length() == 0) {
                this.testType = 0;
                this.isNeg = true;
                return;
            }
            char firstChar = (test = test.trim()).charAt(0);
            if (firstChar == '$' || firstChar == '!' || firstChar == '~') {
                test = test.substring(1);
            }
            if (firstChar == '!' && (test.charAt(0) == '$' || test.charAt(0) == '~')) {
                test = test.substring(1);
            }
            if (test.indexOf(61, scanStart = this.skipModifiers(test)) < 0 && test.indexOf("!~", scanStart) < 0) {
                this.testType = 0;
                if (firstChar == '$' || firstChar == '~') {
                    this.leftSide = SnippetTag.parseTag(test);
                } else if (firstChar == '!') {
                    this.leftSide = SnippetTag.parseTag(test);
                    this.isNeg = true;
                } else {
                    this.isNeg = !test.equalsIgnoreCase("true");
                }
                return;
            }
            int eqPos = test.indexOf("==", scanStart);
            int ineqPos = test.indexOf("!=", scanStart);
            if (eqPos > 0 || ineqPos > 0) {
                this.isNeg = eqPos < 0;
                String tagA = test.substring(0, this.isNeg ? ineqPos : eqPos).trim();
                String tagB = test.substring((this.isNeg ? ineqPos : eqPos) + 2).trim();
                this.leftSide = SnippetTag.parseTag(tagA);
                if (tagB.charAt(0) == '$' || tagB.charAt(0) == '~') {
                    this.rightSide = SnippetTag.parseTag(tagB.substring(1));
                    this.testType = 3;
                } else {
                    this.testType = 1;
                    String match = tagB;
                    if (tagB.charAt(0) == '\"' && tagB.charAt(match.length() - 1) == '\"') {
                        match = tagB.substring(1, tagB.length() - 1);
                        match = this.unescape(match);
                    } else if (tagB.charAt(0) == '\'' && tagB.charAt(match.length() - 1) == '\'') {
                        match = tagB.substring(1, tagB.length() - 1);
                        match = this.unescape(match);
                    }
                    this.compareTo = match;
                }
                return;
            }
            int regexOpPos = test.indexOf("=~", scanStart);
            int negRegexOpPos = test.indexOf("!~", scanStart);
            if (regexOpPos < 0 && negRegexOpPos < 0) {
                this.isNeg = true;
                return;
            }
            this.isNeg = regexOpPos < 0;
            regexOpPos = this.isNeg ? negRegexOpPos : regexOpPos;
            String var = test.substring(0, regexOpPos).trim();
            String regex = test.substring(regexOpPos + 2).trim();
            this.leftSide = SnippetTag.parseTag(var);
            this.testType = 2;
            this.compareTo = regex;
        }

        private int skipModifiers(String test) {
            char[] chars = test.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (!Character.isJavaIdentifierPart(c) && c != '|' && c != ':' && c != '.') {
                    if (c == '(') {
                        if ((i = FilterArgs.nextUnescapedDelim(")", test, i + 1)) < 0) {
                            return chars.length;
                        }
                    } else {
                        if (c != '/') break;
                        if ((i = RegexFilter.nextRegexDelim(test, i + 1)) < 0) {
                            return chars.length;
                        }
                    }
                }
                ++i;
            }
            return i;
        }

        private String unescape(String x) {
            return RegexFilter.parseRegexEscapes(x);
        }

        public boolean isTrue(Chunk context) {
            switch (this.testType) {
                case 0: {
                    if (this.leftSide == null) {
                        return !this.isNeg;
                    }
                    Object leftSideValue = context.resolveTagValue(this.leftSide, 1);
                    return leftSideValue == null ? this.isNeg : !this.isNeg;
                }
                case 1: {
                    Object leftSideValue = context.resolveTagValue(this.leftSide, 1);
                    if (leftSideValue == null) {
                        return this.compareTo == null ? !this.isNeg : this.isNeg;
                    }
                    return leftSideValue.toString().equals(this.compareTo == null ? "" : this.compareTo) ? !this.isNeg : this.isNeg;
                }
                case 3: {
                    String rightStr;
                    Object leftSideValue = context.resolveTagValue(this.leftSide, 1);
                    Object rightSideValue = context.resolveTagValue(this.rightSide, 1);
                    if (leftSideValue == null && rightSideValue == null) {
                        return !this.isNeg;
                    }
                    if (leftSideValue == null || rightSideValue == null) {
                        return this.isNeg;
                    }
                    String leftStr = leftSideValue.toString();
                    return leftStr.equals(rightStr = rightSideValue.toString()) ? !this.isNeg : this.isNeg;
                }
                case 2: {
                    String testStr;
                    Object leftSideValue = context.resolveTagValue(this.leftSide, 1);
                    String string = testStr = leftSideValue == null ? null : leftSideValue.toString();
                    return this.isMatch(testStr, this.compareTo) ? !this.isNeg : this.isNeg;
                }
            }
            return false;
        }

        private boolean isMatch(String text, String regex) {
            if (text == null || regex == null) {
                return false;
            }
            Pattern p = this.compilePattern(regex = regex.trim());
            if (p == null) {
                return false;
            }
            Matcher m = p.matcher(text);
            return m.find();
        }

        private Pattern compilePattern(String regex) {
            int regexEnd;
            if (compiledRegex.containsKey(regex)) {
                return compiledRegex.get(regex);
            }
            int cursor = 0;
            if (regex.charAt(cursor) == 'm') {
                ++cursor;
            }
            if (regex.charAt(cursor) == '/') {
                ++cursor;
            }
            if ((regexEnd = RegexFilter.nextRegexDelim(regex, cursor)) < 0) {
                return null;
            }
            String pattern = regex.substring(cursor, regexEnd);
            boolean ignoreCase = false;
            boolean multiLine = false;
            boolean dotAll = false;
            int i = regex.length() - 1;
            while (i > regexEnd) {
                char option = regex.charAt(i);
                if (option == 'i') {
                    ignoreCase = true;
                }
                if (option == 'm') {
                    multiLine = true;
                }
                if (option == 's') {
                    dotAll = true;
                }
                --i;
            }
            if (multiLine) {
                pattern = "(?m)" + pattern;
            }
            if (ignoreCase) {
                pattern = "(?i)" + pattern;
            }
            if (dotAll) {
                pattern = "(?s)" + pattern;
            }
            Pattern p = Pattern.compile(pattern);
            compiledRegex.put(regex, p);
            return p;
        }
    }
}

