/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Attributes;
import com.x5.template.BlockTag;
import com.x5.template.Chunk;
import com.x5.template.ChunkFactory;
import com.x5.template.ContentSource;
import com.x5.template.InlineTable;
import com.x5.template.ObjectTable;
import com.x5.template.SimpleTable;
import com.x5.template.Snippet;
import com.x5.template.SnippetPart;
import com.x5.template.SnippetTag;
import com.x5.template.TableOfMaps;
import com.x5.template.filters.RegexFilter;
import com.x5.util.DataCapsuleTable;
import com.x5.util.ObjectDataMap;
import com.x5.util.TableData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoopTag
extends BlockTag {
    private String rowTemplate;
    private String emptyTemplate;
    private Map<String, Object> options;
    private Snippet emptySnippet = null;
    private Snippet dividerSnippet = null;
    private Snippet rowSnippet = null;
    private SnippetTag dataTag = null;
    private Chunk rowX;
    private static final String FIRST_MARKER = "first";
    private static final String LAST_MARKER = "last";
    private static final String PLACE_TAG = "place";
    private static final Pattern UNIVERSAL_LF = Pattern.compile("\n|\r\n|\r\r");

    public static void main(String[] args) {
        String loopTest = "{~.loop data=\"~mydata\" template=\"#test_row\" no_data=\"#test_empty\"}";
        LoopTag loop = new LoopTag();
        loop.parseParams(loopTest);
        System.out.println("row_tpl=" + loop.rowTemplate);
        System.out.println("empty_tpl=" + loop.emptyTemplate);
    }

    public static String expandLoop(String params, Chunk ch, String origin, int depth) {
        LoopTag loop = new LoopTag(params, ch, origin);
        StringWriter out = new StringWriter();
        try {
            loop.renderBlock(out, ch, origin, depth);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return out.toString();
    }

    public LoopTag() {
    }

    public LoopTag(String params, Chunk context, String origin) {
        this.parseParams(params);
        this.initWithoutBlock(context, origin);
    }

    private void initWithoutBlock(Chunk context, String origin) {
        String templateRef;
        if (context == null) {
            return;
        }
        ContentSource snippetRepo = context.getTemplateSet();
        if (snippetRepo == null) {
            return;
        }
        if (this.rowTemplate != null) {
            templateRef = LoopTag.qualifyTemplateRef(origin, this.rowTemplate);
            this.rowSnippet = snippetRepo.getSnippet(templateRef);
        }
        if (this.emptyTemplate != null) {
            templateRef = LoopTag.qualifyTemplateRef(origin, this.emptyTemplate);
            this.emptySnippet = snippetRepo.getSnippet(templateRef);
        }
    }

    public LoopTag(String params, Snippet body) {
        this.parseParams(params);
        this.initBody(body);
    }

    private void parseParams(String params) {
        if (params == null) {
            return;
        }
        if (params.startsWith(".loop(")) {
            this.parseFnParams(params);
        } else if (params.matches("\\.loop [^\" ]+ .*")) {
            this.parseEZParams(params);
        } else {
            this.parseAttributes(params);
        }
        this.parseCounterTagModifiers();
    }

    private void parseCounterTagModifiers() {
        if (this.options == null) {
            return;
        }
        String counterTag = (String)this.options.get("counter_tag");
        if (counterTag == null) {
            return;
        }
        if ((counterTag = this.eatTagSymbol(counterTag)).indexOf(",") > 0) {
            String[] counterArgs = counterTag.split(",");
            counterTag = counterArgs[0];
            try {
                int counterOffset = Integer.parseInt(counterArgs[1]);
                this.options.put("_counter_offset", new Integer(counterOffset));
            }
            catch (NumberFormatException counterOffset) {
                // empty catch block
            }
            if (counterArgs.length > 2) {
                try {
                    int counterStep = Integer.parseInt(counterArgs[2]);
                    this.options.put("_counter_step", new Integer(counterStep));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.options.put("counter_tag", counterTag);
    }

    private void parseEZParams(String paramString) {
        String loopVarPrefix;
        String[] params = paramString.split(" +");
        String dataVar = params[2];
        this.options = Attributes.parse(paramString);
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put("data", dataVar);
        if (this.options.containsKey("counter")) {
            this.options.put("counter_tag", this.options.get("counter"));
        }
        if (params.length > 3 && params[3].equals("as") && (loopVarPrefix = params[4]) != null) {
            if (loopVarPrefix.startsWith("~") || loopVarPrefix.startsWith("$")) {
                loopVarPrefix = loopVarPrefix.substring(1);
            }
            if (loopVarPrefix.contains(":")) {
                String[] labels = loopVarPrefix.split(":");
                String valuePrefix = labels[1];
                if (valuePrefix.startsWith("~") || valuePrefix.startsWith("$")) {
                    valuePrefix = valuePrefix.substring(1);
                }
                this.options.put("keyname", labels[0]);
                this.options.put("valname", valuePrefix);
            }
            this.options.put("name", loopVarPrefix);
        }
    }

    private void parseFnParams(String params) {
        String[] args;
        int endOfParams = params.length();
        if (params.endsWith(")")) {
            --endOfParams;
        }
        if ((args = (params = params.substring(".loop(".length(), endOfParams)).split(",")) != null && args.length >= 2) {
            String dataVar = args[0];
            if (this.options == null) {
                this.options = new HashMap<String, Object>();
            }
            this.options.put("data", dataVar);
            this.rowTemplate = args[1];
            this.emptyTemplate = args.length > 2 ? args[2] : null;
        }
    }

    private void parseAttributes(String params) {
        Map<String, Object> opts = Attributes.parse(params);
        if (opts == null) {
            return;
        }
        if (opts.containsKey("counter")) {
            opts.put("counter_tag", opts.get("counter"));
        }
        this.options = opts;
        this.rowTemplate = (String)opts.get("template");
        this.emptyTemplate = (String)opts.get("no_data");
    }

    private SnippetTag parseDataTag(String dataVar) {
        char c0 = dataVar.charAt(0);
        boolean isDirective = false;
        if (c0 == '^' || c0 == '.') {
            dataVar = RegexFilter.applyRegex(dataVar, "s/^[\\^\\.]/~./");
            isDirective = true;
        }
        if (isDirective || c0 == '~' || c0 == '$') {
            dataVar = dataVar.substring(1);
            return SnippetTag.parseTag(dataVar);
        }
        return null;
    }

    private TableData fetchData(String dataVar, Chunk context, String origin) {
        TableData data = null;
        if (dataVar == null || context == null) {
            return data;
        }
        if (this.dataTag == null) {
            this.dataTag = this.parseDataTag(dataVar);
            if (this.dataTag == null) {
                if (context != null) {
                    dataVar = LoopTag.qualifyTemplateRef(origin, dataVar);
                    String tableAsString = context.getTemplateSet().fetch(dataVar);
                    if (tableAsString != null) {
                        data = InlineTable.parseTable(tableAsString);
                    }
                }
                return data;
            }
        }
        Object dataStore = context.resolveTagValue(this.dataTag, 0);
        for (int depth = 0; dataStore != null && depth < 10; ++depth) {
            if (dataStore instanceof TableData) {
                data = (TableData)dataStore;
                break;
            }
            if (dataStore instanceof String) {
                data = InlineTable.parseTable((String)dataStore);
                break;
            }
            if (dataStore instanceof Snippet) {
                Snippet snippetData = (Snippet)dataStore;
                if (snippetData.isSimplePointer()) {
                    dataStore = context.get(snippetData.getPointer());
                    continue;
                }
                data = InlineTable.parseTable(snippetData.toString());
                break;
            }
            if (dataStore instanceof String[]) {
                data = new SimpleTable((String[])dataStore);
                break;
            }
            if (dataStore instanceof List) {
                List list = (List)dataStore;
                if (list.size() <= 0) break;
                Object a = list.get(0);
                if (a instanceof String) {
                    data = new SimpleTable(list);
                    break;
                }
                if (a instanceof Map) {
                    data = new TableOfMaps(list);
                    break;
                }
                data = TableOfMaps.boxCollection(list, this.isBeanBag(context, this.dataTag));
                break;
            }
            if (dataStore instanceof Object[]) {
                data = DataCapsuleTable.extractData((Object[])dataStore);
                if (data != null) break;
                data = TableOfMaps.boxObjectArray((Object[])dataStore, this.isBeanBag(context, this.dataTag));
                break;
            }
            if (!(dataStore instanceof Map)) break;
            if (dataStore instanceof ObjectDataMap) {
                Object unwrapped = ((ObjectDataMap)dataStore).unwrap();
                if (unwrapped instanceof Collection) {
                    data = TableOfMaps.boxCollection((Collection)unwrapped);
                } else if (unwrapped instanceof Enumeration) {
                    data = TableOfMaps.boxEnumeration((Enumeration)unwrapped);
                } else if (unwrapped instanceof Iterator) {
                    data = TableOfMaps.boxIterator((Iterator)unwrapped);
                } else if (unwrapped instanceof Map) {
                    data = new ObjectTable((Map)unwrapped);
                }
            }
            if (data != null) break;
            Map object = (Map)dataStore;
            data = new ObjectTable(object);
            break;
        }
        return data;
    }

    private boolean isBeanBag(Chunk context, SnippetTag dataTag) {
        String[] pathSegments = dataTag.getPath();
        String rootRef = pathSegments[0];
        Object o = context.get(rootRef);
        if (o != null && o instanceof ObjectDataMap) {
            return ((ObjectDataMap)o).isBean();
        }
        return false;
    }

    private void registerOption(String param, String value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(param, value);
    }

    public void cookLoopToPrinter(Writer out, Chunk context, String origin, boolean isBlock, int depth, TableData data) throws IOException {
        int i;
        if (data == null || !data.hasNext()) {
            if (this.emptySnippet == null) {
                String errMsg = "[Loop error: Empty Table - please " + (isBlock ? "supply onEmpty section in loop block]" : "specify no_data template parameter in loop tag]");
                if (context == null || context.renderErrorsToOutput()) {
                    out.append(errMsg);
                }
                if (context != null) {
                    context.logError(errMsg);
                }
            } else {
                this.emptySnippet.render(out, context, depth);
            }
            return;
        }
        Snippet dividerSnippet = null;
        boolean createArrayTags = false;
        boolean counterTags = false;
        int counterOffset = 0;
        int counterStep = 1;
        String counterTag = null;
        String firstRunTag = null;
        String lastRunTag = null;
        String placeTag = null;
        String objectKeyLabel = null;
        String objectValueLabel = null;
        if (this.options != null) {
            if (this.options.containsKey("dividerSnippet")) {
                dividerSnippet = (Snippet)this.options.get("dividerSnippet");
            } else if (this.options.containsKey("divider")) {
                String dividerTemplate = (String)this.options.get("divider");
                dividerTemplate = LoopTag.qualifyTemplateRef(origin, dividerTemplate);
                ContentSource templates = context.getTemplateSet();
                dividerSnippet = templates != null && templates.provides(dividerTemplate) ? templates.getSnippet(dividerTemplate) : Snippet.getSnippet(dividerTemplate);
                this.options.put("dividerSnippet", dividerSnippet);
            }
            if (this.options.containsKey("array_tags")) {
                createArrayTags = true;
            }
            if (this.options.containsKey("counter_tags")) {
                counterTags = true;
            }
            if (this.options.containsKey("counter_tag")) {
                counterTag = (String)this.options.get("counter_tag");
                if (this.options.containsKey("_counter_offset")) {
                    counterOffset = (Integer)this.options.get("_counter_offset");
                }
                if (this.options.containsKey("_counter_step")) {
                    counterStep = (Integer)this.options.get("_counter_step");
                }
            }
            if (this.options.containsKey("first_last")) {
                String tagNames = (String)this.options.get("first_last");
                if (tagNames.indexOf(",") > 0) {
                    String[] userFirstLast = tagNames.split(",");
                    firstRunTag = this.eatTagSymbol(userFirstLast[0]);
                    lastRunTag = this.eatTagSymbol(userFirstLast[1]);
                    if (userFirstLast.length > 2) {
                        placeTag = this.eatTagSymbol(userFirstLast[2]);
                    }
                }
                if (firstRunTag == null || firstRunTag.length() == 0) {
                    firstRunTag = FIRST_MARKER;
                }
                if (lastRunTag == null || lastRunTag.length() == 0) {
                    lastRunTag = LAST_MARKER;
                }
                if (placeTag == null || placeTag.length() == 0) {
                    placeTag = PLACE_TAG;
                }
            }
            if (this.options.containsKey("valname")) {
                objectValueLabel = (String)this.options.get("valname");
                if (this.options.containsKey("keyname")) {
                    objectKeyLabel = (String)this.options.get("keyname");
                }
            }
        }
        ChunkFactory factory = context.getChunkFactory();
        if (this.rowX == null) {
            this.rowX = factory == null ? new Chunk() : factory.makeChunk();
            this.rowX.append(this.rowSnippet);
        }
        this.rowX.setLocale(context.getLocale());
        String prefix = null;
        if (this.options != null && this.options.containsKey("name")) {
            String name;
            prefix = name = (String)this.options.get("name");
        }
        if (objectValueLabel == null && data instanceof ObjectTable) {
            objectKeyLabel = "attr";
            objectValueLabel = prefix == null ? prefix : "value";
        }
        String[] columnLabels = data.getColumnLabels();
        if (createArrayTags && columnLabels == null) {
            createArrayTags = false;
        }
        String[] prefixedLabels = null;
        String[] prefixedIndices = null;
        String[] anonIndices = null;
        if (prefix != null && columnLabels != null) {
            prefixedLabels = new String[columnLabels.length];
            i = columnLabels.length - 1;
            while (i > -1) {
                prefixedLabels[i] = String.valueOf(prefix) + "." + columnLabels[i];
                --i;
            }
            if (createArrayTags) {
                prefixedIndices = new String[columnLabels.length];
                i = 0;
                while (i < prefixedIndices.length) {
                    prefixedIndices[i] = String.valueOf(prefix) + "[" + i + "]";
                    ++i;
                }
            }
        }
        if (createArrayTags) {
            anonIndices = new String[columnLabels.length];
            i = 0;
            while (i < anonIndices.length) {
                anonIndices[i] = "DATA[" + i + "]";
                ++i;
            }
        }
        int counter = 0;
        while (data.hasNext()) {
            Object fieldName;
            Object value;
            Object field;
            if (counter > 0) {
                this.rowX.resetTags();
                if (dividerSnippet != null) {
                    dividerSnippet.render(out, context, depth);
                }
            }
            if (counterTags) {
                this.rowX.set("0", counter);
                this.rowX.set("1", counter + 1);
            }
            if (counterTag != null) {
                this.rowX.set(counterTag, counterOffset + counter * counterStep);
            }
            Map<String, Object> record = data.nextRecord();
            if (objectValueLabel != null) {
                if (objectKeyLabel != null) {
                    this.rowX.setOrDelete(objectKeyLabel, record.get("key"));
                }
                this.rowX.setOrDelete(objectValueLabel, record.get("value"));
            } else if (prefix != null) {
                this.rowX.set(prefix, record);
                if (createArrayTags) {
                    int i2 = columnLabels.length - 1;
                    while (i2 > -1) {
                        field = columnLabels[i2];
                        value = record.get(field);
                        this.rowX.setOrDelete(prefixedIndices[i2], value);
                        --i2;
                    }
                }
            } else if (columnLabels == null) {
                for (String key : record.keySet()) {
                    value = record.get(key);
                    fieldName = key;
                    this.rowX.setOrDelete((String)fieldName, value);
                }
            } else {
                int i3 = columnLabels.length - 1;
                while (i3 > -1) {
                    field = columnLabels[i3];
                    value = record.get(field);
                    fieldName = field;
                    this.rowX.setOrDelete((String)fieldName, value);
                    if (createArrayTags) {
                        this.rowX.setOrDelete(anonIndices[i3], value);
                    }
                    --i3;
                }
            }
            if (prefix != null && columnLabels != null && columnLabels.length == 1 && columnLabels[0].equals("_anonymous_")) {
                this.rowX.setOrDelete(prefix, record.get("_anonymous_"));
            }
            if (firstRunTag != null) {
                if (counter == 0) {
                    this.rowX.set(firstRunTag);
                    this.rowX.set(placeTag, firstRunTag);
                    if (prefix != null) {
                        this.rowX.set(String.valueOf(prefix) + "." + firstRunTag);
                        this.rowX.set(String.valueOf(prefix) + "." + placeTag, firstRunTag);
                    }
                } else {
                    this.rowX.set(placeTag, "");
                    if (prefix != null) {
                        this.rowX.set(String.valueOf(prefix) + "." + placeTag, "");
                    }
                }
            }
            if (lastRunTag != null && !data.hasNext()) {
                String place = counter == 0 ? String.valueOf(firstRunTag) + " " + lastRunTag : lastRunTag;
                this.rowX.set(lastRunTag);
                this.rowX.set(placeTag, place);
                if (prefix != null) {
                    this.rowX.set(String.valueOf(prefix) + "." + lastRunTag);
                    this.rowX.set(String.valueOf(prefix) + "." + placeTag, place);
                }
            }
            this.rowX.render(out, context);
            ++counter;
        }
        data.reset();
        this.rowX.resetTags();
    }

    private String eatTagSymbol(String tag) {
        char c0;
        if (tag == null) {
            return null;
        }
        char c = c0 = tag.length() > 0 ? tag.charAt(0) : (char)'\u0000';
        if (c0 == '$' || c0 == '~') {
            return tag.substring(1);
        }
        return tag;
    }

    @Override
    public boolean hasBody(String openingTag) {
        return openingTag != null && openingTag.indexOf("template=") < 0;
    }

    public static String getAttribute(String attr, String toScan) {
        if (toScan == null) {
            return null;
        }
        int spacePos = toScan.indexOf(32);
        if (spacePos < 0) {
            return null;
        }
        String attrs = toScan.substring(spacePos + 1);
        int attrPos = attrs.indexOf(attr);
        if (attrPos < 0) {
            return null;
        }
        int eqPos = attrs.indexOf(61, attrPos + attr.length());
        int begQuotePos = attrs.indexOf(34, eqPos);
        if (begQuotePos < 0) {
            return null;
        }
        int endQuotePos = begQuotePos + 1;
        do {
            if ((endQuotePos = attrs.indexOf(34, endQuotePos)) < 0) {
                return null;
            }
            if (attrs.charAt(endQuotePos - 1) != '\\') continue;
            ++endQuotePos;
        } while (endQuotePos < attrs.length() && attrs.charAt(endQuotePos) != '\"');
        if (endQuotePos < attrs.length()) {
            return attrs.substring(begQuotePos + 1, endQuotePos);
        }
        return null;
    }

    @Override
    public String getBlockStartMarker() {
        return "loop";
    }

    @Override
    public String getBlockEndMarker() {
        return "/loop";
    }

    @Override
    public boolean doSmartTrimAroundBlock() {
        return true;
    }

    private void smartTrim(List<SnippetPart> subParts) {
        LoopTag.smartTrimSnippetParts(subParts, this.isTrimAll());
    }

    public static void smartTrimSnippetParts(List<SnippetPart> subParts, boolean isTrimAll) {
        if (subParts != null && subParts.size() > 0) {
            SnippetPart lastPart;
            SnippetPart firstPart = subParts.get(0);
            if (firstPart.isLiteral()) {
                String trimmed = isTrimAll ? LoopTag.trimLeft(firstPart.getText()) : LoopTag.smartTrimString(firstPart.getText(), true, false);
                firstPart.setText(trimmed);
            }
            if (isTrimAll && (lastPart = subParts.get(subParts.size() - 1)).isLiteral()) {
                String trimmed = LoopTag.trimRight(lastPart.getText());
                lastPart.setText(trimmed);
            }
        }
    }

    private static String trimLeft(String x) {
        if (x == null) {
            return null;
        }
        int i = 0;
        char c = x.charAt(i);
        while (c == '\n' || c == ' ' || c == '\r' || c == '\t') {
            if (++i == x.length()) break;
            c = x.charAt(i);
        }
        if (i == 0) {
            return x;
        }
        return x.substring(i);
    }

    private static String trimRight(String x) {
        if (x == null) {
            return null;
        }
        int i = x.length() - 1;
        char c = x.charAt(i);
        while (c == '\n' || c == ' ' || c == '\r' || c == '\t') {
            if (--i == -1) break;
            c = x.charAt(i);
        }
        if (++i >= x.length()) {
            return x;
        }
        return x.substring(0, i);
    }

    private boolean isTrimAll() {
        String trimOpt;
        String string = trimOpt = this.options != null ? (String)this.options.get("trim") : null;
        return trimOpt != null && trimOpt.equals("all");
    }

    private static String smartTrimString(String x, boolean ignoreAll, boolean isTrimAll) {
        int firstLF;
        if (!ignoreAll && isTrimAll) {
            return x.trim();
        }
        Matcher m = UNIVERSAL_LF.matcher(x);
        if (m.find() && x.substring(0, firstLF = m.start()).trim().length() == 0) {
            return x.substring(m.end());
        }
        return ignoreAll ? x : x.trim();
    }

    private void initBody(Snippet body) {
        String trimOpt;
        List<SnippetPart> bodyParts = body.getParts();
        int eMarker = -1;
        int dMarker = -1;
        int eMarkerEnd = bodyParts.size();
        int dMarkerEnd = bodyParts.size();
        int i = bodyParts.size() - 1;
        while (i >= 0) {
            SnippetPart part = bodyParts.get(i);
            if (part.isTag()) {
                SnippetTag tag = (SnippetTag)part;
                String tagText = tag.getTag();
                if (tagText.equals(".onEmpty")) {
                    eMarker = i;
                } else if (tagText.equals(".divider")) {
                    dMarker = i;
                } else if (tagText.equals("./divider")) {
                    dMarkerEnd = i;
                } else if (tagText.equals("./onEmpty")) {
                    eMarkerEnd = i;
                }
            }
            --i;
        }
        boolean doTrim = true;
        String string = trimOpt = this.options == null ? null : (String)this.options.get("trim");
        if (trimOpt != null && trimOpt.equalsIgnoreCase("false")) {
            doTrim = false;
        }
        int bodyEnd = -1;
        if (eMarker > -1 && dMarker > -1) {
            if (eMarker > dMarker) {
                bodyEnd = dMarker;
                dMarkerEnd = Math.min(eMarker, dMarkerEnd);
            } else {
                bodyEnd = eMarker;
                eMarkerEnd = Math.min(dMarker, eMarkerEnd);
            }
            this.emptySnippet = this.extractParts(bodyParts, eMarker + 1, eMarkerEnd, doTrim);
            this.dividerSnippet = this.extractParts(bodyParts, dMarker + 1, dMarkerEnd, doTrim);
        } else if (eMarker > -1) {
            bodyEnd = eMarker;
            this.emptySnippet = this.extractParts(bodyParts, eMarker + 1, eMarkerEnd, doTrim);
            this.dividerSnippet = null;
        } else if (dMarker > -1) {
            bodyEnd = dMarker;
            this.emptySnippet = null;
            this.dividerSnippet = this.extractParts(bodyParts, dMarker + 1, dMarkerEnd, doTrim);
        } else {
            this.emptySnippet = null;
            this.dividerSnippet = null;
        }
        if (bodyEnd > -1) {
            int i2 = bodyParts.size() - 1;
            while (i2 >= bodyEnd) {
                bodyParts.remove(i2);
                --i2;
            }
        }
        if (doTrim) {
            this.smartTrim(bodyParts);
        }
        this.rowSnippet = body;
    }

    private Snippet extractParts(List<SnippetPart> parts, int a, int b, boolean doTrim) {
        ArrayList<SnippetPart> subParts = new ArrayList<SnippetPart>();
        int i = a;
        while (i < b) {
            subParts.add(parts.get(i));
            ++i;
        }
        if (doTrim) {
            this.smartTrim(subParts);
        }
        return new Snippet(subParts);
    }

    @Override
    public void renderBlock(Writer out, Chunk context, String origin, int depth) throws IOException {
        if (this.dividerSnippet != null && !this.options.containsKey("dividerSnippet")) {
            this.options.put("dividerSnippet", this.dividerSnippet);
        }
        TableData data = null;
        if (this.options != null) {
            data = this.fetchData((String)this.options.get("data"), context, origin);
        }
        this.cookLoopToPrinter(out, context, origin, true, depth, data);
    }
}

