/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.Snippet;
import com.x5.template.filters.AlternateFilter;
import com.x5.template.filters.Base64DecodeFilter;
import com.x5.template.filters.Base64EncodeFilter;
import com.x5.template.filters.BooleanFilter;
import com.x5.template.filters.CalcFilter;
import com.x5.template.filters.CheckedFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.DefangFilter;
import com.x5.template.filters.DefaultFilter;
import com.x5.template.filters.EscapeQuotesFilter;
import com.x5.template.filters.EscapeXMLFilter;
import com.x5.template.filters.ExecFilter;
import com.x5.template.filters.FilterArgs;
import com.x5.template.filters.FormatFilter;
import com.x5.template.filters.HexFilter;
import com.x5.template.filters.HexUpperFilter;
import com.x5.template.filters.IndentFilter;
import com.x5.template.filters.JoinFilter;
import com.x5.template.filters.LengthFilter;
import com.x5.template.filters.LetterCaseFilter;
import com.x5.template.filters.ListIndexFilter;
import com.x5.template.filters.MD5Base64Filter;
import com.x5.template.filters.MD5HexFilter;
import com.x5.template.filters.OnDefinedFilter;
import com.x5.template.filters.OnEmptyFilter;
import com.x5.template.filters.OnMatchFilter;
import com.x5.template.filters.OrdinalSuffixFilter;
import com.x5.template.filters.PadLeftFilter;
import com.x5.template.filters.PadRightFilter;
import com.x5.template.filters.PageFilter;
import com.x5.template.filters.QuickCalcFilter;
import com.x5.template.filters.RegexFilter;
import com.x5.template.filters.ReverseFilter;
import com.x5.template.filters.SHA1Base64Filter;
import com.x5.template.filters.SHA1HexFilter;
import com.x5.template.filters.SelectedFilter;
import com.x5.template.filters.SliceFilter;
import com.x5.template.filters.SortFilter;
import com.x5.template.filters.SplitFilter;
import com.x5.template.filters.StringFilter;
import com.x5.template.filters.TranslateFilter;
import com.x5.template.filters.URLDecodeFilter;
import com.x5.template.filters.URLEncodeFilter;
import com.x5.template.filters.UnescapeXMLFilter;
import com.x5.util.ObjectDataMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicFilter
implements ChunkFilter {
    public static ChunkFilter[] stockFilters = new ChunkFilter[]{new AlternateFilter(), new Base64DecodeFilter(), new Base64EncodeFilter(), new BooleanFilter(), new CalcFilter(), new CheckedFilter(), new DefangFilter(), new DefaultFilter(), new EscapeQuotesFilter(), new EscapeXMLFilter(), new UnescapeXMLFilter(), new ExecFilter(), new FormatFilter(), new HexFilter(), new HexUpperFilter(), new IndentFilter(), new LetterCaseFilter(), new MD5HexFilter(), new MD5Base64Filter(), new OnEmptyFilter(), new OnDefinedFilter(), new OnMatchFilter(), new OrdinalSuffixFilter(), new PadLeftFilter(), new PadRightFilter(), new PageFilter(), new QuickCalcFilter(), new RegexFilter(), new SelectedFilter(), new SHA1HexFilter(), new SHA1Base64Filter(), new StringFilter(), new TranslateFilter(), new URLDecodeFilter(), new URLEncodeFilter(), new SliceFilter(), new SortFilter(), new ReverseFilter(), new JoinFilter(), new ListIndexFilter(), new SplitFilter(), new LengthFilter()};

    @Override
    public Object applyFilter(Chunk chunk, String text, FilterArgs args) {
        return this.transformText(chunk, text, args);
    }

    public abstract String transformText(Chunk var1, String var2, FilterArgs var3);

    @Override
    public abstract String getFilterName();

    @Override
    public String[] getFilterAliases() {
        return null;
    }

    @Override
    public Object applyFilter(Chunk chunk, Object object, FilterArgs args) {
        String stringifiedObject = object == null ? null : BasicFilter.stringify(object);
        return this.transformText(chunk, stringifiedObject, args);
    }

    public static String stringify(Snippet snippet) {
        return snippet.toSimpleString();
    }

    public static String stringify(Object object) {
        if (object instanceof Snippet) {
            return BasicFilter.stringify((Snippet)object);
        }
        return ObjectDataMap.getAsString(object);
    }

    public static Map<String, ChunkFilter> getStockFilters() {
        HashMap<String, ChunkFilter> filters = new HashMap<String, ChunkFilter>();
        ChunkFilter[] chunkFilterArray = stockFilters;
        int n = stockFilters.length;
        int n2 = 0;
        while (n2 < n) {
            ChunkFilter filter = chunkFilterArray[n2];
            filters.put(filter.getFilterName(), filter);
            String[] aliases = filter.getFilterAliases();
            if (aliases != null) {
                String[] stringArray = aliases;
                int n3 = aliases.length;
                int n4 = 0;
                while (n4 < n3) {
                    String alias = stringArray[n4];
                    filters.put(alias, filter);
                    ++n4;
                }
            }
            ++n2;
        }
        return filters;
    }
}

