/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.FilterArgs;

public class EscapeXMLFilter
extends BasicFilter
implements ChunkFilter {
    private static final String findMe = "&<>\"'";
    private static final String[] replaceWith = new String[]{"&amp;", "&lt;", "&gt;", "&quot;", "&apos;"};

    public String transformText(Chunk chunk, String text, FilterArgs args) {
        if (text == null) {
            return null;
        }
        boolean escapedSomething = false;
        StringBuilder escaped = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            int whichOne = findMe.indexOf(c);
            if (whichOne > -1) {
                escaped.append(replaceWith[whichOne]);
                escapedSomething = true;
            } else if (c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c < '\u0100') {
                escaped.append(c);
            } else if (c > '\u00ff') {
                if (c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                    escaped.append("&#x");
                    escaped.append(Integer.toHexString(c));
                    escaped.append(';');
                }
                escapedSomething = true;
            } else {
                escapedSomething = true;
            }
            ++i;
        }
        if (escapedSomething) {
            return escaped.toString();
        }
        return text;
    }

    public String getFilterName() {
        return "xml";
    }

    public String[] getFilterAliases() {
        return new String[]{"html", "xmlescape", "htmlescape", "escapexml", "escapehtml", "xmlesc", "htmlesc"};
    }
}

