/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.FilterArgs;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IndentFilter
extends BasicFilter
implements ChunkFilter {
    private static final Pattern EOL = Pattern.compile("(\\r\\n|\\r\\r|\\n)");

    public String transformText(Chunk chunk, String text, FilterArgs args) {
        return text == null ? null : IndentFilter.applyIndent(text, args);
    }

    public String getFilterName() {
        return "indent";
    }

    public static String applyIndent(String text, FilterArgs arg) {
        String[] args = arg.getFilterArgs();
        if (args == null) {
            return text;
        }
        String indent = args[0];
        String padChip = " ";
        if (args.length > 1) {
            padChip = args[1];
        }
        try {
            int pad = Integer.parseInt(indent);
            int textLen = text.length();
            String linePrefix = padChip;
            int i = 1;
            while (i < pad) {
                linePrefix = String.valueOf(linePrefix) + padChip;
                ++i;
            }
            StringBuilder indented = new StringBuilder();
            indented.append(linePrefix);
            Matcher m = EOL.matcher(text);
            int marker = 0;
            while (m.find()) {
                String line = text.substring(marker, m.end());
                indented.append(line);
                marker = m.end();
                if (marker >= textLen) continue;
                indented.append(linePrefix);
            }
            if (marker < textLen) {
                indented.append(text.substring(marker));
            }
            return indented.toString();
        }
        catch (NumberFormatException e) {
            return text;
        }
    }
}

