/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.CondTree;
import com.x5.template.Conditional;
import com.x5.template.InvalidExpressionException;
import com.x5.template.filters.FilterArgs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CondLexer {
    String conditional;
    CondTree parsed;
    private static Pattern END_OF_UNQUOTED_STRING = Pattern.compile("\\)|&&|\\|\\||\\s");

    public CondLexer(String conditional) {
        this.conditional = conditional;
    }

    public CondTree parse() throws InvalidExpressionException {
        if (this.parsed != null) {
            return this.parsed;
        }
        this.parsed = CondTree.buildBranch(this.lexLogicTokens());
        return this.parsed;
    }

    private Iterator<String> lexLogicTokens() {
        int len = this.conditional.length();
        ArrayList<String> tokens = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            char d;
            char c = this.conditional.charAt(i);
            while (Character.isWhitespace(c)) {
                if (++i == len) {
                    return tokens.iterator();
                }
                c = this.conditional.charAt(i);
            }
            if (c == '(' || c == ')' || c == '!') {
                tokens.add(this.conditional.substring(i, i + 1));
                continue;
            }
            char c2 = d = i + 1 < len ? this.conditional.charAt(i + 1) : (char)'\u0000';
            if (c == '&' && d == '&' || c == '|' && d == '|') {
                tokens.add(this.conditional.substring(i, i + 2));
                ++i;
                continue;
            }
            int j = this.endOfComparison(this.conditional, i);
            tokens.add(this.conditional.substring(i, j));
            i = j - 1;
        }
        return tokens.iterator();
    }

    private int endOfComparison(String s, int start) {
        int i = start;
        int exprCount = 0;
        boolean foundOperator = false;
        int len = s.length();
        while (i != len) {
            char c = s.charAt(i);
            while (Character.isWhitespace(c)) {
                if (++i == len) {
                    return len;
                }
                c = s.charAt(i);
            }
            if (c == '$' || c == '~') {
                i = Conditional.skipModifiers(s, i + 1);
                if (++exprCount != 2) continue;
                return i;
            }
            if (exprCount > 0 && (c == '&' || c == '|' || c == ')')) {
                return i;
            }
            if (exprCount > 0 && (c == '=' || c == '!')) {
                if (i + 1 == len) {
                    return len;
                }
                char d = s.charAt(i + 1);
                if (d == '=' || d == '~') {
                    foundOperator = true;
                    i += 2;
                    continue;
                }
            }
            if (foundOperator) {
                if (c == '\"' || c == '\'' || c == '/') {
                    String delim = Character.toString(c);
                    i = FilterArgs.nextUnescapedDelim(delim, s, i + 1);
                    return i > 0 ? i + 1 : len;
                }
                Matcher matcher = END_OF_UNQUOTED_STRING.matcher(s);
                if (matcher.find(i)) {
                    return matcher.start();
                }
                return len;
            }
            ++i;
        }
        return len;
    }
}

