/*
 * Decompiled with CFR 0.152.
 */
package xcmailr.client;

import com.google.gson.Gson;
import java.net.http.HttpClient;
import xcmailr.client.MailApi;
import xcmailr.client.MailboxApi;
import xcmailr.client.impl.MailApiImpl;
import xcmailr.client.impl.MailboxApiImpl;
import xcmailr.client.impl.RestApiClient;
import xcmailr.client.impl.Utils;

public class XCMailrClient {
    private final MailApi mailApi;
    private final MailboxApi mailboxApi;

    public XCMailrClient(String baseUrl, String apiToken) {
        this(baseUrl, apiToken, HttpClient.newHttpClient());
    }

    public XCMailrClient(String baseUrl, String apiToken, HttpClient httpClient) {
        Utils.notBlank(baseUrl, "baseUrl");
        Utils.notBlank(apiToken, "apiToken");
        Utils.notNull(httpClient, "httpClient");
        RestApiClient client = new RestApiClient(baseUrl, apiToken, httpClient);
        Gson gson = new Gson();
        this.mailApi = new MailApiImpl(client, gson);
        this.mailboxApi = new MailboxApiImpl(client, gson);
    }

    public MailboxApi mailboxes() {
        return this.mailboxApi;
    }

    public MailApi mails() {
        return this.mailApi;
    }
}

