/*
 * Decompiled with CFR 0.152.
 */
package xcmailr.client.impl;

import com.google.gson.Gson;
import java.net.http.HttpResponse;
import xcmailr.client.XCMailrApiException;
import xcmailr.client.impl.RestApiClient;
import xcmailr.client.impl.Utils;

public abstract class AbstractApiImpl {
    protected final RestApiClient client;
    protected final Gson gson;

    protected AbstractApiImpl(RestApiClient client, Gson gson) {
        this.client = client;
        this.gson = gson;
    }

    protected void checkStatusCode(HttpResponse<?> response, int ... expectedStatusCodes) throws XCMailrApiException {
        int actualStatusCode = response.statusCode();
        for (int expectedStatusCode : expectedStatusCodes) {
            if (actualStatusCode != expectedStatusCode) continue;
            return;
        }
        Object responseBody = response.body();
        String responseBodyAsText = responseBody instanceof String ? (String)responseBody : null;
        throw new XCMailrApiException("API call failed", actualStatusCode, responseBodyAsText);
    }

    protected StringBuilder appendQueryParameter(StringBuilder query, String name, String value) {
        if (value != null) {
            query.append('&');
            query.append(Utils.encodeQueryParameter(name)).append('=').append(Utils.encodeQueryParameter(value));
        }
        return query;
    }
}

