/*
 * Decompiled with CFR 0.152.
 */
package xcmailr.client.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.http.HttpResponse;
import java.util.List;
import xcmailr.client.Mail;
import xcmailr.client.MailApi;
import xcmailr.client.MailFilterOptions;
import xcmailr.client.impl.AbstractApiImpl;
import xcmailr.client.impl.HttpMethod;
import xcmailr.client.impl.RestApiClient;
import xcmailr.client.impl.Utils;

public class MailApiImpl
extends AbstractApiImpl
implements MailApi {
    private static final Type mailListType = new TypeToken<List<Mail>>(){}.getType();

    public MailApiImpl(RestApiClient client, Gson gson) {
        super(client, gson);
    }

    @Override
    public List<Mail> listMails(String mailboxAddress, MailFilterOptions options) throws Exception {
        Utils.notBlank(mailboxAddress, "mailboxAddress");
        StringBuilder url = new StringBuilder("mails?");
        this.appendQueryParameter(url, "mailboxAddress", mailboxAddress);
        if (options != null) {
            this.appendQueryParameter(url, "from", options.senderPattern);
            this.appendQueryParameter(url, "subject", options.subjectPattern);
            this.appendQueryParameter(url, "mailHeader", options.headersPattern);
            this.appendQueryParameter(url, "htmlContent", options.htmlContentPattern);
            this.appendQueryParameter(url, "textContent", options.textContentPattern);
            this.appendQueryParameter(url, "lastMatch", String.valueOf(options.lastMatchOnly));
        }
        HttpResponse<String> response = this.client.executeRequest(HttpMethod.GET, url.toString());
        this.checkStatusCode(response, 200);
        return (List)this.gson.fromJson(response.body(), mailListType);
    }

    @Override
    public Mail getMail(long mailId) throws Exception {
        HttpResponse<String> response = this.client.executeRequest(HttpMethod.GET, "mails/" + mailId);
        this.checkStatusCode(response, 200);
        return (Mail)this.gson.fromJson(response.body(), Mail.class);
    }

    @Override
    public InputStream openAttachment(long mailId, String attachmentName) throws Exception {
        Utils.notBlank(attachmentName, "attachmentName");
        HttpResponse<InputStream> response = this.client.executeRequest2(HttpMethod.GET, "mails/" + mailId + "/attachments/" + Utils.encodePathSegment(attachmentName));
        this.checkStatusCode(response, 200);
        return response.body();
    }

    @Override
    public void deleteMail(long mailId) throws Exception {
        HttpResponse<String> response = this.client.executeRequest(HttpMethod.DELETE, "mails/" + mailId);
        this.checkStatusCode(response, 204);
    }
}

