/*
 * Decompiled with CFR 0.152.
 */
package xcmailr.client.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import xcmailr.client.Mailbox;
import xcmailr.client.MailboxApi;
import xcmailr.client.impl.AbstractApiImpl;
import xcmailr.client.impl.HttpMethod;
import xcmailr.client.impl.RestApiClient;
import xcmailr.client.impl.Utils;

public class MailboxApiImpl
extends AbstractApiImpl
implements MailboxApi {
    private static final String RELATIVE_PATH = "mailboxes";
    private static final Type mailboxListType = new TypeToken<List<Mailbox>>(){}.getType();

    public MailboxApiImpl(RestApiClient client, Gson gson) {
        super(client, gson);
    }

    @Override
    public List<Mailbox> listMailboxes() throws Exception {
        HttpResponse<String> response = this.client.executeRequest(HttpMethod.GET, RELATIVE_PATH);
        this.checkStatusCode(response, 200);
        return (List)this.gson.fromJson(response.body(), mailboxListType);
    }

    @Override
    public Mailbox createMailbox(String address, int minutesActive, boolean forwardEnabled) throws Exception {
        Utils.notBlank(address, "address");
        long deactivationTime = Instant.now().plus((long)minutesActive, ChronoUnit.MINUTES).toEpochMilli();
        return this.createMailbox(new Mailbox(address, deactivationTime, forwardEnabled));
    }

    @Override
    public Mailbox createMailbox(Mailbox mailbox) throws Exception {
        Utils.notNull(mailbox, "mailbox");
        Utils.notBlank(mailbox.address, "mailbox.address");
        String json = this.gson.toJson((Object)mailbox);
        HttpResponse<String> response = this.client.executeRequest(HttpMethod.POST, RELATIVE_PATH, json);
        this.checkStatusCode(response, 200, 201);
        return (Mailbox)this.gson.fromJson(response.body(), Mailbox.class);
    }

    @Override
    public Mailbox getMailbox(String address) throws Exception {
        Utils.notBlank(address, "address");
        HttpResponse<String> response = this.client.executeRequest(HttpMethod.GET, "mailboxes/" + Utils.encodePathSegment(address));
        this.checkStatusCode(response, 200);
        return (Mailbox)this.gson.fromJson(response.body(), Mailbox.class);
    }

    @Override
    public Mailbox updateMailbox(String address, String newAddress, int minutesActive, boolean forwardEnabled) throws Exception {
        long deactivationTime = Instant.now().plus((long)minutesActive, ChronoUnit.MINUTES).toEpochMilli();
        Mailbox mailbox = new Mailbox(newAddress, deactivationTime, forwardEnabled);
        return this.updateMailbox(address, mailbox);
    }

    @Override
    public Mailbox updateMailbox(String address, Mailbox mailbox) throws Exception {
        Utils.notBlank(address, "address");
        Utils.notNull(mailbox, "mailbox");
        Utils.notBlank(mailbox.address, "mailbox.address");
        String json = this.gson.toJson((Object)mailbox);
        HttpResponse<String> response = this.client.executeRequest(HttpMethod.PUT, "mailboxes/" + Utils.encodePathSegment(address), json);
        this.checkStatusCode(response, 200);
        return (Mailbox)this.gson.fromJson(response.body(), Mailbox.class);
    }

    @Override
    public void deleteMailbox(String address) throws Exception {
        Utils.notBlank(address, "address");
        HttpResponse<String> response = this.client.executeRequest(HttpMethod.DELETE, "mailboxes/" + Utils.encodePathSegment(address));
        this.checkStatusCode(response, 204);
    }
}

