/*
 * Decompiled with CFR 0.152.
 */
package xcmailr.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import xcmailr.client.impl.HttpMethod;

public class RestApiClient {
    private final String baseUrl;
    private final String apiToken;
    private final HttpClient httpClient;

    public RestApiClient(String baseUrl, String apiToken, HttpClient httpClient) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        this.apiToken = apiToken;
        this.httpClient = httpClient;
    }

    public HttpResponse<String> executeRequest(HttpMethod method, String relativeUrl) throws IOException, InterruptedException, URISyntaxException {
        return this.executeRequest(method, relativeUrl, null);
    }

    public HttpResponse<String> executeRequest(HttpMethod method, String relativeUrl, String jsonBody) throws IOException, InterruptedException, URISyntaxException {
        return this.executeRequest(method, relativeUrl, jsonBody, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<InputStream> executeRequest2(HttpMethod method, String relativeUrl) throws IOException, InterruptedException, URISyntaxException {
        return this.executeRequest(method, relativeUrl, null, HttpResponse.BodyHandlers.ofInputStream());
    }

    private <T> HttpResponse<T> executeRequest(HttpMethod method, String relativeUrl, String jsonBody, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException, URISyntaxException {
        URI uri = new URI(this.baseUrl + "api/v1/" + relativeUrl);
        String authHeaderValue = "Bearer " + this.apiToken;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri).header("Authorization", authHeaderValue).header("Accept", "application/json, */*");
        if (jsonBody == null) {
            requestBuilder.method(method.toString(), HttpRequest.BodyPublishers.noBody());
        } else {
            requestBuilder.header("Content-Type", "application/json");
            requestBuilder.method(method.toString(), HttpRequest.BodyPublishers.ofString(jsonBody));
        }
        HttpRequest request = requestBuilder.build();
        return this.httpClient.send(request, responseBodyHandler);
    }
}

