/*
 * Decompiled with CFR 0.152.
 */
package xcmailr.client.impl;

import java.nio.charset.StandardCharsets;

public class Utils {
    private static final String HEX = "0123456789ABCDEF";
    private static final String ALPHA_NUMERIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String UNRESERVED = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~";
    private static final String ALLOWED_CHARACTERS_IN_PATH_SEGMENT = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~:@!$'()*+,;&=";
    private static final String ALLOWED_CHARACTERS_IN_QUERY = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~:@!$'()*+,;/?";

    public static String encodePathSegment(String pathSegment) {
        return Utils.encode(pathSegment, ALLOWED_CHARACTERS_IN_PATH_SEGMENT, "%20");
    }

    public static String encodeQueryParameter(String queryParameter) {
        return Utils.encode(queryParameter, ALLOWED_CHARACTERS_IN_QUERY, "+");
    }

    private static String encode(String s, String allowedCharacters, String spaceEncoding) {
        StringBuilder sb = new StringBuilder();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (allowedCharacters.indexOf(c) >= 0) {
                sb.append(c);
                continue;
            }
            if (c == ' ') {
                sb.append(spaceEncoding);
                continue;
            }
            byte[] bytes = new String(chars, i, 1).getBytes(StandardCharsets.UTF_8);
            for (int j = 0; j < bytes.length; ++j) {
                byte b = bytes[j];
                int high = (b & 0xF0) >> 4;
                int low = b & 0xF;
                sb.append('%').append(HEX.charAt(high)).append(HEX.charAt(low));
            }
        }
        return sb.toString();
    }

    public static void notNull(Object parameterValue, String parameterName) throws IllegalArgumentException {
        if (parameterValue == null) {
            throw new IllegalArgumentException("Parameter '" + parameterName + "' must not be null");
        }
    }

    public static void notBlank(String parameterValue, String parameterName) throws IllegalArgumentException {
        if (parameterValue == null || parameterValue.isBlank()) {
            throw new IllegalArgumentException("Parameter '" + parameterName + "' must neither be null nor empty nor blank");
        }
    }
}

