/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.xpath;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitPrefixResolver;
import com.gargoylesoftware.htmlunit.html.xpath.XPathAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathHelper {
    private static ThreadLocal<Boolean> PROCESS_XPATH_ = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final Log log = LogFactory.getLog(XPathHelper.class);
    public static boolean useJaxen = true;
    private static final Pattern pattern = Pattern.compile("(@[a-zA-Z]+)");

    private XPathHelper() {
    }

    private static <T> List<T> getByXPath2(DomNode node, String xpathExpr, PrefixResolver resolver) {
        ArrayList<Object> list;
        block11: {
            if (xpathExpr == null) {
                throw new IllegalArgumentException("Null is not a valid XPath expression");
            }
            PROCESS_XPATH_.set(Boolean.TRUE);
            list = new ArrayList<Object>();
            try {
                XObject result = XPathHelper.evaluateXPath(node, xpathExpr, resolver);
                if (result instanceof XNodeSet) {
                    NodeList nodelist = ((XNodeSet)result).nodelist();
                    for (int i = 0; i < nodelist.getLength(); ++i) {
                        list.add(nodelist.item(i));
                    }
                    break block11;
                }
                if (result instanceof XNumber) {
                    list.add(result.num());
                    break block11;
                }
                if (result instanceof XBoolean) {
                    list.add(result.bool());
                    break block11;
                }
                if (result instanceof XString) {
                    list.add(result.str());
                    break block11;
                }
                throw new RuntimeException("Unproccessed " + result.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not retrieve XPath >" + xpathExpr + "< on " + node, e);
            }
            finally {
                PROCESS_XPATH_.set(Boolean.FALSE);
            }
        }
        return list;
    }

    public static boolean isProcessingXPath() {
        return PROCESS_XPATH_.get();
    }

    private static XObject evaluateXPath(DomNode contextNode, String str, PrefixResolver prefixResolver) throws TransformerException {
        XPathContext xpathSupport = new XPathContext();
        Node xpathExpressionContext = contextNode.getNodeType() == 9 ? ((Document)((Object)contextNode)).getDocumentElement() : contextNode;
        Object resolver = prefixResolver;
        if (resolver == null) {
            resolver = new HtmlUnitPrefixResolver(xpathExpressionContext);
        }
        boolean caseSensitive = contextNode.getPage().hasCaseSensitiveTagNames();
        XPathAdapter xpath = new XPathAdapter(str, null, (PrefixResolver)resolver, null, caseSensitive);
        int ctxtNode = xpathSupport.getDTMHandleFromNode((Node)contextNode);
        return xpath.execute(xpathSupport, ctxtNode, prefixResolver);
    }

    private static String preProcessXPath(String string, Node node) {
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String attribute = matcher.group(1);
            string = string.replace(attribute, attribute.toLowerCase());
        }
        return string;
    }

    /*
     * Exception decompiling
     */
    public static <T> List<T> getByXPath(DomNode node, String xpathExpr, PrefixResolver resolver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

