/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.xceptance.common.util.ParameterCheckUtils;
import java.util.ArrayList;

public final class CsvUtils {
    private static final char COMMA = ',';
    private static final char QUOTE_CHAR = '\"';
    private static final char LF = '\n';
    private static final char CR = '\r';

    private CsvUtils() {
    }

    public static String[] decode(String s) {
        return CsvUtils.decode(s, ',');
    }

    public static String decodeField(String s) {
        if (s == null) {
            return s;
        }
        if (s.length() < 2) {
            return s;
        }
        int length = s.length();
        if (s.charAt(0) != '\"' || s.charAt(length - 1) != '\"') {
            return s;
        }
        char[] buffer = s.toCharArray();
        int target = 0;
        for (int src = 1; src < length - 1; ++src) {
            char c = buffer[src];
            if (c == '\"' && (++src >= length - 1 || buffer[src] != '\"')) {
                throw new IllegalArgumentException("Parameter '" + s + "' is not properly CSV-encoded.");
            }
            buffer[target] = c;
            ++target;
        }
        return new String(buffer, 0, target);
    }

    public static String encode(String[] fields) {
        return CsvUtils.encode(fields, ',');
    }

    public static String encodeField(String s) {
        return CsvUtils.encodeField(s, ',');
    }

    public static String encodeField(String s, char fieldSeparator) {
        if (s == null || s.length() == 0) {
            return s;
        }
        char[] sourceChars = s.toCharArray();
        int sourceLength = sourceChars.length;
        boolean needsQuoting = false;
        int quotesRead = 0;
        for (int i = 0; i < sourceLength; ++i) {
            char c = sourceChars[i];
            if (c == '\"') {
                ++quotesRead;
            }
            if (needsQuoting || !CsvUtils.needsQuote(c, fieldSeparator)) continue;
            needsQuoting = true;
        }
        if (!needsQuoting) {
            return s;
        }
        char[] targetChars = new char[sourceLength + quotesRead + 2];
        int j = 1;
        int i = 0;
        while (i < sourceLength) {
            char c = sourceChars[i];
            if (c == '\"') {
                targetChars[j++] = c;
            }
            targetChars[j] = c;
            ++i;
            ++j;
        }
        targetChars[0] = 34;
        targetChars[j] = 34;
        return new String(targetChars);
    }

    public static String[] decode(String s, char fieldSeparator) {
        ParameterCheckUtils.isNotNull(s, "s");
        String[] fields = CsvUtils.split(s, fieldSeparator);
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            fields[i] = CsvUtils.decodeField(fields[i]);
        }
        return fields;
    }

    public static String encode(String[] fields, char fieldSeparator) {
        ParameterCheckUtils.isNotNullOrEmpty(fields, "fields");
        StringBuilder result = new StringBuilder(256);
        boolean isFirstField = true;
        for (String field : fields) {
            if (field == null) {
                throw new IllegalArgumentException("Array entry must not be null.");
            }
            if (isFirstField) {
                isFirstField = false;
            } else {
                result.append(fieldSeparator);
            }
            field = CsvUtils.encodeField(field, fieldSeparator);
            result.append(field);
        }
        return result.toString();
    }

    private static String[] split(String s, char fieldSeparator) {
        int length = s.length();
        if (length == 0) {
            return new String[]{""};
        }
        ArrayList<String> fields = new ArrayList<String>(32);
        int beginIndex = 0;
        boolean insideQuotes = false;
        char[] chars = s.toCharArray();
        for (int i = 0; i < length; ++i) {
            char c = chars[i];
            if (c == fieldSeparator) {
                if (insideQuotes) continue;
                fields.add(s.substring(beginIndex, i));
                beginIndex = i + 1;
                continue;
            }
            if (c != '\"') continue;
            insideQuotes = !insideQuotes;
        }
        fields.add(s.substring(beginIndex));
        return fields.toArray(new String[0]);
    }

    private static boolean needsQuote(char c, char separatorChar) {
        return c == '\"' || c == '\n' || c == '\r' || c == separatorChar;
    }
}

