/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@XStreamAlias(value="version")
public final class ProductInformation {
    private static final Log log = LogFactory.getLog(ProductInformation.class);
    private Date buildDate = new Date();
    private String productName = "Xceptance LoadTest";
    private String logogram = "XLT";
    private URL productURL;
    private String revisionNumber = "????";
    private String vendorName = "Xceptance Software Technologies GmbH";
    private String version = "?.?.?";

    public static ProductInformation getProductInformation() {
        return ProductInformationSingleton.instance;
    }

    private ProductInformation() {
        String urlString;
        int i;
        String resourceName = "/" + this.getClass().getName().replace('.', '/') + ".class";
        URL url = this.getClass().getResource(resourceName);
        if (url != null && (i = (urlString = url.toString()).lastIndexOf(resourceName)) != -1) {
            String baseUrlString = urlString.substring(0, i);
            String manifestUrlString = baseUrlString + "/META-INF/MANIFEST.MF";
            try {
                Manifest manifest = new Manifest(new URL(manifestUrlString).openStream());
                Attributes mainAttrs = manifest.getMainAttributes();
                this.productName = this.getValue(mainAttrs, "Implementation-Title", this.productName);
                this.logogram = this.getValue(mainAttrs, "Implementation-Logogram", this.logogram);
                this.vendorName = this.getValue(mainAttrs, "Implementation-Vendor", this.vendorName);
                this.version = this.getValue(mainAttrs, "Implementation-Version", this.version);
                this.productURL = new URL(this.getValue(mainAttrs, "Implementation-URL", "http://www.xceptance-loadtest.com/"));
                this.revisionNumber = this.getValue(mainAttrs, "X-Implementation-Revision", this.revisionNumber);
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                this.buildDate = format.parse(this.getValue(mainAttrs, "X-Implementation-Date", format.format(this.buildDate)));
            }
            catch (Exception ex) {
                log.error((Object)("Failed to read product information from manifest file: " + manifestUrlString), (Throwable)ex);
            }
        }
    }

    private String getValue(Attributes manifestAttributes, String attributeName, String defaultValue) {
        String value = manifestAttributes.getValue(attributeName);
        if (value == null || value.length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getLogogram() {
        return this.logogram;
    }

    public URL getProductURL() {
        return this.productURL;
    }

    public String getRevisionNumber() {
        return this.revisionNumber;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProductIdentifier() {
        return this.getProductName() + " " + this.getVersion() + " (r" + this.getRevisionNumber() + ")";
    }

    public String getCondensedProductIdentifier() {
        return this.getLogogram() + " " + this.getVersion() + ".r" + this.getRevisionNumber();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(this.getClass().getSimpleName()).append('[');
        buf.append("productName=").append(this.productName);
        buf.append(",version=").append(this.version);
        buf.append(",revisionNumber=").append(this.revisionNumber);
        buf.append(",buildDate=").append(this.buildDate);
        buf.append(",productURL=").append(this.productURL);
        buf.append(",vendorName=").append(this.vendorName);
        buf.append(']');
        return buf.toString();
    }

    private static final class ProductInformationSingleton {
        private static final ProductInformation instance = new ProductInformation();

        private ProductInformationSingleton() {
        }
    }
}

