/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class RouteMessagesToLog4jHandler
extends Handler {
    private static final String DEFAULT_LOGGER_NAME = "unknown";

    public static void install() {
        Handler[] handlers;
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        rootLogger.addHandler(new RouteMessagesToLog4jHandler());
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        org.apache.log4j.Level log4jLevel;
        if (record == null) {
            return;
        }
        org.apache.log4j.Logger log4jLogger = this.getLogger(record);
        if (log4jLogger.isEnabledFor((Priority)(log4jLevel = this.convertToLog4jLevel(record.getLevel())))) {
            LoggingEvent event = this.convertToLoggingEvent(record, log4jLogger, log4jLevel);
            log4jLogger.callAppenders(event);
        }
    }

    private org.apache.log4j.Logger getLogger(LogRecord record) {
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            loggerName = DEFAULT_LOGGER_NAME;
        }
        return org.apache.log4j.Logger.getLogger((String)loggerName);
    }

    private org.apache.log4j.Level convertToLog4jLevel(Level level) {
        if (Level.FINEST.equals(level)) {
            return org.apache.log4j.Level.TRACE;
        }
        if (Level.FINER.equals(level)) {
            return org.apache.log4j.Level.DEBUG;
        }
        if (Level.FINE.equals(level)) {
            return org.apache.log4j.Level.DEBUG;
        }
        if (Level.INFO.equals(level)) {
            return org.apache.log4j.Level.INFO;
        }
        if (Level.WARNING.equals(level)) {
            return org.apache.log4j.Level.WARN;
        }
        if (Level.SEVERE.equals(level)) {
            return org.apache.log4j.Level.ERROR;
        }
        if (Level.ALL.equals(level)) {
            return org.apache.log4j.Level.ALL;
        }
        if (Level.OFF.equals(level)) {
            return org.apache.log4j.Level.OFF;
        }
        return org.apache.log4j.Level.DEBUG;
    }

    private LoggingEvent convertToLoggingEvent(LogRecord record, org.apache.log4j.Logger logger, org.apache.log4j.Level level) {
        String message = this.formatMessage(record);
        String threadName = Thread.currentThread().getName();
        ThrowableInformation throwableInformation = record.getThrown() == null ? null : new ThrowableInformation(record.getThrown());
        LocationInfo locationInfo = new LocationInfo(null, record.getSourceClassName(), record.getSourceMethodName(), null);
        return new LoggingEvent(record.getSourceClassName(), (Category)logger, record.getMillis(), level, (Object)message, threadName, throwableInformation, null, locationInfo, null);
    }

    private String formatMessage(LogRecord record) {
        Object[] parameters;
        String message = record.getMessage();
        ResourceBundle bundle = record.getResourceBundle();
        if (bundle != null) {
            try {
                message = bundle.getString(message);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((parameters = record.getParameters()) != null && parameters.length > 0) {
            try {
                message = MessageFormat.format(message, parameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return message;
    }
}

