/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamLogger {
    private static final Log log = LogFactory.getLog(StreamLogger.class);
    private BufferedReader stream;
    private final Log logger;

    public StreamLogger(InputStream in, Log logger) {
        try {
            this.stream = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            log.warn((Object)"Failed to create input stream reader using 'UTF-8' encoding!", (Throwable)uee);
            this.stream = new BufferedReader(new InputStreamReader(in));
        }
        this.logger = logger;
    }

    public StreamLogger(InputStream in, String category) {
        this(in, LogFactory.getLog((String)category));
    }

    public void run() {
        try {
            String line = null;
            while ((line = this.stream.readLine()) != null) {
                this.logger.debug((Object)line);
            }
        }
        catch (IOException ex) {
            log.error((Object)"Error while logging stream:", (Throwable)ex);
        }
    }
}

