/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.xlt.agent.AgentInfo;
import com.xceptance.xlt.agent.CustomSamplerRunner;
import com.xceptance.xlt.api.engine.AbstractCustomSampler;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.util.PropertyHierarchy;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class CustomSamplersRunner
extends Thread {
    private final String CUSTOM_SAMPLER_DOMAIN = "com.xceptance.xlt.customSamplers";
    private final String CUSTOM_SAMPLER_CLASS = "class";
    private final String CUSTOM_SAMPLER_NAME = "name";
    private final String CUSTOM_SAMPLER_PROPERTIES = "property";
    private final String CUSTOM_SAMPLER_RUN_INTERVAL = "interval";
    private static final String THREAD_NAME_PREFIX = "CustomSampler";
    public static final String RESULT_DIRECTORY_NAME = "CustomSampler";
    private final List<AbstractCustomSampler> samplers = new ArrayList<AbstractCustomSampler>();
    private final AgentInfo agentInfo;

    public CustomSamplersRunner(AgentInfo agentInfo) {
        super(new ThreadGroup("CustomSampler"), "CustomSamplersRunner");
        this.agentInfo = agentInfo;
    }

    @Override
    public void run() {
        this.init();
        SessionImpl session = (SessionImpl)Session.getCurrent();
        session.setUserName("CustomSampler");
        session.setUserNumber(0);
        session.setAbsoluteUserNumber(0);
        session.setTotalUserCount(1);
        session.setUserCount(1);
        session.setAgentID(this.agentInfo.getAgentID());
        session.setAgentNumber(this.agentInfo.getAgentNumber());
        session.setTotalAgentCount(this.agentInfo.getTotalAgentCount());
        session.setLoadTest(true);
        for (AbstractCustomSampler sampler : this.samplers) {
            CustomSamplerRunner t = new CustomSamplerRunner(sampler, Thread.currentThread().getThreadGroup());
            t.setDaemon(true);
            t.start();
        }
    }

    private void init() {
        PropertyHierarchy samplerConfigurations = new PropertyHierarchy("com.xceptance.xlt.customSamplers");
        samplerConfigurations.set(XltProperties.getInstance().getPropertiesForKey("com.xceptance.xlt.customSamplers"));
        Set<String> samplerKeys = samplerConfigurations.getChildKeyFragments();
        for (String samplerKey : samplerKeys) {
            PropertyHierarchy property = samplerConfigurations.get(samplerKey);
            this.initSampler(property);
        }
    }

    private void initSampler(PropertyHierarchy samplerConfiguration) {
        String samplerClassName = samplerConfiguration.get("class").getValue();
        Properties samplerProperties = new Properties();
        PropertyHierarchy customSamplerProperties = samplerConfiguration.get("property");
        if (customSamplerProperties != null) {
            Set<String> propertyKeys = customSamplerProperties.getChildKeyFragments();
            for (String propertyKey : propertyKeys) {
                samplerProperties.setProperty(propertyKey, customSamplerProperties.get(propertyKey).getValue());
            }
        }
        AbstractCustomSampler customSampler = null;
        try {
            Class<?> c = Class.forName(samplerClassName);
            customSampler = (AbstractCustomSampler)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        if (customSampler != null) {
            customSampler.setProperties(samplerProperties);
            customSampler.setInterval(samplerConfiguration.get("interval").getValue());
            customSampler.setName(samplerConfiguration.get("name").getValue());
            this.samplers.add(customSampler);
        }
    }
}

