/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.xlt.agent.AbstractExecutionTimer;
import com.xceptance.xlt.agent.AgentInfo;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import com.xceptance.xlt.agentcontroller.TestUserStatus;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.engine.DataManagerImpl;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.util.TimerUtils;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class LoadTestRunner
extends Thread {
    private static final Log log = LogFactory.getLog(LoadTestRunner.class);
    private final TestUserConfiguration config;
    private final TestUserStatus status;
    private AbstractExecutionTimer timer;
    private final AgentInfo agentInfo;
    private volatile boolean aborted;

    public LoadTestRunner(TestUserConfiguration config, AgentInfo agentInfo, AbstractExecutionTimer timer) {
        super(new ThreadGroup(config.getUserId()), config.getUserId());
        this.config = config;
        this.agentInfo = agentInfo;
        this.timer = timer;
        this.status = new TestUserStatus();
        this.status.setUserName(config.getUserId());
    }

    public TestUserStatus getTestUserStatus() {
        return this.status;
    }

    @Override
    public void run() {
        try {
            long now = GlobalClock.getInstance().getTime();
            Class<?> testCaseClass = null;
            try {
                testCaseClass = Class.forName(this.config.getTestCaseClassName());
                this.checkTestCaseClass(testCaseClass);
            }
            catch (ClassNotFoundException cnf) {
                throw new RuntimeException("Could not find java class '" + this.config.getTestCaseClassName() + "'.");
            }
            int iterations = this.config.getNumberOfIterations();
            int warmUpPeriod = this.config.getWarmUpPeriod();
            int measurementPeriod = this.config.getMeasurementPeriod();
            int initialDelay = this.config.getInitialDelay();
            int duration = warmUpPeriod + measurementPeriod;
            this.status.setStartDate(now + (long)initialDelay);
            this.status.setEndDate(now + (long)initialDelay + (long)duration);
            SessionImpl session = (SessionImpl)Session.getCurrent();
            session.setUserCount(this.config.getNumberOfUsers());
            session.setUserName(this.config.getUserName());
            session.setUserNumber(this.config.getInstance());
            session.setAbsoluteUserNumber(this.config.getAbsoluteUserNumber());
            session.setTotalUserCount(this.config.getTotalUserCount());
            session.setLoadTest(true);
            session.setAgentID(this.agentInfo.getAgentID());
            session.setAgentNumber(this.agentInfo.getAgentNumber());
            session.setTotalAgentCount(this.agentInfo.getTotalAgentCount());
            DataManagerImpl dataMgr = session.getDataManager();
            dataMgr.setStartOfLoggingPeriod(now + (long)initialDelay + (long)warmUpPeriod);
            dataMgr.setEndOfLoggingPeriod(now + (long)initialDelay + (long)warmUpPeriod + (long)measurementPeriod);
            if (iterations != 0) {
                this.status.setMode(TestUserStatus.Mode.ITERATION);
                this.runIterations(testCaseClass, iterations);
            } else {
                this.status.setMode(TestUserStatus.Mode.TIME_PERIOD);
                if (duration != 0) {
                    this.runDuration(testCaseClass, duration);
                } else {
                    log.warn((Object)("Both number of iterations and computed duration are unspecified for test case: " + this.config.getTestCaseClassName()));
                }
            }
            if (this.aborted) {
                this.status.setState(TestUserStatus.State.Aborted);
            } else {
                this.status.setPercentageComplete(100);
                this.status.setState(TestUserStatus.State.Finished);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Failed to run test as user: " + this.getName()), (Throwable)ex);
            this.status.setState(TestUserStatus.State.Failed);
            this.status.setException(ex);
        }
    }

    public void setAborted() {
        this.aborted = true;
    }

    private void checkTestCaseClass(Class<?> testCaseClass) {
        if (testCaseClass.isAnnotationPresent(Ignore.class)) {
            throw new RuntimeException("Test class is annotated with @Ignore: " + testCaseClass.getName());
        }
        int testMethodCount = 0;
        for (Method method : testCaseClass.getMethods()) {
            if (!method.isAnnotationPresent(Test.class) || method.isAnnotationPresent(Ignore.class)) continue;
            ++testMethodCount;
        }
        if (testMethodCount != 1) {
            throw new RuntimeException("No or more than one active test method found in class: " + testCaseClass.getName());
        }
    }

    private void runIterations(Class<?> testCaseClass, int iterations) {
        String testClassName = testCaseClass == null ? this.config.getTestCaseClassName() : testCaseClass.toString();
        log.info((Object)("Load test thread started (" + testClassName + " / " + iterations + " iterations)"));
        for (int i = 0; i < iterations; ++i) {
            try {
                this.status.setState(TestUserStatus.State.Waiting);
                this.timer.waitForNextExecution();
                this.status.setState(TestUserStatus.State.Running);
                this.runTestCase(testCaseClass, this.status);
            }
            catch (InterruptedException ex) {
                break;
            }
            this.status.setPercentageComplete((i + 1) * 100 / iterations);
        }
        log.info((Object)"Load test thread finished.");
    }

    private void runDuration(Class<?> testCaseClass, int duration) {
        String testClassName = testCaseClass == null ? this.config.getTestCaseClassName() : testCaseClass.toString();
        log.info((Object)("Load test thread started (" + testClassName + " / " + duration / 1000 + " s)"));
        long startTime = GlobalClock.getInstance().getTime();
        while (true) {
            try {
                this.status.setState(TestUserStatus.State.Waiting);
                this.timer.waitForNextExecution();
                this.status.setState(TestUserStatus.State.Running);
                this.runTestCase(testCaseClass, this.status);
            }
            catch (InterruptedException ex) {
                break;
            }
            long now = GlobalClock.getInstance().getTime();
            this.status.setPercentageComplete((int)((now - startTime) * 100L / (long)duration));
        }
        log.info((Object)"Load test thread finished.");
    }

    protected void runTestCase(Class<?> testCaseClass, TestUserStatus status) throws InterruptedException {
        SessionImpl session = SessionImpl.getCurrent();
        if (session.wasMarkedAsExpired()) {
            throw new InterruptedException("User aborted as the load test is over");
        }
        long startTime = TimerUtils.getTime();
        session.startTransaction();
        Result result = new JUnitCore().run(new Class[]{testCaseClass});
        if (session.wasMarkedAsExpired()) {
            throw new InterruptedException("User aborted as the load test is over");
        }
        Thread.interrupted();
        long runTime = TimerUtils.getTime() - startTime;
        boolean failed = !result.wasSuccessful();
        Throwable failure = null;
        if (failed) {
            failure = ((Failure)result.getFailures().get(0)).getException();
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("Failure while executing test (user: '%s', output: '%s'):", session.getUserID(), session.getID()), failure);
            }
        }
        long now = GlobalClock.getInstance().getTime();
        DataManagerImpl dataManager = session.getDataManager();
        status.incrementIterations();
        status.addToTotalRuntime(runTime);
        status.setLastRuntime(runTime);
        status.setElapsedTime(now - status.getStartDate());
        status.setLastModifiedDate(now);
        status.setEvents(dataManager.getNumberOfEvents());
        if (failed) {
            status.incrementErrors();
        }
        if (session.isTransactionPending()) {
            session.setFailed(failed);
            session.setFailReason(failure);
            session.stopTransaction();
        }
        session.clearFailedActionName();
    }
}

