/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.caucho.hessian.client.EasyHessianProxyFactory;
import com.xceptance.common.net.UrlConnectionFactory;
import com.xceptance.xlt.agent.AgentConfiguration;
import com.xceptance.xlt.agent.AgentControllerWatcher;
import com.xceptance.xlt.agent.AgentInfo;
import com.xceptance.xlt.agent.AgentStatusPusher;
import com.xceptance.xlt.agent.CustomSamplersRunner;
import com.xceptance.xlt.agent.JvmResourceUsageDataGenerator;
import com.xceptance.xlt.agent.LoadTest;
import com.xceptance.xlt.agentcontroller.AgentControllerConfiguration;
import com.xceptance.xlt.agentcontroller.AgentControllerProxy;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.engine.GlobalClockImpl;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Main {
    private static final Log log = LogFactory.getLog(Main.class);
    private final String agentID;
    private final LoadTest loadTest;
    private final AgentStatusPusher statusPusher;
    private final AgentControllerWatcher watcher;
    private final JvmResourceUsageDataGenerator jvmStatsGenerator;
    private long startOfLoggingPeriod;
    private long endOfLoggingPeriod;
    private final CustomSamplersRunner customSamplersRunner;

    public Main(String[] args) throws Exception {
        String acRemoteAddress;
        int idx;
        if (args.length < 5) {
            System.err.println("The agent cannot be run stand-alone, but only from the agent controller.");
            System.exit(2);
        }
        this.agentID = args[1];
        AgentConfiguration config = new AgentConfiguration();
        AgentControllerConfiguration agentControllerConfig = new AgentControllerConfiguration(null);
        int port = Integer.parseInt(args[0]);
        URL url = new URL("https://" + args[2] + ":" + port);
        EasyHessianProxyFactory proxyFactory = new EasyHessianProxyFactory();
        proxyFactory.setUser(agentControllerConfig.getUserName());
        proxyFactory.setPassword(agentControllerConfig.getPassword());
        AgentControllerProxy agentController = new AgentControllerProxy(null, proxyFactory, new UrlConnectionFactory());
        agentController.startProxy(url);
        AgentInfo agentInfo = new AgentInfo(this.agentID, new File(config.getResultsDirectory(), this.agentID));
        int agentNumber = Integer.parseInt(args[3]);
        agentInfo.setAgentNumber(agentNumber);
        int totalAgentCount = Integer.parseInt(args[4]);
        agentInfo.setTotalAgentCount(totalAgentCount);
        AgentStatus status = new AgentStatus();
        String hostName = args[2];
        status.setAgentID(this.agentID);
        status.setHostName(hostName);
        List<TestUserConfiguration> loadProfile = agentController.getAgentLoadProfile(this.agentID);
        this.loadTest = new LoadTest(loadProfile, status, agentInfo);
        this.statusPusher = new AgentStatusPusher(agentController, status, config.getMaxErrors());
        this.statusPusher.setDaemon(true);
        this.watcher = new AgentControllerWatcher(this.loadTest);
        this.watcher.setDaemon(true);
        if (config.getUseMasterControllerTime()) {
            long referenceTimeDifference = agentController.getReferenceTimeDifference();
            ((GlobalClockImpl)GlobalClock.getInstance()).setReferenceTimeDifference(referenceTimeDifference);
        }
        String statsHost = hostName;
        int statsPort = port;
        if (args.length > 5 && (idx = (acRemoteAddress = args[5]).lastIndexOf(58)) > -1) {
            statsHost = acRemoteAddress.substring(0, idx);
            statsPort = Integer.parseInt(acRemoteAddress.substring(idx + 1));
        }
        this.determineOverallLoggingPeriod(loadProfile);
        this.jvmStatsGenerator = new JvmResourceUsageDataGenerator(this.agentID, statsHost, statsPort, this.startOfLoggingPeriod, this.endOfLoggingPeriod);
        this.jvmStatsGenerator.setDaemon(true);
        ShutdownHook shutdownHook = new ShutdownHook();
        shutdownHook.setPriority(10);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        if (agentNumber == 0) {
            this.customSamplersRunner = new CustomSamplersRunner(agentInfo);
            this.customSamplersRunner.setDaemon(true);
        } else {
            this.customSamplersRunner = null;
        }
    }

    private void determineOverallLoggingPeriod(List<TestUserConfiguration> loadProfile) {
        long start = Long.MAX_VALUE;
        long end = 0L;
        long now = GlobalClock.getInstance().getTime();
        for (TestUserConfiguration testUserConfiguration : loadProfile) {
            long startUp = now + (long)testUserConfiguration.getInitialDelay() + (long)testUserConfiguration.getWarmUpPeriod();
            start = Math.min(start, startUp);
            end = Math.max(end, startUp + (long)testUserConfiguration.getMeasurementPeriod());
        }
        this.startOfLoggingPeriod = start;
        this.endOfLoggingPeriod = end;
    }

    public void run() throws Exception {
        this.jvmStatsGenerator.start();
        this.watcher.start();
        this.statusPusher.start();
        if (this.customSamplersRunner != null) {
            this.customSamplersRunner.start();
        }
        this.loadTest.run();
    }

    public static void main(String[] args) {
        Main main = null;
        try {
            main = new Main(args);
        }
        catch (Exception ex) {
            log.fatal((Object)"Failed to initialize load test agent.", (Throwable)ex);
            System.exit(2);
        }
        try {
            main.run();
        }
        catch (Exception ex) {
            log.fatal((Object)"Failed to run load test agent.", (Throwable)ex);
            System.exit(1);
        }
        log.info((Object)"Finished load test successfully.");
        System.exit(0);
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            Main.this.loadTest.abort();
            Main.this.statusPusher.pushStatus();
        }
    }
}

