/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileManagerServlet
extends HttpServlet {
    private static final long serialVersionUID = -4559286002497439251L;
    private static final Log log = LogFactory.getLog(FileManagerServlet.class);
    static final String SERVLET_PATH = "/fileManager/";
    static final String SERVLET_MAPPING = "/fileManager/*";
    private final File rootDirectory;

    public FileManagerServlet(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        FileInputStream in = null;
        String fileName = this.getFileName(req);
        try {
            log.debug((Object)("File being downloaded: " + fileName));
            if (fileName == null) {
                resp.setStatus(400);
            } else {
                File file = new File(this.rootDirectory, fileName);
                in = new FileInputStream(file);
                resp.setContentLength((int)file.length());
                ServletOutputStream out = resp.getOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
                resp.setStatus(200);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error while file is downloaded: " + fileName), (Throwable)ex);
            resp.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        FileOutputStream out = null;
        String fileName = this.getFileName(req);
        try {
            log.debug((Object)("File being uploaded: " + fileName));
            if (fileName == null) {
                resp.setStatus(400);
            } else {
                File file = new File(this.rootDirectory, fileName);
                out = new FileOutputStream(file);
                ServletInputStream in = req.getInputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
                resp.setStatus(200);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error while file is uploaded: " + fileName), (Throwable)ex);
            resp.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    private String getFileName(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            return null;
        }
        if (pathInfo.charAt(0) == '/') {
            if (pathInfo.length() == 1) {
                return null;
            }
            pathInfo = pathInfo.substring(1);
        }
        return pathInfo;
    }
}

