/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.actions;

import com.xceptance.xlt.api.actions.RunMethodStateException;
import com.xceptance.xlt.api.engine.ActionData;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.util.XltRandom;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.util.TimerUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractAction {
    private static final String THINKTIME_PROPERTY_NAME = "com.xceptance.xlt.thinktime.action";
    private static final String THINKTIME_DEVIATION_PROPERTY_NAME = "com.xceptance.xlt.thinktime.action.deviation";
    private AbstractAction previousAction;
    private String timerName;
    private int thinkTime = 0;
    private int thinkTimeDeviation = 0;
    private boolean runAlreadyExecuted = false;
    private boolean preValidationFailed = false;
    private boolean preValidateExecuted = false;

    protected AbstractAction(AbstractAction previousAction, String timerName) {
        this.previousAction = previousAction;
        if (timerName == null) {
            timerName = this.getClass().getSimpleName();
        } else if (StringUtils.isBlank((CharSequence)timerName)) {
            timerName = this.getClass().getSimpleName();
            XltLogger.runTimeLogger.warn((Object)("A timer name should not be blank or empty, used \"" + timerName + "\" instead!"));
        }
        this.timerName = timerName;
        this.thinkTime = XltProperties.getInstance().getProperty(THINKTIME_PROPERTY_NAME, 0);
        this.thinkTimeDeviation = XltProperties.getInstance().getProperty(THINKTIME_DEVIATION_PROPERTY_NAME, 0);
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info((Object)("### " + timerName + " constructed..."));
        }
    }

    public AbstractAction getPreviousAction() {
        if (this.runAlreadyExecuted) {
            throw new RunMethodStateException("run() was already called. Action state not valid any longer.");
        }
        return this.previousAction;
    }

    public String getTimerName() {
        return this.timerName;
    }

    public abstract void preValidate() throws Exception;

    protected abstract void execute() throws Exception;

    protected abstract void postValidate() throws Exception;

    public boolean preValidateSafe() {
        if (this.runAlreadyExecuted) {
            throw new RunMethodStateException("Cannot execute preValidateSafe() because run() was already executed.");
        }
        if (this.preValidateExecuted) {
            if (XltLogger.runTimeLogger.isDebugEnabled()) {
                XltLogger.runTimeLogger.debug((Object)("# " + this.timerName + " - preValidateSafe() was already called"));
            }
            return !this.preValidationFailed;
        }
        this.preValidationFailed = false;
        try {
            if (XltLogger.runTimeLogger.isDebugEnabled()) {
                XltLogger.runTimeLogger.debug((Object)("# " + this.timerName + " - preValidateSafe()"));
            }
            this.preValidateExecuted = true;
            this.preValidate();
        }
        catch (AssertionError ae) {
            if (XltLogger.runTimeLogger.isDebugEnabled()) {
                XltLogger.runTimeLogger.debug((Object)("# " + this.timerName + " - preValidate() failed:"), (Throwable)((Object)ae));
            }
            this.preValidationFailed = true;
        }
        catch (Throwable e) {
            XltLogger.runTimeLogger.warn((Object)"Unexpected error during prevalidation step, continuing without reporting an error", e);
            this.preValidationFailed = true;
        }
        return !this.preValidationFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Throwable {
        boolean failed;
        if (this.runAlreadyExecuted) {
            throw new RunMethodStateException();
        }
        SessionImpl session = SessionImpl.getCurrent();
        session.checkState();
        session.setCurrentActionName(this.timerName);
        boolean interrupted = false;
        Throwable t = null;
        ActionData actionData = new ActionData(this.timerName);
        long start = 0L;
        if (session.isExecuteThinkTime()) {
            this.executeThinkTime();
        } else {
            session.setExecuteThinkTime(true);
        }
        try {
            try {
                block41: {
                    block40: {
                        if (this.preValidateExecuted) break block40;
                        try {
                            this.preValidateExecuted = true;
                            if (XltLogger.runTimeLogger.isDebugEnabled()) {
                                XltLogger.runTimeLogger.debug((Object)("# " + this.timerName + " - preValidate()"));
                            }
                            start = TimerUtils.getTime();
                            this.preValidate();
                        }
                        catch (Throwable e) {
                            try {
                                this.logError("Prevalidation step failed", e);
                                this.preValidationFailed = true;
                                t = e;
                                throw e;
                            }
                            catch (Throwable throwable) {
                                if (XltLogger.runTimeLogger.isDebugEnabled()) {
                                    XltLogger.runTimeLogger.debug((Object)String.format("# %s - preValidate() finished after %d ms", this.timerName, TimerUtils.getTime() - start));
                                }
                                throw throwable;
                            }
                        }
                        if (XltLogger.runTimeLogger.isDebugEnabled()) {
                            XltLogger.runTimeLogger.debug((Object)String.format("# %s - preValidate() finished after %d ms", this.timerName, TimerUtils.getTime() - start));
                        }
                        break block41;
                    }
                    if (XltLogger.runTimeLogger.isDebugEnabled()) {
                        XltLogger.runTimeLogger.debug((Object)("# " + this.timerName + " - preValidate() already called"));
                    }
                    if (this.preValidationFailed) {
                        throw new RunMethodStateException("Prevalidate() was already called in safe mode and failed. Check your test flow and do not call run() in case preValidateSafe() returned false.");
                    }
                }
                session.checkState();
                long runTime = 0L;
                try {
                    if (XltLogger.runTimeLogger.isDebugEnabled()) {
                        XltLogger.runTimeLogger.debug((Object)("# " + this.timerName + " - execute()"));
                    }
                    start = TimerUtils.getTime();
                    try {
                        actionData.setTime();
                        this.execute();
                    }
                    finally {
                        runTime = TimerUtils.getTime() - start;
                        actionData.setRunTime(runTime);
                    }
                }
                catch (Throwable e) {
                    try {
                        this.logError("Execution step failed", e);
                        t = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (XltLogger.runTimeLogger.isDebugEnabled()) {
                            XltLogger.runTimeLogger.debug((Object)String.format("# %s - execute() finished after %d ms", this.timerName, runTime));
                        }
                        throw throwable;
                    }
                }
                if (XltLogger.runTimeLogger.isDebugEnabled()) {
                    XltLogger.runTimeLogger.debug((Object)String.format("# %s - execute() finished after %d ms", this.timerName, runTime));
                }
            }
            finally {
                this.previousAction = null;
                this.runAlreadyExecuted = true;
            }
            session.checkState();
            if (XltLogger.runTimeLogger.isDebugEnabled()) {
                XltLogger.runTimeLogger.debug((Object)("# " + this.timerName + " - postValidate()"));
            }
            try {
                start = TimerUtils.getTime();
                this.postValidate();
            }
            catch (Throwable e) {
                try {
                    this.logError("Postvalidation step failed", e);
                    t = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (XltLogger.runTimeLogger.isDebugEnabled()) {
                        XltLogger.runTimeLogger.debug((Object)String.format("# %s - postValidate() finished after %d ms", this.timerName, TimerUtils.getTime() - start));
                    }
                    throw throwable;
                }
            }
            if (XltLogger.runTimeLogger.isDebugEnabled()) {
                XltLogger.runTimeLogger.debug((Object)String.format("# %s - postValidate() finished after %d ms", this.timerName, TimerUtils.getTime() - start));
            }
            failed = t != null;
        }
        catch (InterruptedException ie) {
            try {
                interrupted = true;
                t = ie;
                throw ie;
            }
            catch (Throwable throwable) {
                boolean failed2 = t != null;
                actionData.setFailed(failed2);
                if (!interrupted) {
                    Session.getCurrent().getDataManager().logDataRecord(actionData);
                    Session.getCurrent().setFailed(failed2);
                    ((SessionImpl)Session.getCurrent()).setFailReason(t);
                }
                throw throwable;
            }
        }
        actionData.setFailed(failed);
        if (!interrupted) {
            Session.getCurrent().getDataManager().logDataRecord(actionData);
            Session.getCurrent().setFailed(failed);
            ((SessionImpl)Session.getCurrent()).setFailReason(t);
        }
        session.setCurrentActionName(null);
    }

    private void logError(String msg, Throwable e) {
        Session session = Session.getCurrent();
        String logMessage = String.format("%s (user: '%s', output: '%s'): %s", msg, session.getUserID(), session.getID(), e.getMessage());
        XltLogger.runTimeLogger.error((Object)logMessage, e);
    }

    protected void executeThinkTime() throws InterruptedException {
        long resultingThinkTime = Math.max(0, XltRandom.nextIntWithDeviation(this.thinkTime, this.thinkTimeDeviation));
        Logger logger = XltLogger.runTimeLogger;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Executing action think time wait (" + resultingThinkTime + " ms)..."));
        }
        if (resultingThinkTime > 0L) {
            Thread.sleep(resultingThinkTime);
        }
    }

    public long getThinkTime() {
        return this.thinkTime;
    }

    public long getThinkTimeDeviation() {
        return this.thinkTimeDeviation;
    }

    public void setThinkTime(long thinkTime) {
        this.thinkTime = (int)thinkTime;
    }

    public void setThinkTimeDeviation(long thinkTimeDeviation) {
        this.thinkTimeDeviation = (int)thinkTimeDeviation;
    }

    public void setThinkTime(int thinkTime) {
        this.thinkTime = thinkTime;
    }

    public void setThinkTimeDeviation(int thinkTimeDeviation) {
        this.thinkTimeDeviation = thinkTimeDeviation;
    }

    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }
}

