/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.util;

import com.xceptance.common.util.RouteMessagesToLog4jHandler;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;

public final class XltLogger {
    private static final String RUNTIME = "runtime";
    public static final Logger runTimeLogger = Logger.getLogger((String)"runtime");

    public static boolean setupLogging(String fileName) {
        if (!new File(fileName).exists()) {
            String errMsg = String.format("Problems during setup of property file '%s'. This is not necessarily an error.", fileName);
            System.err.println(errMsg);
            return false;
        }
        PropertyConfigurator.configure((String)fileName);
        return true;
    }

    public static void initLogging() {
        Logger rootLogger = Logger.getRootLogger();
        if (StringUtils.isNotEmpty((CharSequence)System.getProperty("log4j.configuration")) && rootLogger.getAllAppenders().hasMoreElements()) {
            return;
        }
        rootLogger.removeAllAppenders();
        String FILENAME1 = XltLogger.getFilename1();
        String FILENAME2 = "samples/testsuite-posters/config/dev-log4j.properties";
        if (FILENAME1 != null && XltLogger.setupLogging(FILENAME1)) {
            if (runTimeLogger.isInfoEnabled()) {
                runTimeLogger.info((Object)("Logging property file location automatically set: " + FILENAME1));
            }
        } else if (XltLogger.setupLogging("samples/testsuite-posters/config/dev-log4j.properties")) {
            if (runTimeLogger.isInfoEnabled()) {
                runTimeLogger.info((Object)"Logging property file location automatically set: samples/testsuite-posters/config/dev-log4j.properties");
            }
        } else {
            XltLogger.setupLogging();
            runTimeLogger.warn((Object)"Logging property file not found. Setting defaults.");
        }
    }

    private static void setupLogging() {
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("[%d{HH:mm:ss,SSS}] %-5p [%t] - %m\n")));
        runTimeLogger.setLevel(Level.DEBUG);
    }

    private static String getFilename1() {
        FileObject configDir = XltExecutionContext.getCurrent().getTestSuiteConfigDir();
        if (configDir != null) {
            return new File(configDir.getName().getPath(), "dev-log4j.properties").getAbsolutePath();
        }
        runTimeLogger.warn((Object)"Unable to get access to configuration directory");
        return null;
    }

    static {
        XltLogger.initLogging();
        RouteMessagesToLog4jHandler.install();
        XltPropertiesImpl.getInstance(true);
    }
}

