/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.validators;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XHTMLValidator {
    private static final String propertyName = XHTMLValidator.class.getName() + ".enabled";
    private final boolean breakOnErrors;
    private final boolean breakOnWarnings;
    private final boolean enabled;

    public XHTMLValidator(boolean breakOnErrors, boolean breakOnWarnings) {
        this.breakOnErrors = breakOnErrors;
        this.breakOnWarnings = breakOnWarnings;
        this.enabled = XltProperties.getInstance().getProperty(propertyName, true);
    }

    public void validate(HtmlPage page) throws Exception {
        this.validate(page.getWebResponse().getContentAsString());
    }

    public void validate(LightWeightPage page) throws Exception {
        this.validate(page.getContent());
    }

    public void validate(String content) throws Exception {
        int i;
        int i2;
        StringBuilder sb;
        if (!this.enabled) {
            return;
        }
        LocalErrorHandler localErrorHandler = new LocalErrorHandler();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            parser.setEntityResolver(new LocalEntityResolver());
            parser.setErrorHandler(localErrorHandler);
            parser.parse(new InputSource(new StringReader(content)));
        }
        catch (ParserConfigurationException e) {
            XltLogger.runTimeLogger.error((Object)"Unable to setup parser for XHTML validation", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            XltLogger.runTimeLogger.error((Object)"Problems handling I/O for XHTML validation", (Throwable)e);
            throw e;
        }
        catch (SAXException e) {
            // empty catch block
        }
        List<String> errors = localErrorHandler.getErrors();
        List<String> warnings = localErrorHandler.getWarnings();
        if (this.breakOnErrors && !errors.isEmpty()) {
            sb = new StringBuilder();
            for (i2 = 0; i2 < errors.size(); ++i2) {
                sb.append("\n");
                sb.append(errors.get(i2));
            }
            Assert.fail((String)("XHTML Validation errors:" + sb.toString()));
        }
        if (this.breakOnWarnings && !warnings.isEmpty()) {
            sb = new StringBuilder();
            for (i2 = 0; i2 < warnings.size(); ++i2) {
                sb.append("\n");
                sb.append(warnings.get(i2));
            }
            Assert.fail((String)("XHTML Validation warnings: " + sb.toString()));
        }
        for (i = 0; i < errors.size(); ++i) {
            XltLogger.runTimeLogger.warn((Object)errors.get(i));
        }
        for (i = 0; i < warnings.size(); ++i) {
            XltLogger.runTimeLogger.warn((Object)warnings.get(i));
        }
    }

    public static XHTMLValidator getInstance() {
        return XHTMLValidator_Singleton._instance;
    }

    private static class LocalErrorHandler
    implements ErrorHandler {
        private final List<String> warnings = new ArrayList<String>();
        private final List<String> errors = new ArrayList<String>();

        private LocalErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) {
            this.warnings.add(this.buildMessage(exception));
        }

        @Override
        public void error(SAXParseException exception) {
            this.errors.add(this.buildMessage(exception));
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.errors.add(this.buildMessage(exception));
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public List<String> getWarnings() {
            return this.warnings;
        }

        private String buildMessage(SAXParseException exception) {
            StringBuilder msg = new StringBuilder(100);
            msg.append("Line:Column ");
            msg.append(exception.getLineNumber());
            msg.append(":");
            msg.append(exception.getColumnNumber());
            msg.append(" - ");
            msg.append(exception.getMessage());
            return msg.toString();
        }
    }

    private static class LocalEntityResolver
    implements EntityResolver {
        private LocalEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
            String[] tokens = systemID.split("/");
            InputStream stream = null;
            if (tokens != null && tokens.length > 0) {
                stream = this.getClass().getResourceAsStream("/dtds/" + tokens[tokens.length - 1]);
            }
            if (stream != null) {
                return new InputSource(new InputStreamReader(stream));
            }
            XltLogger.runTimeLogger.warn((Object)("Could not find local representation of entity '" + systemID + "'. Taking fallback to online version."));
            return new InputSource(systemID);
        }
    }

    private static class XHTMLValidator_Singleton {
        private static final XHTMLValidator _instance = new XHTMLValidator(true, true);

        private XHTMLValidator_Singleton() {
        }
    }
}

