/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.webdriver;

import com.google.common.collect.ImmutableMap;
import com.xceptance.common.lang.ReflectionUtils;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.clientperformance.ClientPerformanceExtensionConnector;
import com.xceptance.xlt.clientperformance.ClientPerformanceUtils;
import com.xceptance.xlt.clientperformance.WebExtConnectionHandler;
import com.xceptance.xlt.engine.SessionImpl;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class XltChromeDriver
extends ChromeDriver {
    private static final String PROPERTY_DOMAIN = "xlt.webDriver.chrome_clientperformance.";
    private static final String FIELD_NAME_ENVIRONMENT = "environment";
    private static final Log LOG = LogFactory.getLog(XltChromeDriver.class);
    private static final String PROPERTY_HEADLESS = "xlt.webDriver.chrome_clientperformance.screenless";
    private static final boolean HEADLESS_ENABLED;
    private static final String PROPERTY_RECORD_INCOMPLETE = "xlt.webDriver.chrome_clientperformance.recordIncomplete";
    private static final boolean RECORD_INCOMPLETE_ENABLED;
    private static final String EXTENSION_FILE_NAME = "xlt-timerrecorder-chrome";
    private static final String EXTENSION_FILE_ENDING = ".crx";
    private static File extensionFile;
    private static final int CONNECT_RETRY_COUNT = 5;
    private static final long CONNECT_RETRY_BASE_TIMEOUT = 500L;
    private static final float CONNECT_RETRY_TIMEOUT_FACTOR = 1.5f;
    private static final String PROPERTY_IGNORE_MISSING_DATA = "xlt.webDriver.chrome_clientperformance.ignoreMissingData";
    private static final boolean IGNORE_MISSING_DATA;
    private final WebExtConnectionHandler connectionHandler = WebExtConnectionHandler.newInstance("xlt.webDriver.chrome_clientperformance.");

    public XltChromeDriver() {
        this((ChromeDriverService)null, (ChromeOptions)null, HEADLESS_ENABLED);
    }

    public XltChromeDriver(ChromeOptions options) {
        this(null, options, HEADLESS_ENABLED);
    }

    public XltChromeDriver(ChromeOptions options, boolean screenless) {
        this(null, options, screenless);
    }

    public XltChromeDriver(ChromeDriverService service) {
        this(service, (ChromeOptions)null, HEADLESS_ENABLED);
    }

    public XltChromeDriver(ChromeDriverService service, ChromeOptions options) {
        this(service, options, HEADLESS_ENABLED);
    }

    public XltChromeDriver(ChromeDriverService service, ChromeOptions options, boolean screenless) {
        super(XltChromeDriver.modifyService(service, screenless), XltChromeDriver.modifyOptions(options));
        this.init();
    }

    @Deprecated
    public XltChromeDriver(Capabilities capabilities) {
        this(null, capabilities, HEADLESS_ENABLED);
    }

    @Deprecated
    public XltChromeDriver(Capabilities capabilities, boolean screenless) {
        this(null, capabilities, screenless);
    }

    @Deprecated
    public XltChromeDriver(ChromeDriverService service, Capabilities capabilities) {
        this(service, capabilities, HEADLESS_ENABLED);
    }

    @Deprecated
    public XltChromeDriver(ChromeDriverService service, Capabilities capabilities, boolean screenless) {
        this(service, XltChromeDriver.createOptions(capabilities), screenless);
    }

    private void init() {
        try {
            LOG.debug((Object)"Starting extension communication server");
            this.connectionHandler.start();
            this.initConnect(5);
        }
        catch (ClientPerformanceExtensionConnector.CommunicationException e) {
            throw new WebDriverException("Starting extension communication failed", (Throwable)e);
        }
    }

    private void initConnect(int retryCount) {
        String url = "data:,xltParameters?xltPort=" + this.connectionHandler.getPort() + "&clientID=" + this.connectionHandler.getID() + "&recordIncompleted=" + RECORD_INCOMPLETE_ENABLED;
        long timeout = 500L;
        int tries = 0;
        do {
            ++tries;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Try: #" + tries + ". Sending connect parameters: " + url));
            }
            this.get(url);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Waiting for " + timeout + " ms."));
                }
                this.connectionHandler.waitForConnect(timeout);
            }
            catch (ClientPerformanceExtensionConnector.CommunicationException | InterruptedException e) {
                LOG.warn((Object)"Error while waiting for connection.", (Throwable)e);
            }
            catch (TimeoutException e) {
                LOG.debug((Object)"Timeout while waiting for connect.");
            }
            timeout = (long)((float)timeout * 1.5f);
        } while (!this.connectionHandler.isConnected() && tries < retryCount);
    }

    private static ChromeDriverService modifyService(ChromeDriverService service, boolean headless) {
        String display;
        service = (ChromeDriverService)ObjectUtils.defaultIfNull((Object)service, (Object)ChromeDriverService.createDefaultService());
        if (headless && (display = ClientPerformanceUtils.getDisplay()) != null) {
            ImmutableMap environment = (ImmutableMap)ReflectionUtils.readField(ChromeDriverService.class, service, FIELD_NAME_ENVIRONMENT);
            ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
            if (environment != null) {
                mapBuilder.putAll((Map)environment);
            }
            mapBuilder.put((Object)"DISPLAY", (Object)display);
            mapBuilder.put((Object)"DBUS_SESSION_BUS_ADDRESS", (Object)"/dev/null");
            ImmutableMap newEnvironment = mapBuilder.build();
            ReflectionUtils.writeField(ChromeDriverService.class, service, FIELD_NAME_ENVIRONMENT, newEnvironment);
        }
        return service;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ChromeOptions createOptions(Capabilities capabilities) {
        DesiredCapabilities caps = (DesiredCapabilities)ObjectUtils.defaultIfNull((Object)capabilities, (Object)DesiredCapabilities.chrome());
        Object rawOptions = caps.getCapability("goog:chromeOptions");
        if (rawOptions == null) return new ChromeOptions();
        if (rawOptions instanceof Map) {
            Map optionsMap = (Map)rawOptions;
            return XltChromeDriver.optionsFromMap(optionsMap);
        }
        if (!(rawOptions instanceof ChromeOptions)) throw new WebDriverException("Chrome options set, but is not an instance of ChromeOptions or Map: " + rawOptions.getClass().getName());
        return (ChromeOptions)rawOptions;
    }

    private static ChromeOptions optionsFromMap(Map<String, Object> optionsMap) {
        ChromeOptions opts = new ChromeOptions();
        block10: for (Map.Entry<String, Object> e : optionsMap.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            if (val == null) continue;
            switch (key) {
                case "binary": {
                    opts.setBinary((String)val);
                    continue block10;
                }
                case "extensions": {
                    opts.addEncodedExtensions((List)val);
                    continue block10;
                }
                case "args": {
                    opts.addArguments((List)val);
                    continue block10;
                }
            }
            opts.setExperimentalOption(key, val);
        }
        return opts;
    }

    private static ChromeOptions modifyOptions(ChromeOptions options) {
        if (extensionFile == null || !extensionFile.isFile()) {
            throw new WebDriverException("Chrome client performance extension not available (path: " + extensionFile + ")");
        }
        options = (ChromeOptions)ObjectUtils.defaultIfNull((Object)options, (Object)new ChromeOptions());
        options.addExtensions(new File[]{extensionFile});
        options.addArguments(new String[]{"--unlimited-storage"});
        return options;
    }

    public void close() {
        if (this.isConnected() && this.getWindowHandles().size() == 1) {
            this.quit();
        } else {
            super.close();
        }
    }

    public void quit() {
        if (!this.isConnected()) {
            LOG.debug((Object)"Driver already closed");
            return;
        }
        try {
            this.preQuit();
            LOG.debug((Object)"Closing extension communication");
            this.connectionHandler.stop();
        }
        catch (WebDriverException t) {
            LOG.warn((Object)"Error during driver shutdown", (Throwable)t);
            throw t;
        }
        catch (Throwable t) {
            LOG.warn((Object)"Error during driver shutdown", t);
        }
        finally {
            LOG.debug((Object)"Closing driver");
            super.quit();
            LOG.debug((Object)"Chrome client performance driver closed");
        }
    }

    private boolean isConnected() {
        return this.getSessionId() != null;
    }

    private void preQuit() {
        if (!this.isConnected()) {
            return;
        }
        if (!this.hasWindow()) {
            LOG.error((Object)"Failed to get client-performance metrics. All browser windows already closed.");
        } else {
            LOG.debug((Object)"Try to fetch and dump remaining client-performance metrics");
            if (!this.connectionHandler.isConnected()) {
                LOG.debug((Object)"Not connected. Try reconnect...");
                this.initConnect(5);
            }
            if (this.connectionHandler.isConnected()) {
                this.connectionHandler.reportRemainingPerformanceData();
            } else {
                String logMessage = "No connection to fetch remaining data. Maybe not all performance data is available.";
                if (IGNORE_MISSING_DATA) {
                    LOG.error((Object)"No connection to fetch remaining data. Maybe not all performance data is available.");
                    SessionImpl.logEvent(((Object)((Object)this)).getClass().getSimpleName(), "No connection to fetch remaining data. Maybe not all performance data is available.");
                } else {
                    throw new WebDriverException("No connection to fetch remaining data. Maybe not all performance data is available.");
                }
            }
        }
    }

    private boolean hasWindow() {
        try {
            return this.getWindowHandles().size() > 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Builder xltBuilder() {
        return new Builder();
    }

    static /* synthetic */ boolean access$000() {
        return HEADLESS_ENABLED;
    }

    static {
        XltProperties props = XltProperties.getInstance();
        HEADLESS_ENABLED = props.getProperty(PROPERTY_HEADLESS, false);
        RECORD_INCOMPLETE_ENABLED = props.getProperty(PROPERTY_RECORD_INCOMPLETE, false);
        IGNORE_MISSING_DATA = props.getProperty(PROPERTY_IGNORE_MISSING_DATA, true);
        try {
            File tmpFile = File.createTempFile(EXTENSION_FILE_NAME, EXTENSION_FILE_ENDING);
            tmpFile.deleteOnExit();
            URL extensionUrl = ClientPerformanceUtils.class.getResource("xlt-timerrecorder-chrome.crx");
            if (extensionUrl == null) {
                LOG.error((Object)"Failed to locate Chrome extension file in class path");
            } else {
                FileUtils.copyURLToFile((URL)extensionUrl, (File)tmpFile);
                extensionFile = tmpFile;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to unpack Chrome extension to temp folder", (Throwable)e);
        }
    }

    public static final class Builder {
        private ChromeDriverService service;
        private ChromeOptions options;
        private Capabilities capabilities;
        private boolean headless = XltChromeDriver.access$000();

        public Builder setService(ChromeDriverService service) {
            this.service = service;
            return this;
        }

        public Builder setOptions(ChromeOptions options) {
            this.options = options;
            return this;
        }

        @Deprecated
        public Builder setCapabilities(Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder setHeadless(boolean headless) {
            this.headless = headless;
            return this;
        }

        public XltChromeDriver build() {
            if (this.options != null && this.capabilities != null) {
                throw new IllegalStateException("Both options and capabilities were set. Use one of them only.");
            }
            if (this.options != null) {
                return new XltChromeDriver(this.service, this.options, this.headless);
            }
            return new XltChromeDriver(this.service, this.capabilities, this.headless);
        }
    }
}

