/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.webdriver;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.xceptance.common.lang.ReflectionUtils;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.clientperformance.ClientPerformanceExtensionConnector;
import com.xceptance.xlt.clientperformance.ClientPerformanceUtils;
import com.xceptance.xlt.clientperformance.WebExtConnectionHandler;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.Extension;
import org.openqa.selenium.firefox.internal.FileExtension;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public final class XltFirefoxDriver
extends FirefoxDriver {
    private static final String PROPERTY_DOMAIN = "xlt.webDriver.firefox_clientperformance.";
    private static final String PROPERTY_HEADLESS = "xlt.webDriver.firefox_clientperformance.screenless";
    private static final String PROPERTY_RECORD_INCOMPLETE = "xlt.webDriver.firefox_clientperformance.recordIncomplete";
    private static final String PROPERTY_RESPONSE_TIMEOUT = "xlt.webDriver.firefox_clientperformance.overrideResponseTimeout";
    private static final boolean HEADLESS_ENABLED;
    private static final boolean RECORD_INCOMPLETE_ENABLED;
    private static final boolean OVERRIDE_RESPONSE_TIMEOUT;
    private static final Log LOG;
    private static final String FIELD_NAME_ENVIRONMENT = "environment";
    private static final String FIELD_NAME_SERVICE = "service";
    private static final String HEADLESS_CAPABILITY = "xlt:headless";
    private static final String EXTENSION_FILE_NAME = "xlt-timerrecorder";
    private static final String EXTENSION_FILE_ENDING = ".xpi";
    private static File extensionFile;
    private final WebExtConnectionHandler connectionHandler = WebExtConnectionHandler.newInstance("xlt.webDriver.firefox_clientperformance.");

    public XltFirefoxDriver() {
        this((FirefoxOptions)null, HEADLESS_ENABLED);
    }

    public XltFirefoxDriver(FirefoxOptions options) {
        this(options, HEADLESS_ENABLED);
    }

    public XltFirefoxDriver(FirefoxOptions options, boolean screenless) {
        super(XltFirefoxDriver.modifyOptions(options, screenless));
        this.init();
    }

    @Deprecated
    public XltFirefoxDriver(Capabilities desiredCapabilities) {
        this(null, null, desiredCapabilities, null, HEADLESS_ENABLED);
    }

    @Deprecated
    public XltFirefoxDriver(Capabilities desiredCapabilities, boolean screenless) {
        this(null, null, desiredCapabilities, null, screenless);
    }

    @Deprecated
    public XltFirefoxDriver(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(null, null, desiredCapabilities, requiredCapabilities, HEADLESS_ENABLED);
    }

    @Deprecated
    public XltFirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities desiredCapabilities) {
        this(binary, profile, desiredCapabilities, null, HEADLESS_ENABLED);
    }

    @Deprecated
    public XltFirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(binary, profile, desiredCapabilities, requiredCapabilities, HEADLESS_ENABLED);
    }

    @Deprecated
    public XltFirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
        this(binary, profile, null, null, HEADLESS_ENABLED);
    }

    @Deprecated
    public XltFirefoxDriver(FirefoxProfile profile) {
        this(null, profile, null, null, HEADLESS_ENABLED);
    }

    @Deprecated
    public XltFirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities desiredCapabilities, Capabilities requiredCapabilities, boolean screenless) {
        this(XltFirefoxDriver.createOptions(binary, profile, desiredCapabilities, requiredCapabilities), screenless);
    }

    protected void startSession(Capabilities desiredCapabilities) {
        boolean headless = desiredCapabilities.is(HEADLESS_CAPABILITY);
        Capabilities caps = XltFirefoxDriver.dropHeadlessCap(desiredCapabilities);
        DriverCommandExecutor e = (DriverCommandExecutor)this.getCommandExecutor();
        DriverService service = (DriverService)ReflectionUtils.readInstanceField(e, FIELD_NAME_SERVICE);
        XltFirefoxDriver.modifyService(service, headless);
        super.startSession(caps);
    }

    private void init() {
        try {
            this.connectionHandler.start();
        }
        catch (ClientPerformanceExtensionConnector.CommunicationException e) {
            throw new WebDriverException("Starting extension communication failed", (Throwable)e);
        }
        this.get("data:,xltParameters?xltPort=" + this.connectionHandler.getPort() + "&clientID=" + this.connectionHandler.getID() + "&recordIncompleted=" + RECORD_INCOMPLETE_ENABLED);
    }

    public void close() {
        if (this.isConnected() && this.getWindowHandles().size() == 1) {
            this.quit();
        } else {
            super.close();
        }
    }

    public void quit() {
        if (!this.isConnected()) {
            LOG.debug((Object)"Driver already closed");
            return;
        }
        try {
            this.preQuit();
            LOG.debug((Object)"Closing extension communication");
            this.connectionHandler.stop();
        }
        catch (Throwable t) {
            LOG.warn((Object)"Failed to quit driver", t);
        }
        finally {
            LOG.debug((Object)"Closing driver");
            super.quit();
            LOG.debug((Object)"Firefox client performance driver closed");
        }
    }

    private void preQuit() {
        if (!this.isConnected()) {
            return;
        }
        if (!this.hasWindow()) {
            LOG.error((Object)"Failed to get client-performance metrics. All browser windows already closed.");
        } else {
            LOG.debug((Object)"Fetch and dump remaining client-performance metrics");
            this.connectionHandler.reportRemainingPerformanceData();
        }
    }

    private boolean hasWindow() {
        try {
            return !this.getWindowHandles().isEmpty();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isConnected() {
        return this.getSessionId() != null;
    }

    private static Capabilities dropHeadlessCap(Capabilities caps) {
        return new MutableCapabilities(Maps.filterKeys((Map)caps.asMap(), cap -> !HEADLESS_CAPABILITY.equals(cap)));
    }

    private static FirefoxOptions modifyOptions(FirefoxOptions options, boolean screenless) {
        options = (FirefoxOptions)ObjectUtils.defaultIfNull((Object)options, (Object)new FirefoxOptions());
        options.setProfile(XltFirefoxDriver.modifyProfile(options.getProfile()));
        options.setCapability(HEADLESS_CAPABILITY, screenless);
        return options;
    }

    private static FirefoxOptions createOptions(FirefoxBinary binary, FirefoxProfile profile, Capabilities desiredCaps, Capabilities requiredCaps) {
        MutableCapabilities caps = new MutableCapabilities((Capabilities)ObjectUtils.defaultIfNull((Object)desiredCaps, (Object)DesiredCapabilities.firefox())).merge(requiredCaps);
        FirefoxOptions options = new FirefoxOptions((Capabilities)caps);
        if (binary != null) {
            options.setBinary(binary);
        }
        if (profile != null) {
            options.setProfile(profile);
        }
        return options;
    }

    private static DriverService modifyService(DriverService service, boolean headless) {
        String display;
        if (service != null && headless && (display = ClientPerformanceUtils.getDisplay()) != null) {
            ImmutableMap environment = (ImmutableMap)ReflectionUtils.readField(DriverService.class, service, FIELD_NAME_ENVIRONMENT);
            ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
            if (environment != null) {
                mapBuilder.putAll((Map)environment);
            }
            mapBuilder.put((Object)"DISPLAY", (Object)display);
            mapBuilder.put((Object)"DBUS_SESSION_BUS_ADDRESS", (Object)"/dev/null");
            ImmutableMap newEnvironment = mapBuilder.build();
            ReflectionUtils.writeField(DriverService.class, service, FIELD_NAME_ENVIRONMENT, newEnvironment);
        }
        return service;
    }

    private static FirefoxProfile modifyProfile(FirefoxProfile profile) {
        if (extensionFile == null || !extensionFile.isFile()) {
            throw new WebDriverException("Firefox client-performance extension not available (path: " + extensionFile + ")");
        }
        profile = (FirefoxProfile)ObjectUtils.defaultIfNull((Object)profile, (Object)new FirefoxProfile());
        profile.addExtension(EXTENSION_FILE_NAME, (Extension)new FileExtension(extensionFile));
        profile.setAcceptUntrustedCertificates(true);
        profile.setPreference("app.update.enabled", false);
        profile.setPreference("extensions.update.enabled", false);
        if (OVERRIDE_RESPONSE_TIMEOUT) {
            int timeoutInSeconds = XltFirefoxDriver.getGlobalTimeoutInSeconds();
            profile.setPreference("network.http.response.timeout", timeoutInSeconds);
            profile.setPreference("network.http.tcp_keepalive.short_lived_connections", false);
            profile.setPreference("network.http.tcp_keepalive.long_lived_connections", false);
        }
        return profile;
    }

    private static int getGlobalTimeoutInSeconds() {
        String timeoutProp = "com.xceptance.xlt.timeout";
        long to = XltProperties.getInstance().getProperty("com.xceptance.xlt.timeout", 10000L);
        if (to <= 0L) {
            throw new WebDriverException(String.format("Value '%d' of property '%s' must be specified as positive integer", to, "com.xceptance.xlt.timeout"));
        }
        int toInSec = (int)(to / 1000L);
        if (to % 1000L > 0L) {
            ++toInSec;
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)String.format("Global timeout value of '%dms' will be rounded to the next second", to));
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)String.format("Will use '%ds' as response timeout for Firefox", toInSec));
        }
        return toInSec;
    }

    public static Builder xltBuilder() {
        return new Builder();
    }

    static /* synthetic */ boolean access$000() {
        return HEADLESS_ENABLED;
    }

    static {
        LOG = LogFactory.getLog(XltFirefoxDriver.class);
        XltProperties props = XltProperties.getInstance();
        HEADLESS_ENABLED = props.getProperty(PROPERTY_HEADLESS, false);
        RECORD_INCOMPLETE_ENABLED = props.getProperty(PROPERTY_RECORD_INCOMPLETE, false);
        OVERRIDE_RESPONSE_TIMEOUT = props.getProperty(PROPERTY_RESPONSE_TIMEOUT, false);
        try {
            File tmpFile = File.createTempFile(EXTENSION_FILE_NAME, EXTENSION_FILE_ENDING);
            tmpFile.deleteOnExit();
            URL extensionUrl = ClientPerformanceUtils.class.getResource("xlt-timerrecorder.xpi");
            if (extensionUrl == null) {
                LOG.error((Object)"Failed to locate Firefox extension file in class path");
            } else {
                FileUtils.copyURLToFile((URL)extensionUrl, (File)tmpFile);
                extensionFile = tmpFile;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to copy Firefox extension to temp folder", (Throwable)e);
        }
    }

    public static final class Builder {
        private FirefoxBinary binary;
        private FirefoxProfile profile;
        private Capabilities capabilities;
        private boolean headless = XltFirefoxDriver.access$000();
        private FirefoxOptions options;

        public Builder setBinary(FirefoxBinary binary) {
            this.binary = binary;
            return this;
        }

        public Builder setProfile(FirefoxProfile profile) {
            this.profile = profile;
            return this;
        }

        public Builder setCapabilities(Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Deprecated
        public Builder setRequiredCapabilities(Capabilities capabilities) {
            return this.setCapabilities(capabilities);
        }

        public Builder setHeadless(boolean headless) {
            this.headless = headless;
            return this;
        }

        public XltFirefoxDriver build() {
            if (this.options != null && this.capabilities != null) {
                throw new IllegalStateException("Both options and capabilities were set. Use one of them only.");
            }
            FirefoxOptions opts = (FirefoxOptions)ObjectUtils.defaultIfNull((Object)this.options, (Object)new FirefoxOptions());
            if (this.binary != null) {
                opts.setBinary(this.binary);
            }
            if (this.profile != null) {
                opts.setProfile(this.profile);
            }
            if (this.capabilities != null) {
                opts.merge(this.capabilities);
            }
            return new XltFirefoxDriver(opts, this.headless);
        }
    }
}

