/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.clientperformance;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.engine.PageLoadTimingData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.clientperformance.ClientPerformanceData;
import com.xceptance.xlt.clientperformance.ClientPerformanceRequest;
import com.xceptance.xlt.engine.GlobalClockImpl;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.util.UrlUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class PerformanceDataTransformator {
    private static final Log LOG = LogFactory.getLog(PerformanceDataTransformator.class);
    private final long timeDiff = ((GlobalClockImpl)GlobalClock.getInstance()).getReferenceTimeDifference();

    public static List<ClientPerformanceData> getTransformedPerformanceDataList(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            LOG.warn((Object)"No performance data available");
            return new ArrayList<ClientPerformanceData>();
        }
        return new PerformanceDataTransformator().getPerformanceDataList(json);
    }

    private List<ClientPerformanceData> getPerformanceDataList(String json) {
        JSONArray jsonData;
        ArrayList<ClientPerformanceData> dataList = new ArrayList<ClientPerformanceData>();
        try {
            jsonData = new JSONArray(json);
        }
        catch (JSONException jsonEx) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Failed to parse '" + json + "' as JSON array: " + jsonEx.getMessage()));
            }
            return dataList;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Creating data entries from json data - " + jsonData));
        }
        for (int i = 0; i < jsonData.length(); ++i) {
            JSONObject timingData = jsonData.optJSONObject(i);
            if (timingData == null) continue;
            ClientPerformanceData performanceData = new ClientPerformanceData();
            JSONArray requests = timingData.optJSONArray("requests");
            if (requests != null && requests.length() > 0) {
                performanceData.getRequestList().addAll(this.getRequestList(requests));
            } else {
                LOG.warn((Object)"Entry without request");
            }
            JSONObject timings = timingData.optJSONObject("timings");
            if (timings != null) {
                performanceData.getCustomDataList().addAll(this.getCustomDataList(timings));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Entry without timings data: " + timingData));
            }
            dataList.add(performanceData);
        }
        return dataList;
    }

    private List<ClientPerformanceRequest> getRequestList(JSONArray requests) {
        ArrayList<ClientPerformanceRequest> requestDataList = new ArrayList<ClientPerformanceRequest>();
        for (int requestIndex = 0; requestIndex < requests.length(); ++requestIndex) {
            JSONObject eachRequest = requests.optJSONObject(requestIndex);
            if (eachRequest == null) continue;
            try {
                ClientPerformanceRequest performanceRequest = this.buildRequest(eachRequest);
                requestDataList.add(performanceRequest);
                continue;
            }
            catch (JSONException jsonEx) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)("Failed to process request entry '" + eachRequest.toString() + "': " + jsonEx.getMessage()));
            }
        }
        return requestDataList;
    }

    private ClientPerformanceRequest buildRequest(JSONObject requestJSON) {
        ClientPerformanceRequest performanceRequest = new ClientPerformanceRequest();
        String contentType = null;
        performanceRequest.setStatusMessage(requestJSON.optString("statusText", null));
        if (!requestJSON.isNull("header")) {
            JSONArray requestHeader = requestJSON.getJSONArray("header");
            for (NameValuePair kv : PerformanceDataTransformator.getNameValuePairs(requestHeader)) {
                if (kv.getName().toLowerCase().equals("content-type")) {
                    if (contentType != null) {
                        LOG.debug((Object)"More than one 'Content-Type' header found");
                    }
                    contentType = kv.getValue();
                }
                performanceRequest.getRequestHeaders().add(kv);
            }
        }
        if (!requestJSON.getJSONObject("response").isNull("header")) {
            JSONArray responseHeader = requestJSON.getJSONObject("response").getJSONArray("header");
            performanceRequest.getResponseHeaders().addAll(PerformanceDataTransformator.getNameValuePairs(responseHeader));
        }
        String httpMethod = requestJSON.getString("method");
        performanceRequest.setHttpMethod(httpMethod);
        JSONObject requestBodys = requestJSON.getJSONObject("body");
        if (!requestBodys.equals(JSONObject.NULL)) {
            if ("POST".equals(StringUtils.defaultString((String)httpMethod).trim().toUpperCase())) {
                String encoding = this.cleanContentType(contentType);
                String encodingLC = encoding.toLowerCase();
                if (FormEncodingType.URL_ENCODED.getName().equals(encodingLC) || FormEncodingType.MULTIPART.getName().equals(encodingLC)) {
                    performanceRequest.setFormDataEncoding(encoding);
                    JSONObject postParameters = requestBodys.optJSONObject("formData");
                    List<NameValuePair> parameterList = PerformanceDataTransformator.getNameValuePairs(postParameters);
                    performanceRequest.getFormDataParameters().addAll(parameterList);
                    performanceRequest.setFormData(UrlUtils.getUrlEncodedParameters(parameterList));
                }
            }
            performanceRequest.setRawBody(this.getRawBodyText(requestBodys.optJSONArray("raw")));
        }
        this.fillRequestData(performanceRequest, requestJSON);
        return performanceRequest;
    }

    private String getRawBodyText(JSONArray jsonArray) {
        StringBuilder sb = new StringBuilder();
        if (jsonArray != null) {
            int l = jsonArray.length();
            for (int i = 0; i < l; ++i) {
                String text;
                JSONObject bodyPart = jsonArray.optJSONObject(i);
                if (bodyPart == null) continue;
                if (bodyPart.has("file")) {
                    text = bodyPart.optString("file");
                    if (StringUtils.isNotBlank((CharSequence)text)) {
                        text = "[file] " + text;
                    }
                } else if (bodyPart.has("base64")) {
                    text = bodyPart.optString("base64");
                    if (StringUtils.isNotBlank((CharSequence)text)) {
                        text = "[base64] " + text;
                    }
                } else {
                    text = bodyPart.optString("text");
                }
                if (text == null) continue;
                if (sb.length() > 0) {
                    sb.append("\r\n\r\n");
                }
                sb.append(text);
            }
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private void fillRequestData(ClientPerformanceRequest performanceRequest, JSONObject request) {
        RequestData requestData = performanceRequest.getRequestData();
        requestData.setName(request.getString("requestId"));
        requestData.setUrl(request.getString("url"));
        requestData.setContentType(this.cleanContentType(request.optString("contentType")));
        int statusCode = request.optInt("statusCode", 0);
        requestData.setResponseCode(statusCode);
        requestData.setFailed(request.optBoolean("error") || statusCode == 0 || statusCode >= 500);
        requestData.setBytesReceived(request.optInt("responseSize", 0));
        requestData.setBytesSent(request.optInt("requestSize", 0));
        requestData.setTime(!request.isNull("startTime") ? request.optLong("startTime", 0L) + this.timeDiff : 0L);
        requestData.setRunTime(request.optLong("duration", 0L));
        requestData.setConnectTime(request.optInt("connectTime", 0));
        requestData.setSendTime(request.optInt("sendTime", 0));
        requestData.setTimeToFirstBytes(request.optInt("firstBytesTime", 0));
        requestData.setTimeToLastBytes(request.optInt("lastBytesTime", 0));
        requestData.setReceiveTime(request.optInt("receiveTime", 0));
        requestData.setServerBusyTime(request.optInt("busyTime", 0));
        requestData.setDnsTime(request.optInt("dnsTime", 0));
        if (SessionImpl.COLLECT_ADDITIONAL_REQUEST_DATA) {
            requestData.setHttpMethod(performanceRequest.getHttpMethod());
            requestData.setFormData(performanceRequest.getFormData());
            requestData.setFormDataEncoding(performanceRequest.getFormDataEncoding());
        }
    }

    private String cleanContentType(String contentType) {
        return StringUtils.substringBefore((String)StringUtils.defaultString((String)contentType), (String)";").trim();
    }

    private List<PageLoadTimingData> getCustomDataList(JSONObject timings) {
        ArrayList<PageLoadTimingData> customDataList = new ArrayList<PageLoadTimingData>();
        String[] keys = JSONObject.getNames((JSONObject)timings);
        if (keys.length == 0) {
            LOG.warn((Object)"Timings data without values");
        }
        for (String eachKey : keys) {
            JSONObject timingEntry = timings.optJSONObject(eachKey);
            if (timingEntry == null) continue;
            long startTime = timingEntry.optLong("startTime", 0L);
            long runTime = timingEntry.optLong("duration", 0L);
            if (startTime > 0L && runTime > 0L) {
                PageLoadTimingData customData = new PageLoadTimingData();
                customData.setName(StringUtils.capitalize((String)eachKey));
                customData.setTime(startTime + this.timeDiff);
                customData.setRunTime(runTime);
                customDataList.add(customData);
                continue;
            }
            LOG.debug((Object)("Page-load timing entry for '" + eachKey + "' is incomplete and will be skipped"));
        }
        return customDataList;
    }

    private static List<NameValuePair> getNameValuePairs(JSONObject postParameters) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (postParameters != null) {
            String[] keys;
            for (String eachKey : keys = JSONObject.getNames((JSONObject)postParameters)) {
                JSONArray values = postParameters.getJSONArray(eachKey);
                for (int valueIndex = 0; valueIndex < values.length(); ++valueIndex) {
                    list.add(new NameValuePair(eachKey, values.getString(valueIndex)));
                }
            }
        }
        return list;
    }

    private static String getHeaderValue(JSONObject header) {
        String value = null;
        if (!header.isNull("value")) {
            value = header.getString("value");
        } else if (!header.isNull("binaryValue")) {
            value = header.get("binaryValue").toString();
        }
        return value;
    }

    private static List<NameValuePair> getNameValuePairs(JSONArray headers) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        for (int headerIndex = 0; headerIndex < headers.length(); ++headerIndex) {
            JSONObject eachHeader = headers.getJSONObject(headerIndex);
            String name = eachHeader.getString("name");
            String value = PerformanceDataTransformator.getHeaderValue(eachHeader);
            list.add(new NameValuePair(name, value));
        }
        return list;
    }

    private PerformanceDataTransformator() {
    }
}

