/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.clientperformance;

import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.clientperformance.ClientPerformanceData;
import com.xceptance.xlt.clientperformance.ClientPerformanceExtensionConnector;
import com.xceptance.xlt.clientperformance.ClientPerformanceMetrics;
import com.xceptance.xlt.clientperformance.PerformanceDataTransformator;
import com.xceptance.xlt.engine.SessionImpl;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class WebExtConnectionHandler
implements ClientPerformanceExtensionConnector.ConnectionListener {
    private static final Log LOG = LogFactory.getLog(WebExtConnectionHandler.class);
    private static final String PROPERTY_STORAGE_TIMEOUT = "storage.timeout";
    private static final int STORAGE_TIMEOUT_DEFAULT = 60000;
    private static final int CONNECTION_TIMEOUT_DEFAULT = 5000;
    private final SessionImpl session = SessionImpl.getCurrent();
    private final ClientPerformanceExtensionConnector connector = new ClientPerformanceExtensionConnector(this);
    private final int connectionTimeout;
    private final int messageTimeout;
    private final int storageTimeout;
    private ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection currentConnection;

    public WebExtConnectionHandler(int aConnectionTimeout, int aMessageTimeout, int aStorageTimeout) {
        this.connectionTimeout = aConnectionTimeout;
        this.messageTimeout = aMessageTimeout;
        this.storageTimeout = aStorageTimeout;
    }

    public static WebExtConnectionHandler newInstance(String propertyDomain) {
        XltProperties props = XltProperties.getInstance();
        int storageTimeout = props.getProperty(propertyDomain + PROPERTY_STORAGE_TIMEOUT, 60000);
        int connectionTimeout = 5000;
        int messageTimeout = storageTimeout + 2000;
        return new WebExtConnectionHandler(5000, messageTimeout, storageTimeout);
    }

    public boolean isConnected() {
        return this.currentConnection != null && this.currentConnection.isOpen();
    }

    public void waitForConnect(long timeout) throws TimeoutException, ClientPerformanceExtensionConnector.CommunicationException, InterruptedException {
        if (!this.isConnected()) {
            this.connector.waitForNextConnection(timeout);
        }
    }

    @Override
    public void onConnect(ClientPerformanceExtensionConnector connector, ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection connection) {
        LOG.debug((Object)("Connected: " + connection));
        if (this.currentConnection != null && this.currentConnection.isOpen()) {
            this.currentConnection.close();
        }
        this.currentConnection = connection;
    }

    @Override
    public void onMessage(ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection connection, JSONObject data, ClientPerformanceExtensionConnector.Responder responder) {
        block4: {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Message received: " + data));
            }
            try {
                if ("DUMP_PERFORMANCE_DATA".equals(data.optString("action"))) {
                    this.dumpPerformanceData(data.optString("performanceData"));
                }
            }
            catch (Throwable t) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)("Failed to handle message: " + data), t);
            }
        }
    }

    @Override
    public void onError(ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection connection, ClientPerformanceExtensionConnector.CommunicationException throwable) {
        LOG.error((Object)("Error from connection: " + connection), (Throwable)throwable);
    }

    @Override
    public void onClose(ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection connection) {
        LOG.debug((Object)("Extension connection closed: " + connection));
    }

    private void dumpPerformanceData(String rawData) {
        try {
            List<ClientPerformanceData> performanceData = PerformanceDataTransformator.getTransformedPerformanceDataList(rawData);
            ClientPerformanceMetrics.updatePerformanceData(this.session, performanceData);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Dumped client-performance metrics: " + rawData));
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)"Failed to dump client performance data", t);
        }
    }

    public String fetchPerformanceData() throws JSONException, TimeoutException, ClientPerformanceExtensionConnector.CommunicationException, InterruptedException {
        ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection conn = this.currentConnection;
        if (conn == null || !conn.isOpen()) {
            conn = this.connector.waitForNextConnection(this.connectionTimeout);
        }
        JSONObject message = new JSONObject();
        message.put("action", (Object)"GET_DATA");
        message.put("storageTimeout", this.storageTimeout);
        return conn.sendRequest(message, this.messageTimeout).getString("data");
    }

    public void reportRemainingPerformanceData() {
        try {
            String performanceDataRaw = this.fetchPerformanceData();
            this.dumpPerformanceData(performanceDataRaw);
        }
        catch (Throwable t) {
            LOG.warn((Object)"Failed to update remaining client performance data", t);
        }
    }

    public void start() throws ClientPerformanceExtensionConnector.CommunicationException {
        this.connector.start();
    }

    public void stop() {
        this.connector.stop(5000);
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public String getID() {
        return this.connector.getID();
    }
}

