/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.DataManager;
import com.xceptance.xlt.api.engine.EventData;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.metrics.Metrics;
import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class DataManagerImpl
implements DataManager {
    private static final Object mutex = new Object();
    private boolean loggingEnabled = true;
    private long startOfLoggingPeriod = Long.MIN_VALUE;
    private long endOfLoggingPeriod = Long.MAX_VALUE;
    private int numberOfEvents;
    private Logger logger;
    private final SessionImpl session;

    public int getNumberOfEvents() {
        return this.numberOfEvents;
    }

    protected DataManagerImpl(SessionImpl session) {
        this.session = session;
    }

    @Override
    public void logEvent(String eventName, String message) {
        EventData e = new EventData(eventName);
        e.setTestCaseName(this.session.getUserName());
        e.setMessage(message);
        this.logDataRecord(e);
    }

    @Override
    public synchronized void logDataRecord(Data stats) {
        Metrics.getInstance().updateMetrics(stats);
        this.logger = this.getTimerLogger();
        if (this.logger == null) {
            return;
        }
        long time = stats.getTime();
        if (this.loggingEnabled && this.startOfLoggingPeriod <= time && time <= this.endOfLoggingPeriod) {
            this.logger.info((Object)stats.toCSV().replaceAll("[\n\r]+", " "));
            if (stats instanceof EventData) {
                EventData event = (EventData)stats;
                if (XltLogger.runTimeLogger.isEnabledFor((Priority)Level.WARN)) {
                    XltLogger.runTimeLogger.warn((Object)String.format("EVENT: %2$s - %1$s - '%3$s'", event.getName(), event.getTestCaseName(), event.getMessage()));
                }
                ++this.numberOfEvents;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Logger getTimerLogger() {
        DataManagerImpl dataManagerImpl = this;
        synchronized (dataManagerImpl) {
            if (this.logger != null) {
                return this.logger;
            }
        }
        File file = this.getTimerFile();
        if (file == null) {
            return null;
        }
        DailyRollingFileAppender appender = new DailyRollingFileAppender();
        appender.setEncoding("UTF-8");
        appender.setLayout(new Layout(){

            public String format(LoggingEvent paramLoggingEvent) {
                return paramLoggingEvent.getMessage() + LINE_SEP;
            }

            public boolean ignoresThrowable() {
                return true;
            }

            public void activateOptions() {
            }
        });
        appender.setDatePattern("'.'yyyy-MM-dd");
        appender.setName("DailyAppender");
        appender.setFile(file.getAbsolutePath());
        appender.activateOptions();
        Logger logger = Logger.getLogger((String)this.session.getUserID());
        logger.setAdditivity(false);
        logger.setLevel(Level.ALL);
        logger.addAppender((Appender)appender);
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getTimerFile() {
        File file = new File(this.session.getResultsDirectory(), "timers.csv");
        try {
            Object object = mutex;
            synchronized (object) {
                file.getParentFile().mkdirs();
            }
            return file;
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.fatal((Object)("Cannot create file for output of timer: " + file), (Throwable)e);
            return null;
        }
    }

    @Override
    public long getStartOfLoggingPeriod() {
        return this.startOfLoggingPeriod;
    }

    @Override
    public long getEndOfLoggingPeriod() {
        return this.endOfLoggingPeriod;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void setStartOfLoggingPeriod(long time) {
        this.startOfLoggingPeriod = time;
    }

    @Override
    public void setEndOfLoggingPeriod(long time) {
        this.endOfLoggingPeriod = time;
    }

    @Override
    public void setLoggingEnabled(boolean state) {
        this.loggingEnabled = state;
    }

    public synchronized void resetLoggerFile() {
        this.logger = null;
    }
}

